/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.DebugQueryHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.DemoIntroScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerReconfigScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ChunkBatchSizeCalculator;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientConfigurationPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.DebugSampleSubscriber;
import net.minecraft.client.multiplayer.LevelLoadStatusManager;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PingDebugMonitor;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.client.multiplayer.TagCollector;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptRenderer;
import net.minecraft.client.resources.sounds.BeeAggressiveSoundInstance;
import net.minecraft.client.resources.sounds.BeeFlyingSoundInstance;
import net.minecraft.client.resources.sounds.GuardianAttackSoundInstance;
import net.minecraft.client.resources.sounds.MinecartSoundInstance;
import net.minecraft.client.resources.sounds.SnifferSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessagesTracker;
import net.minecraft.network.chat.LocalChatSession;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.BreezeDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.HiveDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundCommandsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundOpenBookPacket;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.Crypt;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfileKeyPair;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientCommandHandler;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.CreativeModeTabSearchRegistry;
import net.neoforged.neoforge.client.DimensionTransitionScreenManager;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketListener
extends ClientCommonPacketListenerImpl
implements ClientGamePacketListener,
TickablePacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component UNSECURE_SERVER_TOAST_TITLE = Component.translatable((String)"multiplayer.unsecureserver.toast.title");
    private static final Component UNSERURE_SERVER_TOAST = Component.translatable((String)"multiplayer.unsecureserver.toast");
    private static final Component INVALID_PACKET = Component.translatable((String)"multiplayer.disconnect.invalid_packet");
    private static final Component CHAT_VALIDATION_FAILED_ERROR = Component.translatable((String)"multiplayer.disconnect.chat_validation_failed");
    private static final Component RECONFIGURE_SCREEN_MESSAGE = Component.translatable((String)"connect.reconfiguring");
    private static final int PENDING_OFFSET_THRESHOLD = 64;
    private final GameProfile localGameProfile;
    private ClientLevel level;
    private ClientLevel.ClientLevelData levelData;
    private final Map<UUID, PlayerInfo> playerInfoMap = Maps.newHashMap();
    private final Set<PlayerInfo> listedPlayers = new ReferenceOpenHashSet();
    private final ClientAdvancements advancements;
    private final ClientSuggestionProvider suggestionsProvider;
    private final DebugQueryHandler debugQueryHandler = new DebugQueryHandler(this);
    private int serverChunkRadius = 3;
    private int serverSimulationDistance = 3;
    private final RandomSource random = RandomSource.createThreadSafe();
    public CommandDispatcher<SharedSuggestionProvider> commands = new CommandDispatcher();
    private final RecipeManager recipeManager;
    private final UUID id = UUID.randomUUID();
    private Set<ResourceKey<Level>> levels;
    private final RegistryAccess.Frozen registryAccess;
    private final FeatureFlagSet enabledFeatures;
    private final PotionBrewing potionBrewing;
    @Nullable
    private LocalChatSession chatSession;
    private SignedMessageChain.Encoder signedMessageEncoder = SignedMessageChain.Encoder.UNSIGNED;
    private LastSeenMessagesTracker lastSeenMessages = new LastSeenMessagesTracker(20);
    private MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final ChunkBatchSizeCalculator chunkBatchSizeCalculator = new ChunkBatchSizeCalculator();
    private final PingDebugMonitor pingDebugMonitor;
    private final DebugSampleSubscriber debugSampleSubscriber;
    private ConnectionType connectionType;
    @Nullable
    private LevelLoadStatusManager levelLoadStatusManager;
    private boolean serverEnforcesSecureChat;
    private boolean seenInsecureChatWarning = false;
    private volatile boolean closed;
    private final Scoreboard scoreboard = new Scoreboard();
    private final SessionSearchTrees searchTrees = new SessionSearchTrees();

    public ClientPacketListener(Minecraft p_253924_, Connection p_253614_, CommonListenerCookie p_295121_) {
        super(p_253924_, p_253614_, p_295121_);
        this.localGameProfile = p_295121_.localGameProfile();
        this.registryAccess = p_295121_.receivedRegistries();
        this.enabledFeatures = p_295121_.enabledFeatures();
        this.advancements = new ClientAdvancements(p_253924_, this.telemetryManager);
        this.suggestionsProvider = new ClientSuggestionProvider(this, p_253924_);
        this.pingDebugMonitor = new PingDebugMonitor(this, p_253924_.getDebugOverlay().getPingLogger());
        this.recipeManager = new RecipeManager((HolderLookup.Provider)this.registryAccess);
        this.debugSampleSubscriber = new DebugSampleSubscriber(this, p_253924_.getDebugOverlay());
        if (p_295121_.chatState() != null) {
            p_253924_.gui.getChat().restoreState(p_295121_.chatState());
        }
        this.connectionType = p_295121_.connectionType();
        this.potionBrewing = PotionBrewing.bootstrap(this.enabledFeatures, (RegistryAccess)this.registryAccess);
    }

    public ClientSuggestionProvider getSuggestionsProvider() {
        return this.suggestionsProvider;
    }

    public void close() {
        this.closed = true;
        this.clearLevel();
        this.telemetryManager.onDisconnect();
    }

    public void clearLevel() {
        this.level = null;
        this.levelLoadStatusManager = null;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public void handleLogin(ClientboundLoginPacket p_105030_) {
        ClientLevel.ClientLevelData clientlevel$clientleveldata;
        PacketUtils.ensureRunningOnSameThread((Packet)p_105030_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gameMode = new MultiPlayerGameMode(this.minecraft, this);
        CommonPlayerSpawnInfo commonplayerspawninfo = p_105030_.commonPlayerSpawnInfo();
        ArrayList list = Lists.newArrayList((Iterable)p_105030_.levels());
        Collections.shuffle(list);
        this.levels = Sets.newLinkedHashSet((Iterable)list);
        ResourceKey resourcekey = commonplayerspawninfo.dimension();
        Holder holder = commonplayerspawninfo.dimensionType();
        this.serverChunkRadius = p_105030_.chunkRadius();
        this.serverSimulationDistance = p_105030_.simulationDistance();
        boolean flag = commonplayerspawninfo.isDebug();
        boolean flag1 = commonplayerspawninfo.isFlat();
        this.levelData = clientlevel$clientleveldata = new ClientLevel.ClientLevelData(Difficulty.NORMAL, p_105030_.hardcore(), flag1);
        this.level = new ClientLevel(this, clientlevel$clientleveldata, resourcekey, holder, this.serverChunkRadius, this.serverSimulationDistance, this.minecraft::getProfiler, this.minecraft.levelRenderer, flag, commonplayerspawninfo.seed());
        this.minecraft.setLevel(this.level, ReceivingLevelScreen.Reason.OTHER);
        if (this.minecraft.player == null) {
            this.minecraft.player = this.minecraft.gameMode.createPlayer(this.level, new StatsCounter(), new ClientRecipeBook());
            this.minecraft.player.setYRot(-180.0f);
            if (this.minecraft.getSingleplayerServer() != null) {
                this.minecraft.getSingleplayerServer().setUUID(this.minecraft.player.getUUID());
            }
        }
        this.minecraft.debugRenderer.clear();
        this.minecraft.player.resetPos();
        ClientHooks.firePlayerLogin((MultiPlayerGameMode)this.minecraft.gameMode, (LocalPlayer)this.minecraft.player, (Connection)this.minecraft.getConnection().connection);
        this.minecraft.player.setId(p_105030_.playerId());
        this.level.addEntity(this.minecraft.player);
        this.minecraft.player.input = new KeyboardInput(this.minecraft.options);
        this.minecraft.gameMode.adjustPlayer(this.minecraft.player);
        this.minecraft.cameraEntity = this.minecraft.player;
        this.startWaitingForNewLevel(this.minecraft.player, this.level, ReceivingLevelScreen.Reason.OTHER, null, null);
        this.minecraft.player.setReducedDebugInfo(p_105030_.reducedDebugInfo());
        this.minecraft.player.setShowDeathScreen(p_105030_.showDeathScreen());
        this.minecraft.player.setDoLimitedCrafting(p_105030_.doLimitedCrafting());
        this.minecraft.player.setLastDeathLocation(commonplayerspawninfo.lastDeathLocation());
        this.minecraft.player.setPortalCooldown(commonplayerspawninfo.portalCooldown());
        this.minecraft.gameMode.setLocalMode(commonplayerspawninfo.gameType(), commonplayerspawninfo.previousGameType());
        this.minecraft.options.setServerRenderDistance(p_105030_.chunkRadius());
        this.chatSession = null;
        this.lastSeenMessages = new LastSeenMessagesTracker(20);
        this.messageSignatureCache = MessageSignatureCache.createDefault();
        if (this.connection.isEncrypted()) {
            this.minecraft.getProfileKeyPairManager().prepareKeyPair().thenAcceptAsync(p_253341_ -> p_253341_.ifPresent(this::setKeyPair), (Executor)((Object)this.minecraft));
        }
        this.telemetryManager.onPlayerInfoReceived(commonplayerspawninfo.gameType(), p_105030_.hardcore());
        this.minecraft.quickPlayLog().log(this.minecraft);
        this.serverEnforcesSecureChat = p_105030_.enforcesSecureChat();
        if (this.serverData != null && !this.seenInsecureChatWarning && !this.enforcesSecureChat()) {
            SystemToast systemtoast = SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.UNSECURE_SERVER_WARNING, (Component)UNSECURE_SERVER_TOAST_TITLE, (Component)UNSERURE_SERVER_TOAST);
            this.minecraft.getToasts().addToast((Toast)systemtoast);
            this.seenInsecureChatWarning = true;
        }
    }

    public void handleAddEntity(ClientboundAddEntityPacket p_104958_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104958_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.createEntityFromPacket(p_104958_);
        if (entity != null) {
            entity.recreateFromPacket(p_104958_);
            this.level.addEntity(entity);
            this.postAddEntitySoundInstance(entity);
        } else {
            LOGGER.warn("Skipping Entity with id {}", (Object)p_104958_.getType());
        }
    }

    @Nullable
    private Entity createEntityFromPacket(ClientboundAddEntityPacket p_302232_) {
        EntityType entitytype = p_302232_.getType();
        if (entitytype == EntityType.PLAYER) {
            PlayerInfo playerinfo = this.getPlayerInfo(p_302232_.getUUID());
            if (playerinfo == null) {
                LOGGER.warn("Server attempted to add player prior to sending player info (Player id {})", (Object)p_302232_.getUUID());
                return null;
            }
            return new RemotePlayer(this.level, playerinfo.getProfile());
        }
        return entitytype.create(this.level);
    }

    private void postAddEntitySoundInstance(Entity p_233664_) {
        if (p_233664_ instanceof AbstractMinecart) {
            AbstractMinecart abstractminecart = (AbstractMinecart)((Object)p_233664_);
            this.minecraft.getSoundManager().play((SoundInstance)new MinecartSoundInstance(abstractminecart));
        } else if (p_233664_ instanceof Bee) {
            Bee bee = (Bee)((Object)p_233664_);
            boolean flag = bee.isAngry();
            Object beesoundinstance = flag ? new BeeAggressiveSoundInstance(bee) : new BeeFlyingSoundInstance(bee);
            this.minecraft.getSoundManager().queueTickingSound((TickableSoundInstance)beesoundinstance);
        }
    }

    public void handleAddExperienceOrb(ClientboundAddExperienceOrbPacket p_104960_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104960_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        double d0 = p_104960_.getX();
        double d1 = p_104960_.getY();
        double d2 = p_104960_.getZ();
        ExperienceOrb entity = new ExperienceOrb(this.level, d0, d1, d2, p_104960_.getValue());
        entity.syncPacketPositionCodec(d0, d1, d2);
        entity.setYRot(0.0f);
        entity.setXRot(0.0f);
        entity.setId(p_104960_.getId());
        this.level.addEntity(entity);
    }

    public void handleSetEntityMotion(ClientboundSetEntityMotionPacket p_105092_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105092_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105092_.getId());
        if (entity != null) {
            entity.lerpMotion(p_105092_.getXa(), p_105092_.getYa(), p_105092_.getZa());
        }
    }

    public void handleSetEntityData(ClientboundSetEntityDataPacket p_105088_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105088_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105088_.id());
        if (entity != null) {
            entity.getEntityData().assignValues(p_105088_.packedItems());
        }
    }

    public void handleTeleportEntity(ClientboundTeleportEntityPacket p_105124_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105124_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105124_.getId());
        if (entity != null) {
            double d0 = p_105124_.getX();
            double d1 = p_105124_.getY();
            double d2 = p_105124_.getZ();
            entity.syncPacketPositionCodec(d0, d1, d2);
            if (!entity.isControlledByLocalInstance()) {
                float f = (float)(p_105124_.getyRot() * 360) / 256.0f;
                float f1 = (float)(p_105124_.getxRot() * 360) / 256.0f;
                entity.lerpTo(d0, d1, d2, f, f1, 3);
                entity.setOnGround(p_105124_.isOnGround());
            }
        }
    }

    public void handleTickingState(ClientboundTickingStatePacket p_309203_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_309203_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (this.minecraft.level != null) {
            TickRateManager tickratemanager = this.minecraft.level.tickRateManager();
            tickratemanager.setTickRate(p_309203_.tickRate());
            tickratemanager.setFrozen(p_309203_.isFrozen());
        }
    }

    public void handleTickingStep(ClientboundTickingStepPacket p_308901_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_308901_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (this.minecraft.level != null) {
            TickRateManager tickratemanager = this.minecraft.level.tickRateManager();
            tickratemanager.setFrozenTicksToRun(p_308901_.tickSteps());
        }
    }

    public void handleSetCarriedItem(ClientboundSetCarriedItemPacket p_105078_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105078_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (Inventory.isHotbarSlot(p_105078_.getSlot())) {
            this.minecraft.player.getInventory().selected = p_105078_.getSlot();
        }
    }

    public void handleMoveEntity(ClientboundMoveEntityPacket p_105036_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105036_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = p_105036_.getEntity((Level)this.level);
        if (entity != null && !entity.isControlledByLocalInstance()) {
            if (p_105036_.hasPosition()) {
                VecDeltaCodec vecdeltacodec = entity.getPositionCodec();
                Vec3 vec3 = vecdeltacodec.decode((long)p_105036_.getXa(), (long)p_105036_.getYa(), (long)p_105036_.getZa());
                vecdeltacodec.setBase(vec3);
                float f = p_105036_.hasRotation() ? (float)(p_105036_.getyRot() * 360) / 256.0f : entity.lerpTargetYRot();
                float f1 = p_105036_.hasRotation() ? (float)(p_105036_.getxRot() * 360) / 256.0f : entity.lerpTargetXRot();
                entity.lerpTo(vec3.x(), vec3.y(), vec3.z(), f, f1, 3);
            } else if (p_105036_.hasRotation()) {
                float f2 = (float)(p_105036_.getyRot() * 360) / 256.0f;
                float f3 = (float)(p_105036_.getxRot() * 360) / 256.0f;
                entity.lerpTo(entity.lerpTargetX(), entity.lerpTargetY(), entity.lerpTargetZ(), f2, f3, 3);
            }
            entity.setOnGround(p_105036_.isOnGround());
        }
    }

    public void handleRotateMob(ClientboundRotateHeadPacket p_105068_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105068_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = p_105068_.getEntity((Level)this.level);
        if (entity != null) {
            float f = (float)(p_105068_.getYHeadRot() * 360) / 256.0f;
            entity.lerpHeadTo(f, 3);
        }
    }

    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket p_182633_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_182633_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        p_182633_.getEntityIds().forEach(p_205521_ -> this.level.removeEntity(p_205521_, Entity.RemovalReason.DISCARDED));
    }

    public void handleMovePlayer(ClientboundPlayerPositionPacket p_105056_) {
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        PacketUtils.ensureRunningOnSameThread((Packet)p_105056_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        Vec3 vec3 = player.getDeltaMovement();
        boolean flag = p_105056_.getRelativeArguments().contains(RelativeMovement.X);
        boolean flag1 = p_105056_.getRelativeArguments().contains(RelativeMovement.Y);
        boolean flag2 = p_105056_.getRelativeArguments().contains(RelativeMovement.Z);
        if (flag) {
            d0 = vec3.x();
            d1 = player.getX() + p_105056_.getX();
            player.xOld += p_105056_.getX();
            player.xo += p_105056_.getX();
        } else {
            d0 = 0.0;
            player.xOld = d1 = p_105056_.getX();
            player.xo = d1;
        }
        if (flag1) {
            d2 = vec3.y();
            d3 = player.getY() + p_105056_.getY();
            player.yOld += p_105056_.getY();
            player.yo += p_105056_.getY();
        } else {
            d2 = 0.0;
            player.yOld = d3 = p_105056_.getY();
            player.yo = d3;
        }
        if (flag2) {
            d4 = vec3.z();
            d5 = player.getZ() + p_105056_.getZ();
            player.zOld += p_105056_.getZ();
            player.zo += p_105056_.getZ();
        } else {
            d4 = 0.0;
            player.zOld = d5 = p_105056_.getZ();
            player.zo = d5;
        }
        player.setPos(d1, d3, d5);
        player.setDeltaMovement(d0, d2, d4);
        float f = p_105056_.getYRot();
        float f1 = p_105056_.getXRot();
        if (p_105056_.getRelativeArguments().contains(RelativeMovement.X_ROT)) {
            player.setXRot(player.getXRot() + f1);
            player.xRotO += f1;
        } else {
            player.setXRot(f1);
            player.xRotO = f1;
        }
        if (p_105056_.getRelativeArguments().contains(RelativeMovement.Y_ROT)) {
            player.setYRot(player.getYRot() + f);
            player.yRotO += f;
        } else {
            player.setYRot(f);
            player.yRotO = f;
        }
        this.connection.send((Packet<?>)new ServerboundAcceptTeleportationPacket(p_105056_.getId()));
        this.connection.send((Packet<?>)new ServerboundMovePlayerPacket.PosRot(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot(), false));
    }

    public void handleChunkBlocksUpdate(ClientboundSectionBlocksUpdatePacket p_105070_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105070_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        p_105070_.runUpdates((p_284633_, p_284634_) -> this.level.setServerVerifiedBlockState((BlockPos)p_284633_, (BlockState)((Object)p_284634_), 19));
    }

    public void handleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket p_194241_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_194241_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        int i = p_194241_.getX();
        int j = p_194241_.getZ();
        this.updateLevelChunk(i, j, p_194241_.getChunkData());
        ClientboundLightUpdatePacketData clientboundlightupdatepacketdata = p_194241_.getLightData();
        this.level.queueLightUpdate(() -> {
            this.applyLightData(i, j, clientboundlightupdatepacketdata);
            LevelChunk levelchunk = this.level.getChunkSource().getChunk(i, j, false);
            if (levelchunk != null) {
                this.enableChunkLight(levelchunk, i, j);
            }
        });
    }

    public void handleChunksBiomes(ClientboundChunksBiomesPacket p_275437_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_275437_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata : p_275437_.chunkBiomeData()) {
            this.level.getChunkSource().replaceBiomes(clientboundchunksbiomespacket$chunkbiomedata.pos().x, clientboundchunksbiomespacket$chunkbiomedata.pos().z, clientboundchunksbiomespacket$chunkbiomedata.getReadBuffer());
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata1 : p_275437_.chunkBiomeData()) {
            this.level.onChunkLoaded(new ChunkPos(clientboundchunksbiomespacket$chunkbiomedata1.pos().x, clientboundchunksbiomespacket$chunkbiomedata1.pos().z));
        }
        for (ClientboundChunksBiomesPacket.ChunkBiomeData clientboundchunksbiomespacket$chunkbiomedata2 : p_275437_.chunkBiomeData()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = this.level.getMinSection(); k < this.level.getMaxSection(); ++k) {
                        this.minecraft.levelRenderer.setSectionDirty(clientboundchunksbiomespacket$chunkbiomedata2.pos().x + i, k, clientboundchunksbiomespacket$chunkbiomedata2.pos().z + j);
                    }
                }
            }
        }
    }

    private void updateLevelChunk(int p_194199_, int p_194200_, ClientboundLevelChunkPacketData p_194201_) {
        this.level.getChunkSource().replaceWithPacketData(p_194199_, p_194200_, p_194201_.getReadBuffer(), p_194201_.getHeightmaps(), p_194201_.getBlockEntitiesTagsConsumer(p_194199_, p_194200_));
    }

    private void enableChunkLight(LevelChunk p_194213_, int p_194214_, int p_194215_) {
        LevelLightEngine levellightengine = this.level.getChunkSource().getLightEngine();
        LevelChunkSection[] alevelchunksection = p_194213_.getSections();
        ChunkPos chunkpos = p_194213_.getPos();
        for (int i = 0; i < alevelchunksection.length; ++i) {
            LevelChunkSection levelchunksection = alevelchunksection[i];
            int j = this.level.getSectionYFromSectionIndex(i);
            levellightengine.updateSectionStatus(SectionPos.of((ChunkPos)chunkpos, (int)j), levelchunksection.hasOnlyAir());
            this.level.setSectionDirtyWithNeighbors(p_194214_, j, p_194215_);
        }
    }

    public void handleForgetLevelChunk(ClientboundForgetLevelChunkPacket p_105014_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105014_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getChunkSource().drop(p_105014_.pos());
        this.queueLightRemoval(p_105014_);
    }

    private void queueLightRemoval(ClientboundForgetLevelChunkPacket p_194253_) {
        ChunkPos chunkpos = p_194253_.pos();
        this.level.queueLightUpdate(() -> {
            LevelLightEngine levellightengine = this.level.getLightEngine();
            levellightengine.setLightEnabled(chunkpos, false);
            for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
                SectionPos sectionpos = SectionPos.of((ChunkPos)chunkpos, (int)i);
                levellightengine.queueSectionData(LightLayer.BLOCK, sectionpos, null);
                levellightengine.queueSectionData(LightLayer.SKY, sectionpos, null);
            }
            for (int j = this.level.getMinSection(); j < this.level.getMaxSection(); ++j) {
                levellightengine.updateSectionStatus(SectionPos.of((ChunkPos)chunkpos, (int)j), true);
            }
        });
    }

    public void handleBlockUpdate(ClientboundBlockUpdatePacket p_104980_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104980_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.setServerVerifiedBlockState(p_104980_.getPos(), p_104980_.getBlockState(), 19);
    }

    public void handleConfigurationStart(ClientboundStartConfigurationPacket p_296485_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_296485_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.getChatListener().clearQueue();
        this.sendChatAcknowledgement();
        ChatComponent.State chatcomponent$state = this.minecraft.gui.getChat().storeState();
        this.minecraft.clearClientLevel((Screen)new ServerReconfigScreen(RECONFIGURE_SCREEN_MESSAGE, this.connection));
        this.connection.setupInboundProtocol(ConfigurationProtocols.CLIENTBOUND, new ClientConfigurationPacketListenerImpl(this.minecraft, this.connection, new CommonListenerCookie(this.localGameProfile, this.telemetryManager, this.registryAccess, this.enabledFeatures, this.serverBrand, this.serverData, this.postDisconnectScreen, this.serverCookies, chatcomponent$state, this.strictErrorHandling, this.customReportDetails, this.serverLinks, this.connectionType)));
        this.send((Packet<?>)ServerboundConfigurationAcknowledgedPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.SERVERBOUND);
    }

    public void handleTakeItemEntity(ClientboundTakeItemEntityPacket p_105122_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105122_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105122_.getItemId());
        LivingEntity livingentity = (LivingEntity)this.level.getEntity(p_105122_.getPlayerId());
        if (livingentity == null) {
            livingentity = this.minecraft.player;
        }
        if (entity != null) {
            if (entity instanceof ExperienceOrb) {
                this.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f, false);
            } else {
                this.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 1.4f + 2.0f, false);
            }
            this.minecraft.particleEngine.add(new ItemPickupParticle(this.minecraft.getEntityRenderDispatcher(), this.minecraft.renderBuffers(), this.level, entity, livingentity));
            if (entity instanceof ItemEntity) {
                ItemEntity itementity = (ItemEntity)entity;
                ItemStack itemstack = itementity.getItem();
                if (!itemstack.isEmpty()) {
                    itemstack.shrink(p_105122_.getAmount());
                }
                if (itemstack.isEmpty()) {
                    this.level.removeEntity(p_105122_.getItemId(), Entity.RemovalReason.DISCARDED);
                }
            } else if (!(entity instanceof ExperienceOrb)) {
                this.level.removeEntity(p_105122_.getItemId(), Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void handleSystemChat(ClientboundSystemChatPacket p_233708_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_233708_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.getChatListener().handleSystemMessage(p_233708_.content(), p_233708_.overlay());
    }

    public void handlePlayerChat(ClientboundPlayerChatPacket p_233702_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_233702_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Optional optional = p_233702_.body().unpack(this.messageSignatureCache);
        if (optional.isEmpty()) {
            this.connection.disconnect(INVALID_PACKET);
        } else {
            this.messageSignatureCache.push((SignedMessageBody)optional.get(), p_233702_.signature());
            UUID uuid = p_233702_.sender();
            PlayerInfo playerinfo = this.getPlayerInfo(uuid);
            if (playerinfo == null) {
                LOGGER.error("Received player chat packet for unknown player with ID: {}", (Object)uuid);
                this.minecraft.getChatListener().handleChatMessageError(uuid, p_233702_.chatType());
            } else {
                RemoteChatSession remotechatsession = playerinfo.getChatSession();
                SignedMessageLink signedmessagelink = remotechatsession != null ? new SignedMessageLink(p_233702_.index(), uuid, remotechatsession.sessionId()) : SignedMessageLink.unsigned((UUID)uuid);
                PlayerChatMessage playerchatmessage = new PlayerChatMessage(signedmessagelink, p_233702_.signature(), (SignedMessageBody)optional.get(), p_233702_.unsignedContent(), p_233702_.filterMask());
                playerchatmessage = playerinfo.getMessageValidator().updateAndValidate(playerchatmessage);
                if (playerchatmessage != null) {
                    this.minecraft.getChatListener().handlePlayerChatMessage(playerchatmessage, playerinfo.getProfile(), p_233702_.chatType());
                } else {
                    this.minecraft.getChatListener().handleChatMessageError(uuid, p_233702_.chatType());
                }
            }
        }
    }

    public void handleDisguisedChat(ClientboundDisguisedChatPacket p_251920_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_251920_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.getChatListener().handleDisguisedChatMessage(p_251920_.message(), p_251920_.chatType());
    }

    public void handleDeleteChat(ClientboundDeleteChatPacket p_241325_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_241325_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Optional optional = p_241325_.messageSignature().unpack(this.messageSignatureCache);
        if (optional.isEmpty()) {
            this.connection.disconnect(INVALID_PACKET);
        } else {
            this.lastSeenMessages.ignorePending((MessageSignature)optional.get());
            if (!this.minecraft.getChatListener().removeFromDelayedMessageQueue((MessageSignature)optional.get())) {
                this.minecraft.gui.getChat().deleteMessage((MessageSignature)optional.get());
            }
        }
    }

    public void handleAnimate(ClientboundAnimatePacket p_104968_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104968_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_104968_.getId());
        if (entity != null) {
            if (p_104968_.getAction() == 0) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.swing(InteractionHand.MAIN_HAND);
            } else if (p_104968_.getAction() == 3) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                livingentity1.swing(InteractionHand.OFF_HAND);
            } else if (p_104968_.getAction() == 2) {
                Player player = (Player)entity;
                player.stopSleepInBed(false, false);
            } else if (p_104968_.getAction() == 4) {
                this.minecraft.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.CRIT);
            } else if (p_104968_.getAction() == 5) {
                this.minecraft.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.ENCHANTED_HIT);
            }
        }
    }

    public void handleHurtAnimation(ClientboundHurtAnimationPacket p_265581_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_265581_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_265581_.id());
        if (entity != null) {
            entity.animateHurt(p_265581_.yaw());
        }
    }

    public void handleSetTime(ClientboundSetTimePacket p_105108_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105108_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.level.setGameTime(p_105108_.getGameTime());
        this.minecraft.level.setDayTime(p_105108_.getDayTime());
        this.telemetryManager.setTime(p_105108_.getGameTime());
    }

    public void handleSetSpawn(ClientboundSetDefaultSpawnPositionPacket p_105084_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105084_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.level.setDefaultSpawnPos(p_105084_.getPos(), p_105084_.getAngle());
    }

    public void handleSetEntityPassengersPacket(ClientboundSetPassengersPacket p_105102_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105102_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105102_.getVehicle());
        if (entity == null) {
            LOGGER.warn("Received passengers for unknown entity");
        } else {
            boolean flag = entity.hasIndirectPassenger(this.minecraft.player);
            entity.ejectPassengers();
            for (int i : p_105102_.getPassengers()) {
                Entity entity1 = this.level.getEntity(i);
                if (entity1 == null) continue;
                entity1.startRiding(entity, true);
                if (entity1 != this.minecraft.player || flag) continue;
                if (entity instanceof Boat) {
                    this.minecraft.player.yRotO = entity.getYRot();
                    this.minecraft.player.setYRot(entity.getYRot());
                    this.minecraft.player.setYHeadRot(entity.getYRot());
                }
                MutableComponent component = Component.translatable((String)"mount.onboard", (Object[])new Object[]{this.minecraft.options.keyShift.getTranslatedKeyMessage()});
                this.minecraft.gui.setOverlayMessage((Component)component, false);
                this.minecraft.getNarrator().sayNow((Component)component);
            }
        }
    }

    public void handleEntityLinkPacket(ClientboundSetEntityLinkPacket p_105090_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105090_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105090_.getSourceId());
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)entity;
            leashable.setDelayedLeashHolderId(p_105090_.getDestId());
        }
    }

    private static ItemStack findTotem(Player p_104928_) {
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack = p_104928_.getItemInHand(interactionhand);
            if (!itemstack.is(Items.TOTEM_OF_UNDYING)) continue;
            return itemstack;
        }
        return new ItemStack(Items.TOTEM_OF_UNDYING);
    }

    public void handleEntityEvent(ClientboundEntityEventPacket p_105010_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105010_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = p_105010_.getEntity((Level)this.level);
        if (entity != null) {
            switch (p_105010_.getEventId()) {
                case 21: {
                    this.minecraft.getSoundManager().play((SoundInstance)new GuardianAttackSoundInstance((Guardian)entity));
                    break;
                }
                case 35: {
                    int i = 40;
                    this.minecraft.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
                    this.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
                    if (entity != this.minecraft.player) break;
                    this.minecraft.gameRenderer.displayItemActivation(ClientPacketListener.findTotem(this.minecraft.player));
                    break;
                }
                case 63: {
                    this.minecraft.getSoundManager().play((SoundInstance)new SnifferSoundInstance((Sniffer)((Object)entity)));
                    break;
                }
                default: {
                    entity.handleEntityEvent(p_105010_.getEventId());
                }
            }
        }
    }

    public void handleDamageEvent(ClientboundDamageEventPacket p_270800_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_270800_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_270800_.entityId());
        if (entity != null) {
            entity.handleDamageEvent(p_270800_.getSource((Level)this.level));
        }
    }

    public void handleSetHealth(ClientboundSetHealthPacket p_105098_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105098_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.player.hurtTo(p_105098_.getHealth());
        this.minecraft.player.getFoodData().setFoodLevel(p_105098_.getFood());
        this.minecraft.player.getFoodData().setSaturation(p_105098_.getSaturation());
    }

    public void handleSetExperience(ClientboundSetExperiencePacket p_105096_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105096_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.player.setExperienceValues(p_105096_.getExperienceProgress(), p_105096_.getTotalExperience(), p_105096_.getExperienceLevel());
    }

    public void handleRespawn(ClientboundRespawnPacket p_105066_) {
        List<SynchedEntityData.DataValue<?>> list;
        PacketUtils.ensureRunningOnSameThread((Packet)p_105066_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        CommonPlayerSpawnInfo commonplayerspawninfo = p_105066_.commonPlayerSpawnInfo();
        ResourceKey resourcekey = commonplayerspawninfo.dimension();
        Holder holder = commonplayerspawninfo.dimensionType();
        LocalPlayer localplayer = this.minecraft.player;
        ResourceKey<Level> resourcekey1 = localplayer.level().dimension();
        boolean flag = resourcekey != resourcekey1;
        ReceivingLevelScreen.Reason receivinglevelscreen$reason = this.determineLevelLoadingReason(localplayer.isDeadOrDying(), resourcekey, resourcekey1);
        if (flag) {
            ClientLevel.ClientLevelData clientlevel$clientleveldata;
            Map<MapId, MapItemSavedData> map = this.level.getAllMapData();
            boolean flag1 = commonplayerspawninfo.isDebug();
            boolean flag2 = commonplayerspawninfo.isFlat();
            this.levelData = clientlevel$clientleveldata = new ClientLevel.ClientLevelData(this.levelData.getDifficulty(), this.levelData.isHardcore(), flag2);
            this.level = new ClientLevel(this, clientlevel$clientleveldata, resourcekey, holder, this.serverChunkRadius, this.serverSimulationDistance, this.minecraft::getProfiler, this.minecraft.levelRenderer, flag1, commonplayerspawninfo.seed());
            this.level.addMapData(map);
            this.minecraft.setLevel(this.level, receivinglevelscreen$reason);
        }
        this.minecraft.cameraEntity = null;
        if (localplayer.hasContainerOpen()) {
            localplayer.closeContainer();
        }
        LocalPlayer localplayer1 = p_105066_.shouldKeep((byte)2) ? this.minecraft.gameMode.createPlayer(this.level, localplayer.getStats(), localplayer.getRecipeBook(), localplayer.isShiftKeyDown(), localplayer.isSprinting()) : this.minecraft.gameMode.createPlayer(this.level, localplayer.getStats(), localplayer.getRecipeBook());
        this.startWaitingForNewLevel(localplayer1, this.level, receivinglevelscreen$reason, localplayer.isDeadOrDying() ? null : resourcekey, localplayer.isDeadOrDying() ? null : resourcekey1);
        localplayer1.setId(localplayer.getId());
        this.minecraft.player = localplayer1;
        if (flag) {
            this.minecraft.getMusicManager().stopPlaying();
        }
        this.minecraft.cameraEntity = localplayer1;
        if (p_105066_.shouldKeep((byte)2) && (list = localplayer.getEntityData().getNonDefaultValues()) != null) {
            localplayer1.getEntityData().assignValues(list);
        }
        if (p_105066_.shouldKeep((byte)1)) {
            localplayer1.getAttributes().assignAllValues(localplayer.getAttributes());
        } else {
            localplayer1.getAttributes().assignBaseValues(localplayer.getAttributes());
        }
        localplayer1.resetPos();
        ClientHooks.firePlayerRespawn((MultiPlayerGameMode)this.minecraft.gameMode, (LocalPlayer)localplayer, (LocalPlayer)localplayer1, (Connection)localplayer1.connection.connection);
        this.level.addEntity(localplayer1);
        localplayer1.setYRot(-180.0f);
        localplayer1.input = new KeyboardInput(this.minecraft.options);
        this.minecraft.gameMode.adjustPlayer(localplayer1);
        localplayer1.setReducedDebugInfo(localplayer.isReducedDebugInfo());
        localplayer1.setShowDeathScreen(localplayer.shouldShowDeathScreen());
        localplayer1.setLastDeathLocation(commonplayerspawninfo.lastDeathLocation());
        localplayer1.setPortalCooldown(commonplayerspawninfo.portalCooldown());
        localplayer1.spinningEffectIntensity = localplayer.spinningEffectIntensity;
        localplayer1.oSpinningEffectIntensity = localplayer.oSpinningEffectIntensity;
        if (this.minecraft.screen instanceof DeathScreen || this.minecraft.screen instanceof DeathScreen.TitleConfirmScreen) {
            this.minecraft.setScreen(null);
        }
        this.minecraft.gameMode.setLocalMode(commonplayerspawninfo.gameType(), commonplayerspawninfo.previousGameType());
    }

    private ReceivingLevelScreen.Reason determineLevelLoadingReason(boolean p_341642_, ResourceKey<Level> p_341617_, ResourceKey<Level> p_341637_) {
        ReceivingLevelScreen.Reason receivinglevelscreen$reason = ReceivingLevelScreen.Reason.OTHER;
        if (!p_341642_) {
            if (p_341617_ == Level.NETHER || p_341637_ == Level.NETHER) {
                receivinglevelscreen$reason = ReceivingLevelScreen.Reason.NETHER_PORTAL;
            } else if (p_341617_ == Level.END || p_341637_ == Level.END) {
                receivinglevelscreen$reason = ReceivingLevelScreen.Reason.END_PORTAL;
            }
        }
        return receivinglevelscreen$reason;
    }

    public void handleExplosion(ClientboundExplodePacket p_105012_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105012_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Explosion explosion = new Explosion(this.minecraft.level, null, p_105012_.getX(), p_105012_.getY(), p_105012_.getZ(), p_105012_.getPower(), p_105012_.getToBlow(), p_105012_.getBlockInteraction(), p_105012_.getSmallExplosionParticles(), p_105012_.getLargeExplosionParticles(), p_105012_.getExplosionSound());
        explosion.finalizeExplosion(true);
        this.minecraft.player.setDeltaMovement(this.minecraft.player.getDeltaMovement().add((double)p_105012_.getKnockbackX(), (double)p_105012_.getKnockbackY(), (double)p_105012_.getKnockbackZ()));
    }

    public void handleHorseScreenOpen(ClientboundHorseScreenOpenPacket p_105018_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105018_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105018_.getEntityId());
        if (entity instanceof AbstractHorse) {
            AbstractHorse abstracthorse = (AbstractHorse)((Object)entity);
            LocalPlayer localplayer = this.minecraft.player;
            int i = p_105018_.getInventoryColumns();
            SimpleContainer simplecontainer = new SimpleContainer(AbstractHorse.getInventorySize(i));
            HorseInventoryMenu horseinventorymenu = new HorseInventoryMenu(p_105018_.getContainerId(), localplayer.getInventory(), (Container)simplecontainer, abstracthorse, i);
            localplayer.containerMenu = horseinventorymenu;
            this.minecraft.setScreen((Screen)new HorseInventoryScreen(horseinventorymenu, localplayer.getInventory(), abstracthorse, i));
        }
    }

    public void handleOpenScreen(ClientboundOpenScreenPacket p_105042_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105042_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        MenuScreens.create(p_105042_.getType(), this.minecraft, p_105042_.getContainerId(), p_105042_.getTitle());
    }

    public void handleContainerSetSlot(ClientboundContainerSetSlotPacket p_105000_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105000_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        ItemStack itemstack = p_105000_.getItem();
        int i = p_105000_.getSlot();
        this.minecraft.getTutorial().onGetItem(itemstack);
        if (p_105000_.getContainerId() == -1) {
            if (!(this.minecraft.screen instanceof CreativeModeInventoryScreen)) {
                player.containerMenu.setCarried(itemstack);
            }
        } else if (p_105000_.getContainerId() == -2) {
            player.getInventory().setItem(i, itemstack);
        } else {
            boolean flag = false;
            Screen screen = this.minecraft.screen;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativemodeinventoryscreen = (CreativeModeInventoryScreen)screen;
                boolean bl = flag = !creativemodeinventoryscreen.isInventoryOpen();
            }
            if (p_105000_.getContainerId() == 0 && InventoryMenu.isHotbarSlot((int)i)) {
                ItemStack itemstack1;
                if (!itemstack.isEmpty() && ((itemstack1 = player.inventoryMenu.getSlot(i).getItem()).isEmpty() || itemstack1.getCount() < itemstack.getCount())) {
                    itemstack.setPopTime(5);
                }
                player.inventoryMenu.setItem(i, p_105000_.getStateId(), itemstack);
            } else if (!(p_105000_.getContainerId() != player.containerMenu.containerId || p_105000_.getContainerId() == 0 && flag)) {
                player.containerMenu.setItem(i, p_105000_.getStateId(), itemstack);
            }
        }
    }

    public void handleContainerContent(ClientboundContainerSetContentPacket p_104996_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104996_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        if (p_104996_.getContainerId() == 0) {
            player.inventoryMenu.initializeContents(p_104996_.getStateId(), p_104996_.getItems(), p_104996_.getCarriedItem());
        } else if (p_104996_.getContainerId() == player.containerMenu.containerId) {
            player.containerMenu.initializeContents(p_104996_.getStateId(), p_104996_.getItems(), p_104996_.getCarriedItem());
        }
    }

    public void handleOpenSignEditor(ClientboundOpenSignEditorPacket p_105044_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105044_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        BlockPos blockpos = p_105044_.getPos();
        BlockEntity blockEntity = this.level.getBlockEntity(blockpos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity signblockentity = (SignBlockEntity)blockEntity;
            this.minecraft.player.openTextEdit(signblockentity, p_105044_.isFrontText());
        } else {
            BlockState blockstate = this.level.getBlockState(blockpos);
            SignBlockEntity signblockentity1 = new SignBlockEntity(blockpos, blockstate);
            signblockentity1.setLevel((Level)this.level);
            this.minecraft.player.openTextEdit(signblockentity1, p_105044_.isFrontText());
        }
    }

    public void handleBlockEntityData(ClientboundBlockEntityDataPacket p_104976_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104976_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        BlockPos blockpos = p_104976_.getPos();
        this.minecraft.level.getBlockEntity(blockpos, p_104976_.getType()).ifPresent(p_337415_ -> {
            p_337415_.onDataPacket(this.connection, p_104976_, (HolderLookup.Provider)this.registryAccess);
            if (p_337415_ instanceof CommandBlockEntity && this.minecraft.screen instanceof CommandBlockEditScreen) {
                ((CommandBlockEditScreen)this.minecraft.screen).updateGui();
            }
        });
    }

    public void handleContainerSetData(ClientboundContainerSetDataPacket p_104998_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104998_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        if (player.containerMenu != null && player.containerMenu.containerId == p_104998_.getContainerId()) {
            player.containerMenu.setData(p_104998_.getId(), p_104998_.getValue());
        }
    }

    public void handleSetEquipment(ClientboundSetEquipmentPacket p_105094_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105094_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105094_.getEntity());
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            p_105094_.getSlots().forEach(p_323056_ -> livingentity.setItemSlot((EquipmentSlot)p_323056_.getFirst(), (ItemStack)p_323056_.getSecond()));
        }
    }

    public void handleContainerClose(ClientboundContainerClosePacket p_104994_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104994_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.player.clientSideCloseContainer();
    }

    public void handleBlockEvent(ClientboundBlockEventPacket p_104978_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104978_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.level.blockEvent(p_104978_.getPos(), p_104978_.getBlock(), p_104978_.getB0(), p_104978_.getB1());
    }

    public void handleBlockDestruction(ClientboundBlockDestructionPacket p_104974_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104974_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.level.destroyBlockProgress(p_104974_.getId(), p_104974_.getPos(), p_104974_.getProgress());
    }

    public void handleGameEvent(ClientboundGameEventPacket p_105016_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105016_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        ClientboundGameEventPacket.Type clientboundgameeventpacket$type = p_105016_.getEvent();
        float f = p_105016_.getParam();
        int i = Mth.floor((float)(f + 0.5f));
        if (clientboundgameeventpacket$type == ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE) {
            ((Player)player).displayClientMessage((Component)Component.translatable((String)"block.minecraft.spawn.not_valid"), false);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.START_RAINING) {
            this.level.getLevelData().setRaining(true);
            this.level.setRainLevel(0.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.STOP_RAINING) {
            this.level.getLevelData().setRaining(false);
            this.level.setRainLevel(1.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.CHANGE_GAME_MODE) {
            this.minecraft.gameMode.setLocalMode(GameType.byId((int)i));
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.WIN_GAME) {
            this.minecraft.setScreen((Screen)new WinScreen(true, () -> {
                this.minecraft.player.connection.send((Packet<?>)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
                this.minecraft.setScreen(null);
            }));
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.DEMO_EVENT) {
            Options options = this.minecraft.options;
            if (f == 0.0f) {
                this.minecraft.setScreen((Screen)new DemoIntroScreen());
            } else if (f == 101.0f) {
                this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"demo.help.movement", (Object[])new Object[]{options.keyUp.getTranslatedKeyMessage(), options.keyLeft.getTranslatedKeyMessage(), options.keyDown.getTranslatedKeyMessage(), options.keyRight.getTranslatedKeyMessage()}));
            } else if (f == 102.0f) {
                this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"demo.help.jump", (Object[])new Object[]{options.keyJump.getTranslatedKeyMessage()}));
            } else if (f == 103.0f) {
                this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"demo.help.inventory", (Object[])new Object[]{options.keyInventory.getTranslatedKeyMessage()}));
            } else if (f == 104.0f) {
                this.minecraft.gui.getChat().addMessage((Component)Component.translatable((String)"demo.day.6", (Object[])new Object[]{options.keyScreenshot.getTranslatedKeyMessage()}));
            }
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.ARROW_HIT_PLAYER) {
            this.level.playSound((Player)player, player.getX(), player.getEyeY(), player.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.18f, 0.45f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.RAIN_LEVEL_CHANGE) {
            this.level.setRainLevel(f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE) {
            this.level.setThunderLevel(f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.PUFFER_FISH_STING) {
            this.level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), SoundEvents.PUFFER_FISH_STING, SoundSource.NEUTRAL, 1.0f, 1.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.GUARDIAN_ELDER_EFFECT) {
            this.level.addParticle((ParticleOptions)ParticleTypes.ELDER_GUARDIAN, player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
            if (i == 1) {
                this.level.playSound((Player)player, player.getX(), player.getY(), player.getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.IMMEDIATE_RESPAWN) {
            this.minecraft.player.setShowDeathScreen(f == 0.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.LIMITED_CRAFTING) {
            this.minecraft.player.setDoLimitedCrafting(f == 1.0f);
        } else if (clientboundgameeventpacket$type == ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START && this.levelLoadStatusManager != null) {
            this.levelLoadStatusManager.loadingPacketsReceived();
        }
    }

    @Deprecated
    private void startWaitingForNewLevel(LocalPlayer p_304688_, ClientLevel p_304528_, ReceivingLevelScreen.Reason p_341690_) {
        this.startWaitingForNewLevel(p_304688_, p_304528_, p_341690_, null, null);
    }

    private void startWaitingForNewLevel(LocalPlayer p_304688_, ClientLevel p_304528_, ReceivingLevelScreen.Reason p_341690_, @Nullable ResourceKey<Level> toDimension, @Nullable ResourceKey<Level> fromDimension) {
        this.levelLoadStatusManager = new LevelLoadStatusManager(p_304688_, p_304528_, this.minecraft.levelRenderer);
        this.minecraft.setScreen((Screen)DimensionTransitionScreenManager.getScreen(toDimension, fromDimension).create(() -> ((LevelLoadStatusManager)this.levelLoadStatusManager).levelReady(), p_341690_));
    }

    public void handleMapItemData(ClientboundMapItemDataPacket p_105032_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105032_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        MapRenderer maprenderer = this.minecraft.gameRenderer.getMapRenderer();
        MapId mapid = p_105032_.mapId();
        MapItemSavedData mapitemsaveddata = this.minecraft.level.getMapData(mapid);
        if (mapitemsaveddata == null) {
            mapitemsaveddata = MapItemSavedData.createForClient((byte)p_105032_.scale(), (boolean)p_105032_.locked(), this.minecraft.level.dimension());
            this.minecraft.level.overrideMapData(mapid, mapitemsaveddata);
        }
        p_105032_.applyToMap(mapitemsaveddata);
        maprenderer.update(mapid, mapitemsaveddata);
    }

    public void handleLevelEvent(ClientboundLevelEventPacket p_105024_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105024_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (p_105024_.isGlobalEvent()) {
            this.minecraft.level.globalLevelEvent(p_105024_.getType(), p_105024_.getPos(), p_105024_.getData());
        } else {
            this.minecraft.level.levelEvent(p_105024_.getType(), p_105024_.getPos(), p_105024_.getData());
        }
    }

    public void handleUpdateAdvancementsPacket(ClientboundUpdateAdvancementsPacket p_105126_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105126_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.advancements.update(p_105126_);
    }

    public void handleSelectAdvancementsTab(ClientboundSelectAdvancementsTabPacket p_105072_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105072_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        ResourceLocation resourcelocation = p_105072_.getTab();
        if (resourcelocation == null) {
            this.advancements.setSelectedTab(null, false);
        } else {
            AdvancementHolder advancementholder = this.advancements.get(resourcelocation);
            this.advancements.setSelectedTab(advancementholder, false);
        }
    }

    public void handleCommands(ClientboundCommandsPacket p_104990_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104990_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        CommandBuildContext context = CommandBuildContext.simple((HolderLookup.Provider)this.registryAccess, (FeatureFlagSet)this.enabledFeatures);
        this.commands = new CommandDispatcher(p_104990_.getRoot(context));
        this.commands = ClientCommandHandler.mergeServerCommands(this.commands, (CommandBuildContext)context);
    }

    public void handleStopSoundEvent(ClientboundStopSoundPacket p_105116_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105116_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.getSoundManager().stop(p_105116_.getName(), p_105116_.getSource());
    }

    public void handleCommandSuggestions(ClientboundCommandSuggestionsPacket p_104988_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104988_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.suggestionsProvider.completeCustomSuggestions(p_104988_.id(), p_104988_.toSuggestions());
    }

    public void handleUpdateRecipes(ClientboundUpdateRecipesPacket p_105132_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105132_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.recipeManager.replaceRecipes(p_105132_.getRecipes());
        ClientRecipeBook clientrecipebook = this.minecraft.player.getRecipeBook();
        clientrecipebook.setupCollections(this.recipeManager.getOrderedRecipes(), this.minecraft.level.registryAccess());
        this.searchTrees.updateRecipes(clientrecipebook, this.registryAccess);
        ClientHooks.onRecipesUpdated((RecipeManager)this.recipeManager);
    }

    public void handleLookAt(ClientboundPlayerLookAtPacket p_105054_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105054_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Vec3 vec3 = p_105054_.getPosition((Level)this.level);
        if (vec3 != null) {
            this.minecraft.player.lookAt(p_105054_.getFromAnchor(), vec3);
        }
    }

    public void handleTagQueryPacket(ClientboundTagQueryPacket p_105120_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105120_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (!this.debugQueryHandler.handleResponse(p_105120_.getTransactionId(), p_105120_.getTag())) {
            LOGGER.debug("Got unhandled response to tag query {}", (Object)p_105120_.getTransactionId());
        }
    }

    public void handleAwardStats(ClientboundAwardStatsPacket p_104970_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104970_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        for (Object2IntMap.Entry entry : p_104970_.stats().object2IntEntrySet()) {
            Stat stat = (Stat)entry.getKey();
            int i = entry.getIntValue();
            this.minecraft.player.getStats().setValue(this.minecraft.player, stat, i);
        }
        Screen screen = this.minecraft.screen;
        if (screen instanceof StatsScreen) {
            StatsScreen statsscreen = (StatsScreen)screen;
            statsscreen.onStatsUpdated();
        }
    }

    public void handleAddOrRemoveRecipes(ClientboundRecipePacket p_105058_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105058_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        ClientRecipeBook clientrecipebook = this.minecraft.player.getRecipeBook();
        clientrecipebook.setBookSettings(p_105058_.getBookSettings());
        ClientboundRecipePacket.State clientboundrecipepacket$state = p_105058_.getState();
        switch (clientboundrecipepacket$state) {
            case REMOVE: {
                for (ResourceLocation resourcelocation3 : p_105058_.getRecipes()) {
                    this.recipeManager.byKey(resourcelocation3).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).remove(arg_0));
                }
                break;
            }
            case INIT: {
                for (ResourceLocation resourcelocation1 : p_105058_.getRecipes()) {
                    this.recipeManager.byKey(resourcelocation1).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).add(arg_0));
                }
                for (ResourceLocation resourcelocation2 : p_105058_.getHighlights()) {
                    this.recipeManager.byKey(resourcelocation2).ifPresent(arg_0 -> ((ClientRecipeBook)clientrecipebook).addHighlight(arg_0));
                }
                break;
            }
            case ADD: {
                for (ResourceLocation resourcelocation : p_105058_.getRecipes()) {
                    this.recipeManager.byKey(resourcelocation).ifPresent(p_300677_ -> {
                        clientrecipebook.add((RecipeHolder)p_300677_);
                        clientrecipebook.addHighlight((RecipeHolder)p_300677_);
                        if (p_300677_.value().showNotification()) {
                            RecipeToast.addOrUpdate((ToastComponent)this.minecraft.getToasts(), (RecipeHolder)p_300677_);
                        }
                    });
                }
                break;
            }
        }
        clientrecipebook.getCollections().forEach(p_205540_ -> p_205540_.updateKnownRecipes((RecipeBook)clientrecipebook));
        if (this.minecraft.screen instanceof RecipeUpdateListener) {
            ((RecipeUpdateListener)this.minecraft.screen).recipesUpdated();
        }
    }

    public void handleUpdateMobEffect(ClientboundUpdateMobEffectPacket p_105130_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105130_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105130_.getEntityId());
        if (entity instanceof LivingEntity) {
            Holder holder = p_105130_.getEffect();
            MobEffectInstance mobeffectinstance = new MobEffectInstance(holder, p_105130_.getEffectDurationTicks(), p_105130_.getEffectAmplifier(), p_105130_.isEffectAmbient(), p_105130_.isEffectVisible(), p_105130_.effectShowsIcon(), null);
            if (!p_105130_.shouldBlend()) {
                mobeffectinstance.skipBlending();
            }
            ((LivingEntity)entity).forceAddEffect(mobeffectinstance, null);
        }
    }

    @Override
    public void handleUpdateTags(ClientboundUpdateTagsPacket p_294888_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_294888_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        TagCollector tagcollector = new TagCollector();
        p_294888_.getTags().forEach(tagcollector::append);
        tagcollector.updateTags((RegistryAccess)this.registryAccess, this.connection.isMemoryConnection());
        CreativeModeTabs.allTabs().stream().filter(CreativeModeTab::hasSearchBar).forEach(tab -> {
            List<ItemStack> list = List.copyOf(tab.getDisplayItems());
            this.searchTrees.updateCreativeTags(list, CreativeModeTabSearchRegistry.getTagSearchKey((CreativeModeTab)tab));
        });
    }

    public void handlePlayerCombatEnd(ClientboundPlayerCombatEndPacket p_171771_) {
    }

    public void handlePlayerCombatEnter(ClientboundPlayerCombatEnterPacket p_171773_) {
    }

    public void handlePlayerCombatKill(ClientboundPlayerCombatKillPacket p_171775_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171775_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_171775_.playerId());
        if (entity == this.minecraft.player) {
            if (this.minecraft.player.shouldShowDeathScreen()) {
                this.minecraft.setScreen((Screen)new DeathScreen(p_171775_.message(), this.level.getLevelData().isHardcore()));
            } else {
                this.minecraft.player.respawn();
            }
        }
    }

    public void handleChangeDifficulty(ClientboundChangeDifficultyPacket p_104984_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104984_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.levelData.setDifficulty(p_104984_.getDifficulty());
        this.levelData.setDifficultyLocked(p_104984_.isLocked());
    }

    public void handleSetCamera(ClientboundSetCameraPacket p_105076_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105076_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = p_105076_.getEntity((Level)this.level);
        if (entity != null) {
            this.minecraft.setCameraEntity(entity);
        }
    }

    public void handleInitializeBorder(ClientboundInitializeBorderPacket p_171767_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171767_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        WorldBorder worldborder = this.level.getWorldBorder();
        worldborder.setCenter(p_171767_.getNewCenterX(), p_171767_.getNewCenterZ());
        long i = p_171767_.getLerpTime();
        if (i > 0L) {
            worldborder.lerpSizeBetween(p_171767_.getOldSize(), p_171767_.getNewSize(), i);
        } else {
            worldborder.setSize(p_171767_.getNewSize());
        }
        worldborder.setAbsoluteMaxSize(p_171767_.getNewAbsoluteMaxSize());
        worldborder.setWarningBlocks(p_171767_.getWarningBlocks());
        worldborder.setWarningTime(p_171767_.getWarningTime());
    }

    public void handleSetBorderCenter(ClientboundSetBorderCenterPacket p_171781_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171781_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getWorldBorder().setCenter(p_171781_.getNewCenterX(), p_171781_.getNewCenterZ());
    }

    public void handleSetBorderLerpSize(ClientboundSetBorderLerpSizePacket p_171783_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171783_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getWorldBorder().lerpSizeBetween(p_171783_.getOldSize(), p_171783_.getNewSize(), p_171783_.getLerpTime());
    }

    public void handleSetBorderSize(ClientboundSetBorderSizePacket p_171785_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171785_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getWorldBorder().setSize(p_171785_.getSize());
    }

    public void handleSetBorderWarningDistance(ClientboundSetBorderWarningDistancePacket p_171789_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171789_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getWorldBorder().setWarningBlocks(p_171789_.getWarningBlocks());
    }

    public void handleSetBorderWarningDelay(ClientboundSetBorderWarningDelayPacket p_171787_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171787_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getWorldBorder().setWarningTime(p_171787_.getWarningDelay());
    }

    public void handleTitlesClear(ClientboundClearTitlesPacket p_171765_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171765_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.clear();
        if (p_171765_.shouldResetTimes()) {
            this.minecraft.gui.resetTitleTimes();
        }
    }

    public void handleServerData(ClientboundServerDataPacket p_233704_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_233704_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (this.serverData != null) {
            this.serverData.motd = p_233704_.motd();
            p_233704_.iconBytes().map(ServerData::validateIcon).ifPresent(this.serverData::setIconBytes);
            ServerList.saveSingleServer((ServerData)this.serverData);
        }
    }

    public void handleCustomChatCompletions(ClientboundCustomChatCompletionsPacket p_240832_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_240832_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.suggestionsProvider.modifyCustomCompletions(p_240832_.action(), p_240832_.entries());
    }

    public void setActionBarText(ClientboundSetActionBarTextPacket p_171779_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171779_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.setOverlayMessage(p_171779_.text(), false);
    }

    public void setTitleText(ClientboundSetTitleTextPacket p_171793_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171793_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.setTitle(p_171793_.text());
    }

    public void setSubtitleText(ClientboundSetSubtitleTextPacket p_171791_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171791_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.setSubtitle(p_171791_.text());
    }

    public void setTitlesAnimation(ClientboundSetTitlesAnimationPacket p_171795_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_171795_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.setTimes(p_171795_.getFadeIn(), p_171795_.getStay(), p_171795_.getFadeOut());
    }

    public void handleTabListCustomisation(ClientboundTabListPacket p_105118_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105118_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.getTabList().setHeader(p_105118_.header().getString().isEmpty() ? null : p_105118_.header());
        this.minecraft.gui.getTabList().setFooter(p_105118_.footer().getString().isEmpty() ? null : p_105118_.footer());
    }

    public void handleRemoveMobEffect(ClientboundRemoveMobEffectPacket p_105062_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105062_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = p_105062_.getEntity((Level)this.level);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.removeEffectNoUpdate(p_105062_.effect());
        }
    }

    public void handlePlayerInfoRemove(ClientboundPlayerInfoRemovePacket p_248731_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_248731_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        for (UUID uuid : p_248731_.profileIds()) {
            this.minecraft.getPlayerSocialManager().removePlayer(uuid);
            PlayerInfo playerinfo = this.playerInfoMap.remove(uuid);
            if (playerinfo == null) continue;
            this.listedPlayers.remove(playerinfo);
        }
    }

    public void handlePlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket p_250115_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_250115_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        for (ClientboundPlayerInfoUpdatePacket.Entry clientboundplayerinfoupdatepacket$entry : p_250115_.newEntries()) {
            PlayerInfo playerinfo = new PlayerInfo(Objects.requireNonNull(clientboundplayerinfoupdatepacket$entry.profile()), this.enforcesSecureChat());
            if (this.playerInfoMap.putIfAbsent(clientboundplayerinfoupdatepacket$entry.profileId(), playerinfo) != null) continue;
            this.minecraft.getPlayerSocialManager().addPlayer(playerinfo);
        }
        for (ClientboundPlayerInfoUpdatePacket.Entry clientboundplayerinfoupdatepacket$entry1 : p_250115_.entries()) {
            PlayerInfo playerinfo1 = this.playerInfoMap.get(clientboundplayerinfoupdatepacket$entry1.profileId());
            if (playerinfo1 == null) {
                LOGGER.warn("Ignoring player info update for unknown player {} ({})", (Object)clientboundplayerinfoupdatepacket$entry1.profileId(), (Object)p_250115_.actions());
                continue;
            }
            for (ClientboundPlayerInfoUpdatePacket.Action clientboundplayerinfoupdatepacket$action : p_250115_.actions()) {
                this.applyPlayerInfoUpdate(clientboundplayerinfoupdatepacket$action, clientboundplayerinfoupdatepacket$entry1, playerinfo1);
            }
        }
    }

    private void applyPlayerInfoUpdate(ClientboundPlayerInfoUpdatePacket.Action p_248954_, ClientboundPlayerInfoUpdatePacket.Entry p_251310_, PlayerInfo p_251146_) {
        switch (p_248954_) {
            case INITIALIZE_CHAT: {
                this.initializeChatSession(p_251310_, p_251146_);
                break;
            }
            case UPDATE_GAME_MODE: {
                if (p_251146_.getGameMode() != p_251310_.gameMode() && this.minecraft.player != null && this.minecraft.player.getUUID().equals(p_251310_.profileId())) {
                    this.minecraft.player.onGameModeChanged(p_251310_.gameMode());
                }
                p_251146_.setGameMode(p_251310_.gameMode());
                break;
            }
            case UPDATE_LISTED: {
                if (p_251310_.listed()) {
                    this.listedPlayers.add(p_251146_);
                    break;
                }
                this.listedPlayers.remove(p_251146_);
                break;
            }
            case UPDATE_LATENCY: {
                p_251146_.setLatency(p_251310_.latency());
                break;
            }
            case UPDATE_DISPLAY_NAME: {
                p_251146_.setTabListDisplayName(p_251310_.displayName());
            }
        }
    }

    private void initializeChatSession(ClientboundPlayerInfoUpdatePacket.Entry p_248806_, PlayerInfo p_251136_) {
        GameProfile gameprofile = p_251136_.getProfile();
        SignatureValidator signaturevalidator = this.minecraft.getProfileKeySignatureValidator();
        if (signaturevalidator == null) {
            LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)gameprofile.getName());
            p_251136_.clearChatSession(this.enforcesSecureChat());
        } else {
            RemoteChatSession.Data remotechatsession$data = p_248806_.chatSession();
            if (remotechatsession$data != null) {
                try {
                    RemoteChatSession remotechatsession = remotechatsession$data.validate(gameprofile, signaturevalidator);
                    p_251136_.setChatSession(remotechatsession);
                }
                catch (ProfilePublicKey.ValidationException profilepublickey$validationexception) {
                    LOGGER.error("Failed to validate profile key for player: '{}'", (Object)gameprofile.getName(), (Object)profilepublickey$validationexception);
                    p_251136_.clearChatSession(this.enforcesSecureChat());
                }
            } else {
                p_251136_.clearChatSession(this.enforcesSecureChat());
            }
        }
    }

    private boolean enforcesSecureChat() {
        return this.minecraft.canValidateProfileKeys() && this.serverEnforcesSecureChat;
    }

    public void handlePlayerAbilities(ClientboundPlayerAbilitiesPacket p_105048_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105048_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        LocalPlayer player = this.minecraft.player;
        player.getAbilities().flying = p_105048_.isFlying();
        player.getAbilities().instabuild = p_105048_.canInstabuild();
        player.getAbilities().invulnerable = p_105048_.isInvulnerable();
        player.getAbilities().mayfly = p_105048_.canFly();
        player.getAbilities().setFlyingSpeed(p_105048_.getFlyingSpeed());
        player.getAbilities().setWalkingSpeed(p_105048_.getWalkingSpeed());
    }

    public void handleSoundEvent(ClientboundSoundPacket p_105114_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105114_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.level.playSeededSound((Player)this.minecraft.player, p_105114_.getX(), p_105114_.getY(), p_105114_.getZ(), p_105114_.getSound(), p_105114_.getSource(), p_105114_.getVolume(), p_105114_.getPitch(), p_105114_.getSeed());
    }

    public void handleSoundEntityEvent(ClientboundSoundEntityPacket p_105112_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105112_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105112_.getId());
        if (entity != null) {
            this.minecraft.level.playSeededSound(this.minecraft.player, entity, p_105112_.getSound(), p_105112_.getSource(), p_105112_.getVolume(), p_105112_.getPitch(), p_105112_.getSeed());
        }
    }

    public void handleBossUpdate(ClientboundBossEventPacket p_104982_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_104982_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.minecraft.gui.getBossOverlay().update(p_104982_);
    }

    public void handleItemCooldown(ClientboundCooldownPacket p_105002_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105002_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (p_105002_.duration() == 0) {
            this.minecraft.player.getCooldowns().removeCooldown(p_105002_.item());
        } else {
            this.minecraft.player.getCooldowns().addCooldown(p_105002_.item(), p_105002_.duration());
        }
    }

    public void handleMoveVehicle(ClientboundMoveVehiclePacket p_105038_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105038_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.minecraft.player.getRootVehicle();
        if (entity != this.minecraft.player && entity.isControlledByLocalInstance()) {
            entity.absMoveTo(p_105038_.getX(), p_105038_.getY(), p_105038_.getZ(), p_105038_.getYRot(), p_105038_.getXRot());
            this.connection.send((Packet<?>)new ServerboundMoveVehiclePacket(entity));
        }
    }

    public void handleOpenBook(ClientboundOpenBookPacket p_105040_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105040_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        ItemStack itemstack = this.minecraft.player.getItemInHand(p_105040_.getHand());
        BookViewScreen.BookAccess bookviewscreen$bookaccess = BookViewScreen.BookAccess.fromItem((ItemStack)itemstack);
        if (bookviewscreen$bookaccess != null) {
            this.minecraft.setScreen((Screen)new BookViewScreen(bookviewscreen$bookaccess));
        }
    }

    @Override
    public void handleCustomPayload(CustomPacketPayload p_295851_) {
        if (p_295851_ instanceof PathfindingDebugPayload) {
            PathfindingDebugPayload pathfindingdebugpayload = (PathfindingDebugPayload)p_295851_;
            this.minecraft.debugRenderer.pathfindingRenderer.addPath(pathfindingdebugpayload.entityId(), pathfindingdebugpayload.path(), pathfindingdebugpayload.maxNodeDistance());
        } else if (p_295851_ instanceof NeighborUpdatesDebugPayload) {
            NeighborUpdatesDebugPayload neighborupdatesdebugpayload = (NeighborUpdatesDebugPayload)p_295851_;
            ((NeighborsUpdateRenderer)this.minecraft.debugRenderer.neighborsUpdateRenderer).addUpdate(neighborupdatesdebugpayload.time(), neighborupdatesdebugpayload.pos());
        } else if (p_295851_ instanceof StructuresDebugPayload) {
            StructuresDebugPayload structuresdebugpayload = (StructuresDebugPayload)p_295851_;
            this.minecraft.debugRenderer.structureRenderer.addBoundingBox(structuresdebugpayload.mainBB(), structuresdebugpayload.pieces(), structuresdebugpayload.dimension());
        } else if (p_295851_ instanceof WorldGenAttemptDebugPayload) {
            WorldGenAttemptDebugPayload worldgenattemptdebugpayload = (WorldGenAttemptDebugPayload)p_295851_;
            ((WorldGenAttemptRenderer)this.minecraft.debugRenderer.worldGenAttemptRenderer).addPos(worldgenattemptdebugpayload.pos(), worldgenattemptdebugpayload.scale(), worldgenattemptdebugpayload.red(), worldgenattemptdebugpayload.green(), worldgenattemptdebugpayload.blue(), worldgenattemptdebugpayload.alpha());
        } else if (p_295851_ instanceof PoiTicketCountDebugPayload) {
            PoiTicketCountDebugPayload poiticketcountdebugpayload = (PoiTicketCountDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.setFreeTicketCount(poiticketcountdebugpayload.pos(), poiticketcountdebugpayload.freeTicketCount());
        } else if (p_295851_ instanceof PoiAddedDebugPayload) {
            PoiAddedDebugPayload poiaddeddebugpayload = (PoiAddedDebugPayload)p_295851_;
            BrainDebugRenderer.PoiInfo braindebugrenderer$poiinfo = new BrainDebugRenderer.PoiInfo(poiaddeddebugpayload.pos(), poiaddeddebugpayload.poiType(), poiaddeddebugpayload.freeTicketCount());
            this.minecraft.debugRenderer.brainDebugRenderer.addPoi(braindebugrenderer$poiinfo);
        } else if (p_295851_ instanceof PoiRemovedDebugPayload) {
            PoiRemovedDebugPayload poiremoveddebugpayload = (PoiRemovedDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.removePoi(poiremoveddebugpayload.pos());
        } else if (p_295851_ instanceof VillageSectionsDebugPayload) {
            VillageSectionsDebugPayload villagesectionsdebugpayload = (VillageSectionsDebugPayload)p_295851_;
            VillageSectionsDebugRenderer villagesectionsdebugrenderer = this.minecraft.debugRenderer.villageSectionsDebugRenderer;
            villagesectionsdebugpayload.villageChunks().forEach(arg_0 -> ((VillageSectionsDebugRenderer)villagesectionsdebugrenderer).setVillageSection(arg_0));
            villagesectionsdebugpayload.notVillageChunks().forEach(arg_0 -> ((VillageSectionsDebugRenderer)villagesectionsdebugrenderer).setNotVillageSection(arg_0));
        } else if (p_295851_ instanceof GoalDebugPayload) {
            GoalDebugPayload goaldebugpayload = (GoalDebugPayload)p_295851_;
            this.minecraft.debugRenderer.goalSelectorRenderer.addGoalSelector(goaldebugpayload.entityId(), goaldebugpayload.pos(), goaldebugpayload.goals());
        } else if (p_295851_ instanceof BrainDebugPayload) {
            BrainDebugPayload braindebugpayload = (BrainDebugPayload)p_295851_;
            this.minecraft.debugRenderer.brainDebugRenderer.addOrUpdateBrainDump(braindebugpayload.brainDump());
        } else if (p_295851_ instanceof BeeDebugPayload) {
            BeeDebugPayload beedebugpayload = (BeeDebugPayload)p_295851_;
            this.minecraft.debugRenderer.beeDebugRenderer.addOrUpdateBeeInfo(beedebugpayload.beeInfo());
        } else if (p_295851_ instanceof HiveDebugPayload) {
            HiveDebugPayload hivedebugpayload = (HiveDebugPayload)p_295851_;
            this.minecraft.debugRenderer.beeDebugRenderer.addOrUpdateHiveInfo(hivedebugpayload.hiveInfo(), this.level.getGameTime());
        } else if (p_295851_ instanceof GameTestAddMarkerDebugPayload) {
            GameTestAddMarkerDebugPayload gametestaddmarkerdebugpayload = (GameTestAddMarkerDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameTestDebugRenderer.addMarker(gametestaddmarkerdebugpayload.pos(), gametestaddmarkerdebugpayload.color(), gametestaddmarkerdebugpayload.text(), gametestaddmarkerdebugpayload.durationMs());
        } else if (p_295851_ instanceof GameTestClearMarkersDebugPayload) {
            this.minecraft.debugRenderer.gameTestDebugRenderer.clear();
        } else if (p_295851_ instanceof RaidsDebugPayload) {
            RaidsDebugPayload raidsdebugpayload = (RaidsDebugPayload)p_295851_;
            this.minecraft.debugRenderer.raidDebugRenderer.setRaidCenters((Collection)raidsdebugpayload.raidCenters());
        } else if (p_295851_ instanceof GameEventDebugPayload) {
            GameEventDebugPayload gameeventdebugpayload = (GameEventDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameEventListenerRenderer.trackGameEvent(gameeventdebugpayload.gameEventType(), gameeventdebugpayload.pos());
        } else if (p_295851_ instanceof GameEventListenerDebugPayload) {
            GameEventListenerDebugPayload gameeventlistenerdebugpayload = (GameEventListenerDebugPayload)p_295851_;
            this.minecraft.debugRenderer.gameEventListenerRenderer.trackListener(gameeventlistenerdebugpayload.listenerPos(), gameeventlistenerdebugpayload.listenerRange());
        } else if (p_295851_ instanceof BreezeDebugPayload) {
            BreezeDebugPayload breezedebugpayload = (BreezeDebugPayload)p_295851_;
            this.minecraft.debugRenderer.breezeDebugRenderer.add(breezedebugpayload.breezeInfo());
        } else {
            this.handleUnknownCustomPayload(p_295851_);
        }
    }

    private void handleUnknownCustomPayload(CustomPacketPayload p_294389_) {
        LOGGER.warn("Unknown custom packet payload: {}", (Object)p_294389_.type().id());
    }

    public void handleAddObjective(ClientboundSetObjectivePacket p_105100_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105100_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        String s = p_105100_.getObjectiveName();
        if (p_105100_.getMethod() == 0) {
            this.scoreboard.addObjective(s, ObjectiveCriteria.DUMMY, p_105100_.getDisplayName(), p_105100_.getRenderType(), false, (NumberFormat)p_105100_.getNumberFormat().orElse(null));
        } else {
            Objective objective = this.scoreboard.getObjective(s);
            if (objective != null) {
                if (p_105100_.getMethod() == 1) {
                    this.scoreboard.removeObjective(objective);
                } else if (p_105100_.getMethod() == 2) {
                    objective.setRenderType(p_105100_.getRenderType());
                    objective.setDisplayName(p_105100_.getDisplayName());
                    objective.setNumberFormat((NumberFormat)p_105100_.getNumberFormat().orElse(null));
                }
            }
        }
    }

    public void handleSetScore(ClientboundSetScorePacket p_105106_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105106_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        String s = p_105106_.objectiveName();
        ScoreHolder scoreholder = ScoreHolder.forNameOnly((String)p_105106_.owner());
        Objective objective = this.scoreboard.getObjective(s);
        if (objective != null) {
            ScoreAccess scoreaccess = this.scoreboard.getOrCreatePlayerScore(scoreholder, objective, true);
            scoreaccess.set(p_105106_.score());
            scoreaccess.display((Component)p_105106_.display().orElse(null));
            scoreaccess.numberFormatOverride((NumberFormat)p_105106_.numberFormat().orElse(null));
        } else {
            LOGGER.warn("Received packet for unknown scoreboard objective: {}", (Object)s);
        }
    }

    public void handleResetScore(ClientboundResetScorePacket p_313768_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_313768_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        String s = p_313768_.objectiveName();
        ScoreHolder scoreholder = ScoreHolder.forNameOnly((String)p_313768_.owner());
        if (s == null) {
            this.scoreboard.resetAllPlayerScores(scoreholder);
        } else {
            Objective objective = this.scoreboard.getObjective(s);
            if (objective != null) {
                this.scoreboard.resetSinglePlayerScore(scoreholder, objective);
            } else {
                LOGGER.warn("Received packet for unknown scoreboard objective: {}", (Object)s);
            }
        }
    }

    public void handleSetDisplayObjective(ClientboundSetDisplayObjectivePacket p_105086_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105086_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        String s = p_105086_.getObjectiveName();
        Objective objective = s == null ? null : this.scoreboard.getObjective(s);
        this.scoreboard.setDisplayObjective(p_105086_.getSlot(), objective);
    }

    public void handleSetPlayerTeamPacket(ClientboundSetPlayerTeamPacket p_105104_) {
        PlayerTeam playerteam;
        PacketUtils.ensureRunningOnSameThread((Packet)p_105104_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        ClientboundSetPlayerTeamPacket.Action clientboundsetplayerteampacket$action = p_105104_.getTeamAction();
        if (clientboundsetplayerteampacket$action == ClientboundSetPlayerTeamPacket.Action.ADD) {
            playerteam = this.scoreboard.addPlayerTeam(p_105104_.getName());
        } else {
            playerteam = this.scoreboard.getPlayerTeam(p_105104_.getName());
            if (playerteam == null) {
                LOGGER.warn("Received packet for unknown team {}: team action: {}, player action: {}", new Object[]{p_105104_.getName(), p_105104_.getTeamAction(), p_105104_.getPlayerAction()});
                return;
            }
        }
        Optional optional = p_105104_.getParameters();
        optional.ifPresent(p_233670_ -> {
            Team.CollisionRule team$collisionrule;
            playerteam.setDisplayName(p_233670_.getDisplayName());
            playerteam.setColor(p_233670_.getColor());
            playerteam.unpackOptions(p_233670_.getOptions());
            Team.Visibility team$visibility = Team.Visibility.byName((String)p_233670_.getNametagVisibility());
            if (team$visibility != null) {
                playerteam.setNameTagVisibility(team$visibility);
            }
            if ((team$collisionrule = Team.CollisionRule.byName((String)p_233670_.getCollisionRule())) != null) {
                playerteam.setCollisionRule(team$collisionrule);
            }
            playerteam.setPlayerPrefix(p_233670_.getPlayerPrefix());
            playerteam.setPlayerSuffix(p_233670_.getPlayerSuffix());
        });
        ClientboundSetPlayerTeamPacket.Action clientboundsetplayerteampacket$action1 = p_105104_.getPlayerAction();
        if (clientboundsetplayerteampacket$action1 == ClientboundSetPlayerTeamPacket.Action.ADD) {
            for (String s : p_105104_.getPlayers()) {
                this.scoreboard.addPlayerToTeam(s, playerteam);
            }
        } else if (clientboundsetplayerteampacket$action1 == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            for (String s1 : p_105104_.getPlayers()) {
                this.scoreboard.removePlayerFromTeam(s1, playerteam);
            }
        }
        if (clientboundsetplayerteampacket$action == ClientboundSetPlayerTeamPacket.Action.REMOVE) {
            this.scoreboard.removePlayerTeam(playerteam);
        }
    }

    public void handleParticleEvent(ClientboundLevelParticlesPacket p_105026_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105026_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        if (p_105026_.getCount() == 0) {
            double d0 = p_105026_.getMaxSpeed() * p_105026_.getXDist();
            double d2 = p_105026_.getMaxSpeed() * p_105026_.getYDist();
            double d4 = p_105026_.getMaxSpeed() * p_105026_.getZDist();
            try {
                this.level.addParticle(p_105026_.getParticle(), p_105026_.isOverrideLimiter(), p_105026_.getX(), p_105026_.getY(), p_105026_.getZ(), d0, d2, d4);
            }
            catch (Throwable throwable1) {
                LOGGER.warn("Could not spawn particle effect {}", (Object)p_105026_.getParticle());
            }
        } else {
            for (int i = 0; i < p_105026_.getCount(); ++i) {
                double d1 = this.random.nextGaussian() * (double)p_105026_.getXDist();
                double d3 = this.random.nextGaussian() * (double)p_105026_.getYDist();
                double d5 = this.random.nextGaussian() * (double)p_105026_.getZDist();
                double d6 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                double d7 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                double d8 = this.random.nextGaussian() * (double)p_105026_.getMaxSpeed();
                try {
                    this.level.addParticle(p_105026_.getParticle(), p_105026_.isOverrideLimiter(), p_105026_.getX() + d1, p_105026_.getY() + d3, p_105026_.getZ() + d5, d6, d7, d8);
                    continue;
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Could not spawn particle effect {}", (Object)p_105026_.getParticle());
                    return;
                }
            }
        }
    }

    public void handleUpdateAttributes(ClientboundUpdateAttributesPacket p_105128_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105128_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_105128_.getEntityId());
        if (entity != null) {
            if (!(entity instanceof LivingEntity)) {
                throw new IllegalStateException("Server tried to update attributes of a non-living entity (actually: " + String.valueOf((Object)entity) + ")");
            }
            AttributeMap attributemap = ((LivingEntity)entity).getAttributes();
            for (ClientboundUpdateAttributesPacket.AttributeSnapshot clientboundupdateattributespacket$attributesnapshot : p_105128_.getValues()) {
                AttributeInstance attributeinstance = attributemap.getInstance(clientboundupdateattributespacket$attributesnapshot.attribute());
                if (attributeinstance == null) {
                    LOGGER.warn("Entity {} does not have attribute {}", (Object)entity, (Object)clientboundupdateattributespacket$attributesnapshot.attribute().getRegisteredName());
                    continue;
                }
                attributeinstance.setBaseValue(clientboundupdateattributespacket$attributesnapshot.base());
                attributeinstance.removeModifiers();
                for (AttributeModifier attributemodifier : clientboundupdateattributespacket$attributesnapshot.modifiers()) {
                    attributeinstance.addTransientModifier(attributemodifier);
                }
            }
        }
    }

    public void handlePlaceRecipe(ClientboundPlaceGhostRecipePacket p_105046_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105046_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        AbstractContainerMenu abstractcontainermenu = this.minecraft.player.containerMenu;
        if (abstractcontainermenu.containerId == p_105046_.getContainerId()) {
            this.recipeManager.byKey(p_105046_.getRecipe()).ifPresent(p_300679_ -> {
                if (this.minecraft.screen instanceof RecipeUpdateListener) {
                    RecipeBookComponent recipebookcomponent = ((RecipeUpdateListener)this.minecraft.screen).getRecipeBookComponent();
                    recipebookcomponent.setupGhostRecipe((RecipeHolder<?>)p_300679_, (List<Slot>)abstractcontainermenu.slots);
                }
            });
        }
    }

    public void handleLightUpdatePacket(ClientboundLightUpdatePacket p_194243_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_194243_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        int i = p_194243_.getX();
        int j = p_194243_.getZ();
        ClientboundLightUpdatePacketData clientboundlightupdatepacketdata = p_194243_.getLightData();
        this.level.queueLightUpdate(() -> this.applyLightData(i, j, clientboundlightupdatepacketdata));
    }

    private void applyLightData(int p_194249_, int p_194250_, ClientboundLightUpdatePacketData p_194251_) {
        LevelLightEngine levellightengine = this.level.getChunkSource().getLightEngine();
        BitSet bitset = p_194251_.getSkyYMask();
        BitSet bitset1 = p_194251_.getEmptySkyYMask();
        Iterator<byte[]> iterator = p_194251_.getSkyUpdates().iterator();
        this.readSectionList(p_194249_, p_194250_, levellightengine, LightLayer.SKY, bitset, bitset1, iterator);
        BitSet bitset2 = p_194251_.getBlockYMask();
        BitSet bitset3 = p_194251_.getEmptyBlockYMask();
        Iterator<byte[]> iterator1 = p_194251_.getBlockUpdates().iterator();
        this.readSectionList(p_194249_, p_194250_, levellightengine, LightLayer.BLOCK, bitset2, bitset3, iterator1);
        levellightengine.setLightEnabled(new ChunkPos(p_194249_, p_194250_), true);
    }

    public void handleMerchantOffers(ClientboundMerchantOffersPacket p_105034_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105034_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        AbstractContainerMenu abstractcontainermenu = this.minecraft.player.containerMenu;
        if (p_105034_.getContainerId() == abstractcontainermenu.containerId && abstractcontainermenu instanceof MerchantMenu) {
            MerchantMenu merchantmenu = (MerchantMenu)abstractcontainermenu;
            merchantmenu.setOffers(p_105034_.getOffers());
            merchantmenu.setXp(p_105034_.getVillagerXp());
            merchantmenu.setMerchantLevel(p_105034_.getVillagerLevel());
            merchantmenu.setShowProgressBar(p_105034_.showProgress());
            merchantmenu.setCanRestock(p_105034_.canRestock());
        }
    }

    public void handleSetChunkCacheRadius(ClientboundSetChunkCacheRadiusPacket p_105082_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105082_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.serverChunkRadius = p_105082_.getRadius();
        this.minecraft.options.setServerRenderDistance(this.serverChunkRadius);
        this.level.getChunkSource().updateViewRadius(p_105082_.getRadius());
    }

    public void handleSetSimulationDistance(ClientboundSetSimulationDistancePacket p_194245_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_194245_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.serverSimulationDistance = p_194245_.simulationDistance();
        this.level.setServerSimulationDistance(this.serverSimulationDistance);
    }

    public void handleSetChunkCacheCenter(ClientboundSetChunkCacheCenterPacket p_105080_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_105080_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.getChunkSource().updateViewCenter(p_105080_.getX(), p_105080_.getZ());
    }

    public void handleBlockChangedAck(ClientboundBlockChangedAckPacket p_233698_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_233698_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        this.level.handleBlockChangedAck(p_233698_.sequence());
    }

    public void handleBundlePacket(ClientboundBundlePacket p_265195_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_265195_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        for (Packet packet : p_265195_.subPackets()) {
            packet.handle((PacketListener)this);
        }
    }

    public void handleProjectilePowerPacket(ClientboundProjectilePowerPacket p_339600_) {
        PacketUtils.ensureRunningOnSameThread((Packet)p_339600_, (PacketListener)this, (BlockableEventLoop)((Object)this.minecraft));
        Entity entity = this.level.getEntity(p_339600_.getId());
        if (entity instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile abstracthurtingprojectile = (AbstractHurtingProjectile)entity;
            abstracthurtingprojectile.accelerationPower = p_339600_.getAccelerationPower();
        }
    }

    public void handleChunkBatchStart(ClientboundChunkBatchStartPacket p_295704_) {
        this.chunkBatchSizeCalculator.onBatchStart();
    }

    public void handleChunkBatchFinished(ClientboundChunkBatchFinishedPacket p_295731_) {
        this.chunkBatchSizeCalculator.onBatchFinished(p_295731_.batchSize());
        this.send((Packet<?>)new ServerboundChunkBatchReceivedPacket(this.chunkBatchSizeCalculator.getDesiredChunksPerTick()));
    }

    public void handleDebugSample(ClientboundDebugSamplePacket p_324125_) {
        this.minecraft.getDebugOverlay().logRemoteSample(p_324125_.sample(), p_324125_.debugSampleType());
    }

    public void handlePongResponse(ClientboundPongResponsePacket p_320651_) {
        this.pingDebugMonitor.onPongReceived(p_320651_);
    }

    private void readSectionList(int p_171735_, int p_171736_, LevelLightEngine p_171737_, LightLayer p_171738_, BitSet p_171739_, BitSet p_171740_, Iterator<byte[]> p_171741_) {
        for (int i = 0; i < p_171737_.getLightSectionCount(); ++i) {
            int j = p_171737_.getMinLightSection() + i;
            boolean flag = p_171739_.get(i);
            boolean flag1 = p_171740_.get(i);
            if (!flag && !flag1) continue;
            p_171737_.queueSectionData(p_171738_, SectionPos.of((int)p_171735_, (int)j, (int)p_171736_), flag ? new DataLayer((byte[])p_171741_.next().clone()) : new DataLayer());
            this.level.setSectionDirtyWithNeighbors(p_171735_, j, p_171736_);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.closed;
    }

    public Collection<PlayerInfo> getListedOnlinePlayers() {
        return this.listedPlayers;
    }

    public Collection<PlayerInfo> getOnlinePlayers() {
        return this.playerInfoMap.values();
    }

    public Collection<UUID> getOnlinePlayerIds() {
        return this.playerInfoMap.keySet();
    }

    @Nullable
    public PlayerInfo getPlayerInfo(UUID p_104950_) {
        return this.playerInfoMap.get(p_104950_);
    }

    @Nullable
    public PlayerInfo getPlayerInfo(String p_104939_) {
        for (PlayerInfo playerinfo : this.playerInfoMap.values()) {
            if (!playerinfo.getProfile().getName().equals(p_104939_)) continue;
            return playerinfo;
        }
        return null;
    }

    public GameProfile getLocalGameProfile() {
        return this.localGameProfile;
    }

    public ClientAdvancements getAdvancements() {
        return this.advancements;
    }

    public CommandDispatcher<SharedSuggestionProvider> getCommands() {
        return this.commands;
    }

    public ClientLevel getLevel() {
        return this.level;
    }

    public DebugQueryHandler getDebugQueryHandler() {
        return this.debugQueryHandler;
    }

    public UUID getId() {
        return this.id;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public RegistryAccess.Frozen registryAccess() {
        return this.registryAccess;
    }

    public void markMessageAsProcessed(PlayerChatMessage p_242356_, boolean p_242455_) {
        MessageSignature messagesignature = p_242356_.signature();
        if (messagesignature != null && this.lastSeenMessages.addPending(messagesignature, p_242455_) && this.lastSeenMessages.offset() > 64) {
            this.sendChatAcknowledgement();
        }
    }

    private void sendChatAcknowledgement() {
        int i = this.lastSeenMessages.getAndClearOffset();
        if (i > 0) {
            this.send((Packet<?>)new ServerboundChatAckPacket(i));
        }
    }

    public void sendChat(String p_249888_) {
        if ((p_249888_ = ClientHooks.onClientSendMessage((String)p_249888_)).isEmpty()) {
            return;
        }
        Instant instant = Instant.now();
        long i = Crypt.SaltSupplier.getLong();
        LastSeenMessagesTracker.Update lastseenmessagestracker$update = this.lastSeenMessages.generateAndApplyUpdate();
        MessageSignature messagesignature = this.signedMessageEncoder.pack(new SignedMessageBody(p_249888_, instant, i, lastseenmessagestracker$update.lastSeen()));
        this.send((Packet<?>)new ServerboundChatPacket(p_249888_, instant, i, messagesignature, lastseenmessagestracker$update.update()));
    }

    public void sendCommand(String p_250092_) {
        if (ClientCommandHandler.runCommand((String)p_250092_)) {
            return;
        }
        SignableCommand<SharedSuggestionProvider> signablecommand = SignableCommand.of(this.parseCommand(p_250092_));
        if (signablecommand.arguments().isEmpty()) {
            this.send((Packet<?>)new ServerboundChatCommandPacket(p_250092_));
        } else {
            Instant instant = Instant.now();
            long i = Crypt.SaltSupplier.getLong();
            LastSeenMessagesTracker.Update lastseenmessagestracker$update = this.lastSeenMessages.generateAndApplyUpdate();
            ArgumentSignatures argumentsignatures = ArgumentSignatures.signCommand(signablecommand, p_247875_ -> {
                SignedMessageBody signedmessagebody = new SignedMessageBody(p_247875_, instant, i, lastseenmessagestracker$update.lastSeen());
                return this.signedMessageEncoder.pack(signedmessagebody);
            });
            this.send((Packet<?>)new ServerboundChatCommandSignedPacket(p_250092_, instant, i, argumentsignatures, lastseenmessagestracker$update.update()));
        }
    }

    public boolean sendUnsignedCommand(String p_251509_) {
        if (ClientCommandHandler.runCommand((String)p_251509_)) {
            return true;
        }
        if (!SignableCommand.hasSignableArguments(this.parseCommand(p_251509_))) {
            this.send((Packet<?>)new ServerboundChatCommandPacket(p_251509_));
            return true;
        }
        return false;
    }

    private ParseResults<SharedSuggestionProvider> parseCommand(String p_249982_) {
        return this.commands.parse(p_249982_, (Object)this.suggestionsProvider);
    }

    public void tick() {
        ProfileKeyPairManager profilekeypairmanager;
        if (this.connection.isEncrypted() && (profilekeypairmanager = this.minecraft.getProfileKeyPairManager()).shouldRefreshKeyPair()) {
            profilekeypairmanager.prepareKeyPair().thenAcceptAsync(p_253339_ -> p_253339_.ifPresent(this::setKeyPair), (Executor)((Object)this.minecraft));
        }
        this.sendDeferredPackets();
        if (this.minecraft.getDebugOverlay().showNetworkCharts()) {
            this.pingDebugMonitor.tick();
        }
        this.debugSampleSubscriber.tick();
        this.telemetryManager.tick();
        if (this.levelLoadStatusManager != null) {
            this.levelLoadStatusManager.tick();
        }
    }

    public void setKeyPair(ProfileKeyPair p_261475_) {
        if (this.minecraft.isLocalPlayer(this.localGameProfile.getId()) && (this.chatSession == null || !this.chatSession.keyPair().equals((Object)p_261475_))) {
            this.chatSession = LocalChatSession.create((ProfileKeyPair)p_261475_);
            this.signedMessageEncoder = this.chatSession.createMessageEncoder(this.localGameProfile.getId());
            this.send((Packet<?>)new ServerboundChatSessionUpdatePacket(this.chatSession.asRemote().asData()));
        }
    }

    @Nullable
    public ServerData getServerData() {
        return this.serverData;
    }

    public FeatureFlagSet enabledFeatures() {
        return this.enabledFeatures;
    }

    public boolean isFeatureEnabled(FeatureFlagSet p_250605_) {
        return p_250605_.isSubsetOf(this.enabledFeatures());
    }

    public Scoreboard scoreboard() {
        return this.scoreboard;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public PotionBrewing potionBrewing() {
        return this.potionBrewing;
    }

    public void updateSearchTrees() {
        this.searchTrees.rebuildAfterLanguageChange();
    }

    public SessionSearchTrees searchTrees() {
        return this.searchTrees;
    }

    public ServerLinks serverLinks() {
        return this.serverLinks;
    }
}

