/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider EMPTY = p_325641_ -> Optional.empty();

    public Optional<Resource> getResource(ResourceLocation var1);

    default public Resource getResourceOrThrow(ResourceLocation p_215594_) throws FileNotFoundException {
        return this.getResource(p_215594_).orElseThrow(() -> new FileNotFoundException(p_215594_.toString()));
    }

    default public InputStream open(ResourceLocation p_215596_) throws IOException {
        return this.getResourceOrThrow(p_215596_).open();
    }

    default public BufferedReader openAsReader(ResourceLocation p_215598_) throws IOException {
        return this.getResourceOrThrow(p_215598_).openAsReader();
    }

    public static ResourceProvider fromMap(Map<ResourceLocation, Resource> p_251819_) {
        return p_248274_ -> Optional.ofNullable((Resource)p_251819_.get(p_248274_));
    }
}

