/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;

public interface ResourceMetadata {
    public static final ResourceMetadata EMPTY = new ResourceMetadata(){

        @Override
        public <T> Optional<T> getSection(MetadataSectionSerializer<T> p_215584_) {
            return Optional.empty();
        }
    };
    public static final IoSupplier<ResourceMetadata> EMPTY_SUPPLIER = () -> EMPTY;

    public static ResourceMetadata fromJsonStream(InputStream p_215581_) throws IOException {
        try (BufferedReader $$1 = new BufferedReader(new InputStreamReader(p_215581_, StandardCharsets.UTF_8));){
            final JsonObject $$2 = GsonHelper.parse($$1);
            ResourceMetadata resourceMetadata = new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> p_215589_) {
                    String $$1 = p_215589_.getMetadataSectionName();
                    return $$2.has($$1) ? Optional.of(p_215589_.fromJson(GsonHelper.getAsJsonObject($$2, $$1))) : Optional.empty();
                }
            };
            return resourceMetadata;
        }
    }

    public <T> Optional<T> getSection(MetadataSectionSerializer<T> var1);

    default public ResourceMetadata copySections(Collection<MetadataSectionSerializer<?>> p_295308_) {
        Builder $$1 = new Builder();
        for (MetadataSectionSerializer<?> $$2 : p_295308_) {
            this.copySection($$1, $$2);
        }
        return $$1.build();
    }

    private <T> void copySection(Builder p_295962_, MetadataSectionSerializer<T> p_294347_) {
        this.getSection(p_294347_).ifPresent(p_293816_ -> p_295962_.put(p_294347_, p_293816_));
    }

    public static class Builder {
        private final ImmutableMap.Builder<MetadataSectionSerializer<?>, Object> map = ImmutableMap.builder();

        public <T> Builder put(MetadataSectionSerializer<T> p_294292_, T p_294133_) {
            this.map.put(p_294292_, p_294133_);
            return this;
        }

        public ResourceMetadata build() {
            final ImmutableMap $$0 = this.map.build();
            if ($$0.isEmpty()) {
                return EMPTY;
            }
            return new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> p_295383_) {
                    return Optional.ofNullable($$0.get(p_295383_));
                }
            };
        }
    }
}

