/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.util;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TickedScheduler
implements Runnable {
    private final MinecraftServer server;
    private final Queue<TickTask> queue = new PriorityBlockingQueue<TickTask>();
    private final Map<Integer, Integer> idMap = new ConcurrentHashMap<Integer, Integer>();

    public TickedScheduler(MinecraftServer server) {
        this.server = server;
    }

    public void schedule(Runnable task, int delay) {
        this.schedule(task, delay, task);
    }

    public void schedule(Runnable task, int delay, Object id) {
        int taskId = id.hashCode();
        int serverTick = this.server.getTickCount();
        this.idMap.merge(taskId, serverTick, Integer::max);
        this.queue.add(new TickTask(serverTick, serverTick + delay, taskId, task));
    }

    public void cancel(Object id) {
        int taskId = id.hashCode();
        this.idMap.remove(taskId);
    }

    @Override
    public void run() {
        TickTask nextTask;
        while ((nextTask = this.queue.peek()) != null && nextTask.runOnTick() <= this.server.getTickCount()) {
            TickTask tickTask = this.queue.remove();
            Integer lastTaskScheduledOnTick = this.idMap.get(tickTask.id());
            if (lastTaskScheduledOnTick == null || lastTaskScheduledOnTick > tickTask.scheduledOnTick()) continue;
            this.idMap.remove(tickTask.id());
            if (tickTask.task() == null) continue;
            tickTask.task().run();
        }
    }

    private record TickTask(int scheduledOnTick, int runOnTick, int id, Runnable task) implements Comparable<TickTask>
    {
        @Override
        public int compareTo(@NotNull TickTask other) {
            return Integer.compare(this.runOnTick, other.runOnTick);
        }
    }
}

