/*
 * Decompiled with CFR 0.152.
 */
package net.lionarius.skinrestorer.skin.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mojang.authlib.Environment;
import com.mojang.authlib.EnvironmentParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilEnvironment;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.util.UndashedUuid;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.lionarius.skinrestorer.SkinRestorer;
import net.lionarius.skinrestorer.config.provider.MojangProviderConfig;
import net.lionarius.skinrestorer.exception.TransparentException;
import net.lionarius.skinrestorer.skin.SkinVariant;
import net.lionarius.skinrestorer.skin.provider.SkinProvider;
import net.lionarius.skinrestorer.skin.provider.SkinProviderContext;
import net.lionarius.skinrestorer.util.JsonUtils;
import net.lionarius.skinrestorer.util.PlayerUtils;
import net.lionarius.skinrestorer.util.Result;
import net.lionarius.skinrestorer.util.WebUtils;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MojangSkinProvider
implements SkinProvider {
    public static final String PROVIDER_NAME = "mojang";
    private static final Environment ENVIRONMENT;
    private static final URI SERVICES_SERVER_URI;
    private static final URI SESSION_SERVER_URI;
    public static final String PROFILE_CACHE_FILENAME = "mojang_profile_cache.json";
    private static final GameProfileCache PROFILE_CACHE;
    private static LoadingCache<UUID, Optional<Property>> SKIN_CACHE;

    public static void reload() {
        MojangSkinProvider.createCache();
    }

    private static void createCache() {
        MojangProviderConfig config = SkinRestorer.getConfig().providersConfig().mojang();
        long time = config.cache().enabled() ? config.cache().duration() : 0L;
        SKIN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(time, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<UUID, Optional<Property>>(){

            @NotNull
            public Optional<Property> load(@NotNull UUID key) throws Exception {
                return MojangSkinProvider.loadSkin(key);
            }
        });
    }

    public static SkinProviderContext skinProviderContextFromProfile(GameProfile gameProfile) {
        return new SkinProviderContext(PROVIDER_NAME, gameProfile.getName(), null);
    }

    @Override
    public String getArgumentName() {
        return "username";
    }

    @Override
    public boolean hasVariantSupport() {
        return false;
    }

    @Override
    public Result<Optional<Property>, Exception> fetchSkin(String username, SkinVariant variant) {
        try {
            if (!StringUtil.isValidPlayerName((String)username)) {
                throw new IllegalArgumentException("invalid username");
            }
            Optional cachedProfile = PROFILE_CACHE.get(username);
            if (cachedProfile.isEmpty()) {
                throw new IllegalArgumentException("no profile found for " + username);
            }
            return Result.success((Optional)SKIN_CACHE.get((Object)((GameProfile)cachedProfile.get()).getId()));
        }
        catch (UncheckedExecutionException e) {
            return Result.error((Exception)e.getCause());
        }
        catch (Exception e) {
            return Result.error(e);
        }
    }

    private static Optional<Property> loadSkin(UUID uuid) throws Exception {
        GameProfile profile = MojangSkinProvider.getProfileWithProperties(uuid);
        Property textures = PlayerUtils.getPlayerSkin(profile);
        return Optional.ofNullable(textures);
    }

    private static GameProfile getProfile(String name) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(SERVICES_SERVER_URI.resolve("/minecraft/profile/lookup/name/").resolve(name)).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with name " + name);
        }
        return JsonUtils.fromJson(response.body(), GameProfile.class);
    }

    private static GameProfile getProfileWithProperties(UUID uuid) throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(SESSION_SERVER_URI.resolve("/session/minecraft/profile/").resolve(UndashedUuid.toString((UUID)uuid) + "?unsigned=false")).GET().build();
        HttpResponse<String> response = WebUtils.executeRequest(request);
        WebUtils.throwOnClientErrors(response);
        if (response.statusCode() != 200) {
            throw new IllegalArgumentException("no profile with uuid " + String.valueOf(uuid));
        }
        return JsonUtils.fromJson(response.body(), MinecraftProfilePropertiesResponse.class).toProfile();
    }

    static {
        try {
            ENVIRONMENT = EnvironmentParser.getEnvironmentFromProperties().orElse(YggdrasilEnvironment.PROD.getEnvironment());
            SERVICES_SERVER_URI = new URI(ENVIRONMENT.servicesHost());
            SESSION_SERVER_URI = new URI(ENVIRONMENT.sessionHost());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        PROFILE_CACHE = new GameProfileCache((names, callback) -> {
            for (String name : names) {
                try {
                    GameProfile profile = MojangSkinProvider.getProfile(name);
                    callback.onProfileLookupSucceeded(profile);
                }
                catch (IOException e) {
                    throw new TransparentException(e);
                }
            }
        }, SkinRestorer.getConfigDir().resolve(PROFILE_CACHE_FILENAME).toFile());
    }
}

