/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure.processor;

import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.BlockStateRandomizer;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.processor.ProcessorHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BlockSwapProcessor
extends StructureProcessor {
    public static final MapCodec<BlockSwapProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.listOf().fieldOf("to_replace").forGetter(config -> config.toReplace), (App)BlockStateRandomizer.CODEC.fieldOf("replace_with").forGetter(config -> config.replaceWith), (App)Codec.BOOL.optionalFieldOf("copy_properties", (Object)true).forGetter(config -> config.copyProperties)).apply((Applicative)instance, instance.stable(BlockSwapProcessor::new)));
    private final List<BlockState> toReplace;
    private final BlockStateRandomizer replaceWith;
    private final boolean copyProperties;

    public BlockSwapProcessor(List<BlockState> toReplace, BlockStateRandomizer replaceWith, boolean copyProperties) {
        this.toReplace = toReplace;
        this.replaceWith = replaceWith;
        this.copyProperties = copyProperties;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ProcessorHandler.BLOCK_SWAP_PROCESSOR.value();
    }

    public StructureTemplate.StructureBlockInfo process(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, StructureTemplate template) {
        for (BlockState toReplaceState : this.toReplace) {
            WorldGenRegion worldGenRegion;
            if (!blockInfoGlobal.state().is(toReplaceState.getBlock())) continue;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            BlockState newState = this.replaceWith.chooseRandomState(random);
            if (this.copyProperties) {
                newState = newState.getBlock().withPropertiesOf(blockInfoGlobal.state());
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), newState, blockInfoGlobal.nbt());
            break;
        }
        return blockInfoGlobal;
    }
}

