/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.client.render.item.RenderUmvuthanaMaskArmor;
import com.bobmowzie.mowziesmobs.client.render.item.RenderUmvuthanaMaskItem;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCraneToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollowerToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemSolVisage;
import com.bobmowzie.mowziesmobs.server.item.MaterialHandler;
import com.bobmowzie.mowziesmobs.server.item.UmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemUmvuthanaMask
extends ArmorItem
implements UmvuthanaMask,
GeoItem {
    private final MaskType type;
    public String controllerName = "controller";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation UMVUTHANA_ANIM = RawAnimation.begin().thenLoop("umvuthana");
    private static final RawAnimation PLAYER_ANIM = RawAnimation.begin().thenLoop("player");

    public ItemUmvuthanaMask(MaskType type, Item.Properties properties) {
        super(MaterialHandler.UMVUTHANA_MASK_MATERIAL, ArmorItem.Type.HELMET, properties);
        this.type = type;
    }

    public Holder<MobEffect> getPotion() {
        return this.type.potion;
    }

    public boolean isValidRepairItem(ItemStack itemStack, ItemStack materialItemStack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ItemStack headStack = (ItemStack)player.getInventory().armor.get(3);
        if (headStack.getItem() instanceof ItemSolVisage) {
            boolean didSpawn;
            if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.breakable.get()).booleanValue() && !player.isCreative()) {
                headStack.hurtAndBreak(2, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            if (didSpawn = this.spawnUmvuthana(this.type, stack, player, (float)stack.getDamageValue() / (float)stack.getMaxDamage())) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return super.use(world, player, hand);
    }

    private boolean spawnUmvuthana(MaskType mask, ItemStack stack, Player player, float durability) {
        if (DataHandler.getData((Entity)player, DataHandler.PLAYER_DATA).getPackSize() < (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SOL_VISAGE.maxFollowers.get()) {
            player.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHI_BELLY.get(), 1.5f, 1.0f);
            player.playSound((SoundEvent)MMSounds.ENTITY_UMVUTHANA_BLOWDART.get(), 1.5f, 0.5f);
            double angle = player.getYHeadRot();
            if (angle < 0.0) {
                angle += 360.0;
            }
            EntityUmvuthanaFollowerToPlayer umvuthana = mask == MaskType.FAITH ? new EntityUmvuthanaCraneToPlayer((EntityType<? extends EntityUmvuthanaCraneToPlayer>)((EntityType)EntityHandler.UMVUTHANA_CRANE_TO_PLAYER.get()), player.level(), player) : new EntityUmvuthanaFollowerToPlayer((EntityType<? extends EntityUmvuthanaFollowerToPlayer>)((EntityType)EntityHandler.UMVUTHANA_FOLLOWER_TO_PLAYER.get()), player.level(), player);
            if (!player.level().isClientSide) {
                if (mask != MaskType.FAITH) {
                    int weapon = mask != MaskType.FURY ? umvuthana.randomizeWeapon() : 0;
                    umvuthana.setWeapon(weapon);
                }
                umvuthana.absMoveTo(player.getX() + 1.0 * Math.sin(-angle * (Math.PI / 180)), player.getY() + 1.5, player.getZ() + 1.0 * Math.cos(-angle * (Math.PI / 180)), (float)angle, 0.0f);
                umvuthana.setActive(false);
                umvuthana.active = false;
                player.level().addFreshEntity((Entity)umvuthana);
                double vx = 0.5 * Math.sin(-angle * Math.PI / 180.0);
                double vy = 0.5;
                double vz = 0.5 * Math.cos(-angle * Math.PI / 180.0);
                umvuthana.setDeltaMovement(vx, vy, vz);
                umvuthana.setHealth((1.0f - durability) * umvuthana.getMaxHealth());
                umvuthana.setMask(mask);
                umvuthana.setStoredMask(stack.copy());
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    umvuthana.setCustomName(stack.getHoverName());
                }
            }
            return true;
        }
        return false;
    }

    public MaskType getMaskType() {
        return this.type;
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)("textures/item/umvuthana_mask_" + this.type.name + ".png"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.0")).setStyle(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.1")).setStyle(ItemHandler.TOOLTIP_STYLE));
    }

    public <P extends Item> PlayState predicate(AnimationState<P> event) {
        Entity entity = (Entity)event.getData(DataTickets.ENTITY);
        if (entity instanceof EntityUmvuthana) {
            event.getController().setAnimation(UMVUTHANA_ANIM);
        } else {
            event.getController().setAnimation(PLAYER_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, this.controllerName, 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class ClientExtensions
    implements IClientItemExtensions {
        private final BlockEntityWithoutLevelRenderer itemRenderer = new RenderUmvuthanaMaskItem();
        private GeoArmorRenderer<?> armorRenderer;

        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            if (this.armorRenderer == null) {
                this.armorRenderer = new RenderUmvuthanaMaskArmor();
            }
            if (equipmentSlot == EquipmentSlot.HEAD) {
                this.armorRenderer.prepForRender((Entity)entityLiving, itemStack, equipmentSlot, original);
            }
            return this.armorRenderer;
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return this.itemRenderer;
        }
    }
}

