/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.FireballAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.IceBreathAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.SimplePlayerAnimationAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.WroughtAxeSlamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.WroughtAxeSwingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.BoulderRollAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.FissureAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.GroundSlamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.HitBoulderAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.RockSlingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.SpawnBoulderAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.SpawnPillarAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.geomancy.TunnelingAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SolarBeamAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SolarFlareAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SunstrikeAbility;
import com.bobmowzie.mowziesmobs.server.ability.abilities.player.heliomancy.SupernovaAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityData;
import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.bobmowzie.mowziesmobs.server.message.MessageInterruptAbility;
import com.bobmowzie.mowziesmobs.server.message.MessageJumpToAbilitySectionServerToClient;
import com.bobmowzie.mowziesmobs.server.message.MessagePlayerUseAbility;
import com.bobmowzie.mowziesmobs.server.message.MessageUseAbility;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public enum AbilityHandler {
    INSTANCE;

    public static final AbilityType<Player, FireballAbility> FIREBALL_ABILITY;
    public static final AbilityType<Player, SunstrikeAbility> SUNSTRIKE_ABILITY;
    public static final AbilityType<Player, SolarBeamAbility> SOLAR_BEAM_ABILITY;
    public static final AbilityType<Player, SolarFlareAbility> SOLAR_FLARE_ABILITY;
    public static final AbilityType<Player, SupernovaAbility> SUPERNOVA_ABILITY;
    public static final AbilityType<Player, WroughtAxeSwingAbility> WROUGHT_AXE_SWING_ABILITY;
    public static final AbilityType<Player, WroughtAxeSlamAbility> WROUGHT_AXE_SLAM_ABILITY;
    public static final AbilityType<Player, IceBreathAbility> ICE_BREATH_ABILITY;
    public static final AbilityType<Player, SpawnBoulderAbility> SPAWN_BOULDER_ABILITY;
    public static final AbilityType<Player, TunnelingAbility> TUNNELING_ABILITY;
    public static final AbilityType<Player, HitBoulderAbility> HIT_BOULDER_ABILITY;
    public static final AbilityType<Player, SpawnPillarAbility> SPAWN_PILLAR_ABILITY;
    public static final AbilityType<Player, GroundSlamAbility> GROUND_SLAM_ABILITY;
    public static final AbilityType<Player, BoulderRollAbility> BOULDER_ROLL_ABILITY;
    public static final AbilityType<Player, FissureAbility> FISSURE_ABILITY;
    public static final AbilityType<Player, SimplePlayerAnimationAbility> BACKSTAB_ABILITY;
    public static final AbilityType<Player, RockSlingAbility> ROCK_SLING;
    public static final AbilityType<Player, ? extends PlayerAbility>[] PLAYER_ABILITIES;

    @Nullable
    public Ability<?> getAbility(LivingEntity entity, AbilityType<?, ?> abilityType) {
        return DataHandler.getData((Entity)entity, DataHandler.ABILITY_DATA).getAbilityMap().get(abilityType);
    }

    public <T extends LivingEntity> void sendAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        if (entity.level().isClientSide) {
            return;
        }
        AbilityData data = DataHandler.getData(entity, DataHandler.ABILITY_DATA);
        Ability<?> instance = data.getAbilityMap().get(abilityType);
        if (instance != null && instance.canUse()) {
            data.activateAbility(entity, abilityType);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf(entity, (CustomPacketPayload)new MessageUseAbility(entity.getId(), ArrayUtils.indexOf((Object[])data.getAbilityTypesOnEntity(entity), abilityType)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public <T extends LivingEntity> void sendInterruptAbilityMessage(T entity, AbilityType<?, ?> abilityType) {
        if (entity.level().isClientSide) {
            return;
        }
        AbilityData data = DataHandler.getData(entity, DataHandler.ABILITY_DATA);
        Ability<?> instance = data.getAbilityMap().get(abilityType);
        if (instance.isUsing()) {
            instance.interrupt();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf(entity, (CustomPacketPayload)new MessageInterruptAbility(entity.getId(), ArrayUtils.indexOf((Object[])data.getAbilityTypesOnEntity(entity), abilityType)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public <T extends Player> void sendPlayerTryAbilityMessage(T entity, AbilityType<?, ?> ability) {
        if (!entity.level().isClientSide()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new MessagePlayerUseAbility(ArrayUtils.indexOf((Object[])DataHandler.getData(entity, DataHandler.ABILITY_DATA).getAbilityTypesOnEntity((LivingEntity)entity), ability)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public <T extends LivingEntity> void sendJumpToSectionMessage(T entity, AbilityType<?, ?> abilityType, int sectionIndex) {
        if (entity.level().isClientSide) {
            return;
        }
        AbilityData data = DataHandler.getData(entity, DataHandler.ABILITY_DATA);
        Ability<?> instance = data.getAbilityMap().get(abilityType);
        if (instance.isUsing()) {
            instance.jumpToSection(sectionIndex);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf(entity, (CustomPacketPayload)new MessageJumpToAbilitySectionServerToClient(entity.getId(), ArrayUtils.indexOf((Object[])data.getAbilityTypesOnEntity(entity), abilityType), sectionIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static {
        FIREBALL_ABILITY = new AbilityType<Player, FireballAbility>("fireball", FireballAbility::new);
        SUNSTRIKE_ABILITY = new AbilityType<Player, SunstrikeAbility>("sunstrike", SunstrikeAbility::new);
        SOLAR_BEAM_ABILITY = new AbilityType<Player, SolarBeamAbility>("solar_beam", SolarBeamAbility::new);
        SOLAR_FLARE_ABILITY = new AbilityType<Player, SolarFlareAbility>("solar_flare", SolarFlareAbility::new);
        SUPERNOVA_ABILITY = new AbilityType<Player, SupernovaAbility>("supernova", SupernovaAbility::new);
        WROUGHT_AXE_SWING_ABILITY = new AbilityType<Player, WroughtAxeSwingAbility>("wrought_axe_swing", WroughtAxeSwingAbility::new);
        WROUGHT_AXE_SLAM_ABILITY = new AbilityType<Player, WroughtAxeSlamAbility>("wrought_axe_slam", WroughtAxeSlamAbility::new);
        ICE_BREATH_ABILITY = new AbilityType<Player, IceBreathAbility>("ice_breath", IceBreathAbility::new);
        SPAWN_BOULDER_ABILITY = new AbilityType<Player, SpawnBoulderAbility>("spawn_boulder", SpawnBoulderAbility::new);
        TUNNELING_ABILITY = new AbilityType<Player, TunnelingAbility>("tunneling", TunnelingAbility::new);
        HIT_BOULDER_ABILITY = new AbilityType<Player, HitBoulderAbility>("hit_boulder", HitBoulderAbility::new);
        SPAWN_PILLAR_ABILITY = new AbilityType<Player, SpawnPillarAbility>("spawn_pillar", SpawnPillarAbility::new);
        GROUND_SLAM_ABILITY = new AbilityType<Player, GroundSlamAbility>("ground_slam", GroundSlamAbility::new);
        BOULDER_ROLL_ABILITY = new AbilityType<Player, BoulderRollAbility>("boulder_roll", BoulderRollAbility::new);
        FISSURE_ABILITY = new AbilityType<Player, FissureAbility>("fissure", FissureAbility::new);
        BACKSTAB_ABILITY = new AbilityType<Player, SimplePlayerAnimationAbility>("backstab", (type, player) -> new SimplePlayerAnimationAbility(type, (Player)player, "backstab", 12, false, true, true));
        ROCK_SLING = new AbilityType<Player, RockSlingAbility>("rock_sling", RockSlingAbility::new);
        PLAYER_ABILITIES = new AbilityType[]{SUNSTRIKE_ABILITY, SOLAR_BEAM_ABILITY, SOLAR_FLARE_ABILITY, SUPERNOVA_ABILITY, WROUGHT_AXE_SWING_ABILITY, WROUGHT_AXE_SLAM_ABILITY, ICE_BREATH_ABILITY, SPAWN_BOULDER_ABILITY, SPAWN_PILLAR_ABILITY, TUNNELING_ABILITY, HIT_BOULDER_ABILITY, ROCK_SLING, BACKSTAB_ABILITY};
    }
}

