/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.datagen;

import com.bobmowzie.mowziesmobs.datagen.StructureHandler;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureSetHandler {
    public static ResourceKey<StructureSet> WROUGHT_CHAMBERS = StructureSetHandler.createSetKey("wrought_chambers");
    public static ResourceKey<StructureSet> UMVUTHANA_GROVES = StructureSetHandler.createSetKey("umvuthana_groves");
    public static ResourceKey<StructureSet> FROSTMAWS = StructureSetHandler.createSetKey("frostmaw_spawns");
    public static ResourceKey<StructureSet> MONASTERIES = StructureSetHandler.createSetKey("monasteries");

    private static ResourceKey<StructureSet> createSetKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)name));
    }

    public static void bootstrap(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        Optional<StructurePlacement.ExclusionZone> villageExclusionZone = Optional.of(new StructurePlacement.ExclusionZone((Holder)context.lookup(Registries.STRUCTURE_SET).getOrThrow(BuiltinStructureSets.VILLAGES), 7));
        context.register(WROUGHT_CHAMBERS, (Object)new StructureSet((Holder)structures.getOrThrow(StructureHandler.WROUGHT_CHAMBER), (StructurePlacement)new RandomSpreadStructurePlacement(15, 5, RandomSpreadType.TRIANGULAR, 23217347)));
        context.register(UMVUTHANA_GROVES, (Object)new StructureSet((Holder)structures.getOrThrow(StructureHandler.UMVUTHANA_GROVE), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 23311138, villageExclusionZone, 25, 8, RandomSpreadType.TRIANGULAR)));
        context.register(FROSTMAWS, (Object)new StructureSet((Holder)structures.getOrThrow(StructureHandler.FROSTMAW), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 23317578, villageExclusionZone, 25, 8, RandomSpreadType.TRIANGULAR)));
    }
}

