/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import org.jetbrains.annotations.NotNull;

public interface RGValidator<T> {
    public boolean validate(@NotNull T var1, @NotNull String var2);

    default public String reason() {
        return "The input value is illegal!";
    }

    public static class CommandRuleValidator
    extends StringInSetValidator {
        @Override
        public Set<String> getSet() {
            return Set.of("ops", "true", "false", "1", "2", "3", "4");
        }

        public static String @NotNull [] getPermissionLevels() {
            return new String[]{"ops", "true", "false", "0", "1", "2", "3", "4"};
        }

        public static boolean hasPermission(@NotNull Supplier<?> supplier, @NotNull CommandSourceStack stack) {
            String s;
            return switch (s = String.valueOf(supplier.get())) {
                case "0" -> stack.hasPermission(0);
                case "1" -> stack.hasPermission(1);
                case "ops", "2" -> stack.hasPermission(2);
                case "3" -> stack.hasPermission(3);
                case "4" -> stack.hasPermission(4);
                case "true", "TRUE" -> true;
                default -> false;
            };
        }
    }

    public static abstract class DoubleValidator
    extends NumberValidator<Double> {
        @Override
        protected Double parse(@NotNull String newValue) {
            return Double.parseDouble(newValue);
        }
    }

    public static abstract class FloatValidator
    extends NumberValidator<Float> {
        @Override
        protected Float parse(@NotNull String newValue) {
            return Float.valueOf(Float.parseFloat(newValue));
        }
    }

    public static abstract class LongValidator
    extends NumberValidator<Long> {
        @Override
        protected Long parse(@NotNull String newValue) {
            return Long.parseLong(newValue);
        }
    }

    public static abstract class IntegerValidator
    extends NumberValidator<Integer> {
        @Override
        protected Integer parse(@NotNull String newValue) {
            return Integer.parseInt(newValue);
        }
    }

    public static abstract class ShortValidator
    extends NumberValidator<Short> {
        @Override
        protected Short parse(@NotNull String newValue) {
            return Short.parseShort(newValue);
        }
    }

    public static abstract class ByteValidator
    extends NumberValidator<Byte> {
        @Override
        protected Byte parse(@NotNull String newValue) {
            return Byte.parseByte(newValue);
        }
    }

    public static abstract class NumberValidator<T extends Number>
    implements RGValidator<T> {
        @NotNull
        public abstract Map.Entry<T, T> getRange();

        public Map.Entry<Boolean, Boolean> containsRange() {
            return Map.entry(true, true);
        }

        @Override
        public boolean validate(@NotNull T oldValue, @NotNull String newValue) {
            try {
                boolean flag1;
                T value = this.parse(newValue);
                boolean bl = this.containsRange().getKey().booleanValue() ? ((Number)value).doubleValue() >= ((Number)this.getRange().getKey()).doubleValue() : (flag1 = ((Number)value).doubleValue() > ((Number)this.getRange().getKey()).doubleValue());
                boolean flag2 = this.containsRange().getValue().booleanValue() ? ((Number)value).doubleValue() <= ((Number)this.getRange().getValue()).doubleValue() : ((Number)value).doubleValue() < ((Number)this.getRange().getValue()).doubleValue();
                return flag1 && flag2;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String reason() {
            return "The input value must be between " + ((Number)this.getRange().getKey()).toString() + " and " + ((Number)this.getRange().getValue()).toString() + "!";
        }

        protected abstract T parse(@NotNull String var1);
    }

    public static class BooleanValidator
    implements RGValidator<Boolean> {
        @Override
        public boolean validate(@NotNull Boolean oldValue, @NotNull String newValue) {
            return newValue.equals("true") || newValue.equals("false");
        }

        @Override
        public String reason() {
            return "The input value must be true or false!";
        }
    }

    public static class StringInSetValidator
    extends StringValidator {
        public Set<String> getSet() {
            return Set.of();
        }

        @Override
        public boolean validate(@NotNull String oldValue, @NotNull String newValue) {
            return super.validate(oldValue, newValue) && this.getSet().contains(newValue);
        }

        @Override
        public String reason() {
            return "The input value must be in the set: %s!".formatted(this.getSet().toString());
        }
    }

    public static class StringValidator
    implements RGValidator<String> {
        @Override
        public boolean validate(@NotNull String oldValue, @NotNull String newValue) {
            return !newValue.isEmpty();
        }

        @Override
        public String reason() {
            return "The input value must not be empty!";
        }
    }
}

