/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.Jade;

public class IgnoreList<T> {
    public List<String> values = List.of();
    public int version = 1;

    public void reload(Registry<T> registry, Consumer<T> consumer) {
        ArrayList patterns = Lists.newArrayList();
        for (String value : this.values) {
            try {
                if (value.startsWith("/") && value.endsWith("/") && value.length() > 1) {
                    patterns.add(Pattern.compile(value.substring(1, value.length() - 1)));
                    continue;
                }
                ResourceLocation id = ResourceLocation.parse((String)value);
                Optional optional = registry.getOptional(id);
                if (optional.isPresent()) {
                    consumer.accept(registry.get(id));
                    continue;
                }
                throw new IllegalArgumentException("Unknown id: " + String.valueOf(id));
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to parse ignore list entry: %s".formatted(value), (Throwable)e);
            }
        }
        if (patterns.isEmpty()) {
            return;
        }
        block3: for (Holder holder : registry.asHolderIdMap()) {
            String s = ((ResourceKey)holder.unwrapKey().orElseThrow()).location().toString();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(s).find()) continue;
                consumer.accept(holder.value());
                continue block3;
            }
        }
    }
}

