/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.TransformList;
import cpw.mods.modlauncher.TransformTargetLabel;
import cpw.mods.modlauncher.TransformerHolder;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TargetType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformStore {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> classNeedsTransforming = new HashSet<String>();
    private final Map<TargetType<?>, TransformList<?>> transformers = new HashMap();

    public TransformStore() {
        for (TargetType<?> type : TargetType.VALUES) {
            this.transformers.put(type, new TransformList(type.getNodeType()));
        }
    }

    List<ITransformer<FieldNode>> getTransformersFor(String className, FieldNode field) {
        TransformTargetLabel tl = new TransformTargetLabel(className, field.name);
        TransformList<FieldNode> transformerlist = TargetType.FIELD.get(this.transformers);
        return transformerlist.getTransformersForLabel(tl);
    }

    List<ITransformer<MethodNode>> getTransformersFor(String className, MethodNode method) {
        TransformTargetLabel tl = new TransformTargetLabel(className, method.name, method.desc);
        TransformList<MethodNode> transformerlist = TargetType.METHOD.get(this.transformers);
        return transformerlist.getTransformersForLabel(tl);
    }

    List<ITransformer<ClassNode>> getTransformersFor(String className, TargetType<ClassNode> classType) {
        TransformTargetLabel tl = new TransformTargetLabel(className, classType);
        TransformList<ClassNode> transformerlist = classType.get(this.transformers);
        return transformerlist.getTransformersForLabel(tl);
    }

    <T> void addTransformer(TransformTargetLabel targetLabel, ITransformer<T> transformer, ITransformationService service) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Adding transformer {} to {}", new Supplier[]{() -> transformer, () -> targetLabel});
        this.classNeedsTransforming.add(targetLabel.getClassName().getInternalName());
        TransformList<?> transformList = this.transformers.get(targetLabel.getTargetType());
        transformList.addTransformer(targetLabel, new TransformerHolder<T>(transformer, service));
    }

    boolean needsTransforming(String internalClassName) {
        return this.classNeedsTransforming.contains(internalClassName);
    }
}

