/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import com.mojang.authlib.properties.PropertyMap;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMinecart
extends AbstractMinecart
implements ITargetEntity {
    public static EntityType<TargetMinecart> TYPE = EntityType.Builder.of(TargetMinecart::new, (MobCategory)MobCategory.MISC).sized(0.75f, 2.4f).clientTrackingRange(8).build("target_minecart");
    @Nullable
    private ResolvableProfile gameProfile = null;

    public TargetMinecart(EntityType<TargetMinecart> type, Level world) {
        super(type, world);
    }

    public TargetMinecart(Level level, double x, double y, double z) {
        super(TYPE, level, x, y, z);
    }

    @Override
    public void onProjectileHit(Entity entity, EntityHitResult result, DamageSource source, float damage) {
        if (this.level().isClientSide() || this.isRemoved()) {
            return;
        }
        if (source.isDirect()) {
            return;
        }
        Entity sourceEntity = source.getEntity();
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            this.setHurtDir(-1);
            this.setHurtTime(10);
            this.markHurt();
            this.setDamage(10.0f);
            double dis = this.position().distanceTo(sourceEntity.position());
            player.displayClientMessage((Component)Component.translatable((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{String.format("%.1f", Float.valueOf(damage)), String.format("%.2f", dis)}), true);
            float volume = (float)((Integer)OtherConfig.TARGET_SOUND_DISTANCE.get()).intValue() / 16.0f;
            volume = Math.max(volume, 0.0f);
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.TARGET_HIT.get(), SoundSource.BLOCKS, volume, this.level().random.nextFloat() * 0.1f + 0.9f);
            if (entity instanceof EntityKineticBullet) {
                EntityKineticBullet projectile = (EntityKineticBullet)entity;
                boolean isHeadshot = false;
                float headshotMultiplier = 1.0f;
                NeoForge.EVENT_BUS.post((Event)new EntityHurtByGunEvent.Post((Entity)projectile, (Entity)this, (LivingEntity)player, projectile.getGunId(), projectile.getGunDisplayId(), damage, (Pair<DamageSource, DamageSource>)Pair.of((Object)source, (Object)source), isHeadshot, headshotMultiplier, LogicalSide.SERVER));
                NetworkHandler.sendToDimension(new ServerMessageGunHurt(projectile.getId(), this.getId(), player.getId(), projectile.getGunId(), projectile.getGunDisplayId(), damage, isHeadshot, headshotMultiplier), (Entity)this);
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_EXPLOSION) || super.isInvulnerableTo(source);
    }

    public boolean canBeRidden() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double size = this.getBoundingBox().getSize();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= (double)((Integer)RenderConfig.TARGET_RENDER_DISTANCE.get()).intValue() * TargetMinecart.getViewScale()) * size;
    }

    public void destroy(DamageSource source) {
        this.remove(Entity.RemovalReason.KILLED);
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.TARGET_MINECART.get());
            if (this.hasCustomName()) {
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            this.spawnAtLocation(itemStack);
        }
    }

    public Item getDropItem() {
        return (Item)ModItems.TARGET_MINECART.get();
    }

    public ItemStack getPickResult() {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.TARGET_MINECART.get());
        if (this.hasCustomName()) {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        }
        return itemStack;
    }

    @Nullable
    public ResolvableProfile getGameProfile() {
        if (this.gameProfile == null && this.getCustomName() != null) {
            this.gameProfile = new ResolvableProfile(Optional.of(this.getCustomName().getString()), Optional.empty(), new PropertyMap());
            this.gameProfile.resolve().thenAcceptAsync(profile -> {
                this.gameProfile = profile;
            });
        }
        return this.gameProfile;
    }

    @NotNull
    public BlockState getDefaultDisplayBlockState() {
        return ((Block)ModBlocks.TARGET.get()).defaultBlockState();
    }

    @NotNull
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public float getMaxCartSpeedOnRail() {
        return 0.2f;
    }
}

