/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunDrawEvent;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorAssetManager;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public class AnimationManager {
    public static boolean hasPlayerAnimator3rd(GunDisplayInstance display) {
        ResourceLocation location = display.getPlayerAnimator3rd();
        if (location == null) {
            return false;
        }
        return PlayerAnimatorAssetManager.get().containsKey(location);
    }

    public static boolean isFlying(AbstractClientPlayer player) {
        return !player.onGround() && player.getAbilities().flying;
    }

    public static void playRotationAnimation(AbstractClientPlayer player, GunDisplayInstance display) {
        String animationName = "empty";
        ResourceLocation dataId = PlayerAnimatorCompat.ROTATION_ANIMATION;
        ResourceLocation animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
        });
    }

    public static void playLowerAnimation(AbstractClientPlayer player, GunDisplayInstance display, float limbSwingAmount) {
        if (AnimationManager.isPlayerLie(player)) {
            return;
        }
        if (player.getVehicle() != null) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "ride_lower");
            return;
        }
        if (AnimationManager.isFlying(player)) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "hold_lower");
            return;
        }
        if (player.isSprinting()) {
            if (player.getPose() == Pose.CROUCHING) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_walk_lower");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "run_lower");
            }
            return;
        }
        if ((double)limbSwingAmount > 0.05) {
            if (player.getPose() == Pose.CROUCHING) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_walk_lower");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "walk_lower");
            }
            return;
        }
        if (player.getPose() == Pose.CROUCHING) {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "crouch_lower");
        } else {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOWER_ANIMATION, "hold_lower");
        }
    }

    public static void playLoopUpperAnimation(AbstractClientPlayer player, GunDisplayInstance display, float limbSwingAmount) {
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)player);
        float aimingProgress = operator.getSynAimingProgress();
        if (aimingProgress <= 0.0f) {
            if (!AnimationManager.isFlying(player) && player.isSprinting()) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
                } else if (player.getPose() == Pose.CROUCHING) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "crouch_walk_upper");
                } else {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "run_upper");
                }
                return;
            }
            if (!AnimationManager.isFlying(player) && (double)limbSwingAmount > 0.05) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
                } else if (player.getPose() == Pose.CROUCHING) {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "crouch_walk_upper");
                } else {
                    AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "walk_upper");
                }
                return;
            }
            if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "hold_upper");
            }
        } else if (AnimationManager.isPlayerLie(player)) {
            if (!AnimationManager.isFlying(player) && (double)limbSwingAmount > 0.05) {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_move");
            } else {
                AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "lie_aim");
            }
        } else {
            AnimationManager.playLoopAnimation(player, display, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, "aim_upper");
        }
    }

    public static void playLoopAnimation(AbstractClientPlayer player, GunDisplayInstance display, ResourceLocation dataId, String animationName) {
        ResourceLocation animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            KeyframeAnimationPlayer animationPlayer;
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            IAnimation patt0$temp = modifierLayer.getAnimation();
            if (patt0$temp instanceof KeyframeAnimationPlayer && (animationPlayer = (KeyframeAnimationPlayer)patt0$temp).isActive()) {
                String name;
                Object extraDataName = animationPlayer.getData().extraData.get("name");
                if (extraDataName instanceof String && !animationName.equals(name = (String)extraDataName)) {
                    AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
                    modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
                }
                return;
            }
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
        });
    }

    public static void playOnceAnimation(AbstractClientPlayer player, GunDisplayInstance display, ResourceLocation dataId, String animationName) {
        ResourceLocation animator3rd = display.getPlayerAnimator3rd();
        if (animator3rd == null) {
            return;
        }
        if (!PlayerAnimatorAssetManager.get().containsKey(animator3rd)) {
            return;
        }
        PlayerAnimatorAssetManager.get().getAnimations(animator3rd, animationName).ifPresent(keyframeAnimation -> {
            PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player);
            ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
            if (modifierLayer == null) {
                return;
            }
            IAnimation animation = modifierLayer.getAnimation();
            if (animation == null || !animation.isActive()) {
                AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)8, (Ease)Ease.INOUTSINE);
                modifierLayer.replaceAnimationWithFade(fadeModifier, (IAnimation)new KeyframeAnimationPlayer(keyframeAnimation));
            }
        });
    }

    public static void stopAllAnimation(AbstractClientPlayer player) {
        AnimationManager.stopAllAnimation(player, 8);
    }

    public static void stopAllAnimation(AbstractClientPlayer player, int fadeTime) {
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOWER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, fadeTime);
        AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ROTATION_ANIMATION, fadeTime);
    }

    private static void stopAnimation(AbstractClientPlayer player, ResourceLocation dataId, int fadeTime) {
        PlayerAnimationAccess.PlayerAssociatedAnimationData associatedData = PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player);
        ModifierLayer modifierLayer = (ModifierLayer)associatedData.get(dataId);
        if (modifierLayer != null && modifierLayer.isActive()) {
            AbstractFadeModifier fadeModifier = AbstractFadeModifier.standardFadeIn((int)fadeTime, (Ease)Ease.INOUTSINE);
            modifierLayer.replaceAnimationWithFade(fadeModifier, null);
        }
    }

    private static boolean isPlayerLie(AbstractClientPlayer player) {
        return !player.isSwimming() && player.getPose() == Pose.SWIMMING;
    }

    @SubscribeEvent
    public void onFire(GunShootEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        LivingEntity shooter = event.getShooter();
        if (!(shooter instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)shooter;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player == player && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        ItemStack gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> {
            IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)player);
            float aimingProgress = operator.getSynAimingProgress();
            if (aimingProgress <= 0.0f) {
                if (AnimationManager.isPlayerLie(player)) {
                    AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_normal_fire");
                } else {
                    AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "normal_fire_upper");
                }
            } else if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_aim_fire");
            } else {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "aim_fire_upper");
            }
        });
    }

    @SubscribeEvent
    public void onReload(GunReloadEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        LivingEntity shooter = event.getEntity();
        if (!(shooter instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)shooter;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player == player && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        ItemStack gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> {
            if (AnimationManager.isPlayerLie(player)) {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "lie_reload");
            } else {
                AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, "reload_upper");
            }
        });
    }

    @SubscribeEvent
    public void onMelee(GunMeleeEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        LivingEntity shooter = event.getShooter();
        if (!(shooter instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)shooter;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player == player && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        ItemStack gunItemStack = event.getGunItemStack();
        IGun iGun = IGun.getIGunOrNull(gunItemStack);
        if (iGun == null) {
            return;
        }
        int randomIndex = shooter.getRandom().nextInt(3);
        String animationName = switch (randomIndex) {
            case 0 -> "melee_upper";
            case 1 -> "melee_2_upper";
            default -> "melee_3_upper";
        };
        TimelessAPI.getGunDisplay(gunItemStack).ifPresent(index -> AnimationManager.playOnceAnimation(player, index, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, animationName));
    }

    @SubscribeEvent
    public void onDraw(GunDrawEvent event) {
        if (event.getLogicalSide().isServer()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player == player && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        ItemStack currentGunItem = event.getCurrentGunItem();
        ItemStack previousGunItem = event.getPreviousGunItem();
        if (currentGunItem.getItem() instanceof IGun && previousGunItem.getItem() instanceof IGun) {
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOOP_UPPER_ANIMATION, 8);
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.ONCE_UPPER_ANIMATION, 8);
            AnimationManager.stopAnimation(player, PlayerAnimatorCompat.LOWER_ANIMATION, 8);
        }
    }
}

