/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.config.client.RenderConfig;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TargetRenderer
implements BlockEntityRenderer<TargetBlockEntity> {
    private static final String UPPER_NAME = "target_upper";
    private static final String HEAD_NAME = "head";

    public TargetRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static Optional<BedrockModel> getModel() {
        return InternalAssetLoader.getBedrockModel(InternalAssetLoader.TARGET_MODEL_LOCATION);
    }

    public void render(TargetBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        TargetRenderer.getModel().ifPresent(model -> {
            BlockState blockState = blockEntity.getBlockState();
            Direction facing = (Direction)blockState.getValue((Property)TargetBlock.FACING);
            BedrockPart headModel = model.getNode(HEAD_NAME);
            BedrockPart upperModel = model.getNode(UPPER_NAME);
            float deg = -Mth.lerp((float)partialTick, (float)blockEntity.oRot, (float)blockEntity.rot);
            upperModel.xRot = (float)Math.toRadians(deg);
            headModel.visible = false;
            poseStack.pushPose();
            poseStack.translate(0.5, 0.225, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees((float)(facing.get2DDataValue() * 90)));
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            poseStack.translate(0.0, -1.275, 0.0125);
            RenderType renderType = RenderType.entityTranslucent((ResourceLocation)InternalAssetLoader.TARGET_TEXTURE_LOCATION);
            model.render(poseStack, ItemDisplayContext.NONE, renderType, combinedLightIn, combinedOverlayIn);
            if (blockEntity.getOwner() != null) {
                poseStack.translate(0.0, 1.25, 0.0);
                poseStack.mulPose(Axis.XP.rotationDegrees(deg));
                Minecraft minecraft = Minecraft.getInstance();
                ResourceLocation skin = minecraft.getSkinManager().getInsecureSkin(blockEntity.getOwner().gameProfile()).texture();
                headModel.visible = true;
                RenderType skullRenderType = RenderType.entityTranslucentCull((ResourceLocation)skin);
                headModel.render(poseStack, ItemDisplayContext.NONE, bufferIn.getBuffer(skullRenderType), combinedLightIn, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        });
    }

    public int getViewDistance() {
        return (Integer)RenderConfig.TARGET_RENDER_DISTANCE.get();
    }

    public boolean shouldRenderOffScreen(TargetBlockEntity blockEntity) {
        return true;
    }
}

