/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.client.model.BedrockAnimatedModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RightHandRender
implements IFunctionalRenderer {
    private final BedrockAnimatedModel bedrockGunModel;

    public RightHandRender(BedrockAnimatedModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        if (transformType.firstPerson()) {
            if (!this.bedrockGunModel.getRenderHand()) {
                return;
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            Matrix3f normal = new Matrix3f((Matrix3fc)poseStack.last().normal());
            Matrix4f pose = new Matrix4f((Matrix4fc)poseStack.last().pose());
            this.bedrockGunModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
                PoseStack poseStack2 = new PoseStack();
                poseStack2.last().normal().mul((Matrix3fc)normal);
                poseStack2.last().pose().mul((Matrix4fc)pose);
                RenderHelper.renderFirstPersonArm(Minecraft.getInstance().player, HumanoidArm.RIGHT, poseStack2, light1);
                Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            });
        }
    }
}

