/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerCancelReload;
import com.tacz.guns.network.message.ClientMessagePlayerReloadGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class LocalPlayerReload {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerReload(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void cancelReload() {
        ItemStack mainHandItem = this.player.getMainHandItem();
        if (!(mainHandItem.getItem() instanceof AbstractGunItem)) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)this.player);
            ReloadState reloadState = gunOperator.getSynReloadState();
            if (!reloadState.getStateType().isReloading()) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerCancelReload.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.cancelReload((GunDisplayInstance)display);
        });
    }

    public void reload() {
        ItemStack mainHandItem = this.player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (!(item instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)item;
        ResourceLocation gunId = gunItem.getGunId(mainHandItem);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
            if (gunItem.useInventoryAmmo(mainHandItem)) {
                return;
            }
            if (this.data.clientStateLock) {
                return;
            }
            boolean canReload = gunItem.canReload((LivingEntity)this.player, mainHandItem);
            if (IGunOperator.fromLivingEntity((LivingEntity)this.player).needCheckAmmo() && !canReload) {
                return;
            }
            this.data.lockState(operator -> operator.getSynReloadState().getStateType().isReloading());
            if (((GunReloadEvent)NeoForge.EVENT_BUS.post((Event)new GunReloadEvent((LivingEntity)this.player, this.player.getMainHandItem(), LogicalSide.CLIENT))).isCanceled()) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)ClientMessagePlayerReloadGun.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.doReload(gunItem, (GunDisplayInstance)display, gunData, mainHandItem);
        });
    }

    private void doReload(IGun iGun, GunDisplayInstance display, GunData gunData, ItemStack mainHandItem) {
        LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
        if (animationStateMachine != null) {
            Bolt boltType = gunData.getBolt();
            boolean noAmmo = boltType == Bolt.OPEN_BOLT ? iGun.getCurrentAmmoCount(mainHandItem) <= 0 : !iGun.hasBulletInBarrel(mainHandItem);
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playReloadSound((LivingEntity)this.player, display, noAmmo);
            animationStateMachine.trigger("reload");
        }
    }

    private void cancelReload(GunDisplayInstance display) {
        LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
        if (animationStateMachine != null) {
            animationStateMachine.trigger("cancel_reload");
        }
    }
}

