/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.io.serialization.snapshot;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.PartyInvite;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.io.serialization.data.SnapshotConverter;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.parties.party.io.serialization.snapshot.PartySnapshot;
import xaero.pac.common.server.parties.party.io.serialization.snapshot.member.PartyInviteSnapshot;
import xaero.pac.common.server.parties.party.io.serialization.snapshot.member.PartyInviteSnapshotConverter;
import xaero.pac.common.server.parties.party.io.serialization.snapshot.member.PartyMemberSnapshot;
import xaero.pac.common.server.parties.party.io.serialization.snapshot.member.PartyMemberSnapshotConverter;

public class PartySnapshotConverter
extends SnapshotConverter<PartySnapshot, String, ServerParty, PartyManager> {
    private final PartyMemberSnapshotConverter partyMemberSnapshotConverter;
    private final PartyInviteSnapshotConverter partyInviteSnapshotConverter;

    public PartySnapshotConverter(PartyMemberSnapshotConverter partyMemberSnapshotConverter, PartyInviteSnapshotConverter partyInviteSnapshotConverter) {
        this.partyMemberSnapshotConverter = partyMemberSnapshotConverter;
        this.partyInviteSnapshotConverter = partyInviteSnapshotConverter;
    }

    @Override
    public ServerParty convert(String id, PartyManager manager, PartySnapshot data) {
        PartyMember owner = this.partyMemberSnapshotConverter.convert(data.getOwner(), true);
        HashMap members = new HashMap(32);
        HashMap invites = new HashMap(32);
        HashMap allies = new HashMap();
        data.getMembers().forEach(mi -> {
            PartyMember member = this.partyMemberSnapshotConverter.convert((PartyMemberSnapshot)mi, false);
            members.put(member.getUUID(), member);
        });
        data.getInvitedPlayers().forEach(pi -> {
            PartyInvite invite = this.partyInviteSnapshotConverter.convert((PartyInviteSnapshot)pi);
            invites.put(invite.getUUID(), invite);
        });
        data.getAllyParties().forEach(a -> {
            UUID ally = UUID.fromString(a);
            allies.put(ally, new PartyAlly(ally));
        });
        ServerParty result = ((ServerParty.Builder)((ServerParty.Builder)((ServerParty.Builder)ServerParty.Builder.begin().setManagedBy(manager).setOwner(owner).setId(UUID.fromString(id)).setMemberInfo((Map)members)).setInvitedPlayers((Map)invites)).setAllyParties((Map)allies)).build();
        result.setRegisteredActivity(data.getRegisteredActivity());
        return result;
    }

    @Override
    public PartySnapshot convert(ServerParty party) {
        PartySnapshot result = new PartySnapshot(this.partyMemberSnapshotConverter.convert(party.getOwner()));
        result.setRegisteredActivity(party.getRegisteredActivity());
        party.getTypedInvitedPlayersStream().forEach(p -> result.addInvitedPlayer(this.partyInviteSnapshotConverter.convert((PartyInvite)p)));
        party.getTypedAllyPartiesStream().forEach(a -> result.addAllyParty(a.toString()));
        party.getTypedMemberInfoStream().filter(mi -> mi != party.getOwner()).forEach(mi -> result.addMember(this.partyMemberSnapshotConverter.convert((PartyPlayerInfo<?>)mi)));
        return result;
    }
}

