/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import fuzs.enchantinginfuser.world.item.enchantment.EnchantingBehavior;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.math.Fraction;

public class EnchantmentPowerHelper {
    public static Object2IntMap<Holder<Enchantment>> getAvailableEnchantmentLevels(int enchantmentPower, Collection<Holder<Enchantment>> itemEnchantments, int powerLimit, int enchantmentValue) {
        Object2IntOpenHashMap maximumEnchantmentLevels = new Object2IntOpenHashMap();
        for (Holder<Enchantment> enchantment : itemEnchantments) {
            int enchantmentLevel = EnchantmentPowerHelper.getAvailableEnchantmentLevel(enchantment, enchantmentPower, itemEnchantments, powerLimit, enchantmentValue);
            maximumEnchantmentLevels.put(enchantment, enchantmentLevel);
        }
        return Object2IntMaps.unmodifiable((Object2IntMap)maximumEnchantmentLevels);
    }

    public static int getAvailableEnchantmentLevel(Holder<Enchantment> enchantment, int enchantmentPower, Collection<Holder<Enchantment>> itemEnchantments, int powerLimit, int enchantmentValue) {
        for (int enchantmentLevel = EnchantingBehavior.get().getMaxLevel(enchantment); enchantmentLevel > 0; --enchantmentLevel) {
            int powerForLevel = EnchantmentPowerHelper.getScaledPowerForLevel(enchantment, enchantmentLevel, itemEnchantments, powerLimit, enchantmentValue);
            if (powerForLevel > enchantmentPower) continue;
            return enchantmentLevel;
        }
        return 0;
    }

    public static Object2IntMap<Holder<Enchantment>> getRequiredEnchantmentPowers(int enchantmentPower, Collection<Holder<Enchantment>> itemEnchantments, int powerLimit, int enchantmentValue) {
        Object2IntOpenHashMap requiredEnchantmentPowers = new Object2IntOpenHashMap();
        for (Holder<Enchantment> enchantment : itemEnchantments) {
            int enchantmentLevel = EnchantmentPowerHelper.getRequiredEnchantmentPower(enchantment, enchantmentPower, itemEnchantments, powerLimit, enchantmentValue);
            requiredEnchantmentPowers.put(enchantment, enchantmentLevel);
        }
        return Object2IntMaps.unmodifiable((Object2IntMap)requiredEnchantmentPowers);
    }

    public static int getRequiredEnchantmentPower(Holder<Enchantment> enchantment, int enchantmentPower, Collection<Holder<Enchantment>> itemEnchantments, int powerLimit, int enchantmentValue) {
        int requiredEnchantmentPower = 0;
        for (int enchantmentLevel = EnchantingBehavior.get().getMaxLevel(enchantment); enchantmentLevel >= 0; --enchantmentLevel) {
            int powerForLevel = EnchantmentPowerHelper.getScaledPowerForLevel(enchantment, enchantmentLevel, itemEnchantments, powerLimit, enchantmentValue);
            if (powerForLevel <= enchantmentPower) {
                return requiredEnchantmentPower;
            }
            requiredEnchantmentPower = powerForLevel;
        }
        return requiredEnchantmentPower;
    }

    public static int getScaledPowerForLevel(Holder<Enchantment> enchantment, int enchantmentLevel, Collection<Holder<Enchantment>> itemEnchantments, int powerLimit, int enchantmentValue) {
        Fraction relativePowerForLevel = EnchantmentPowerHelper.getRelativePowerForLevel(enchantment, enchantmentLevel, itemEnchantments);
        Fraction enchantmentValueBonus = Fraction.getFraction((int)enchantmentValue, (int)(60 * powerLimit));
        Fraction reducedPowerLimit = Fraction.getFraction((int)powerLimit, (int)1).subtract(enchantmentValueBonus);
        if (reducedPowerLimit.compareTo(Fraction.ZERO) < 0) {
            reducedPowerLimit = Fraction.ZERO;
        }
        int scaledPowerForLevel = Math.round(relativePowerForLevel.multiplyBy(reducedPowerLimit).floatValue());
        if (enchantment.is(EnchantmentTags.CURSE)) {
            scaledPowerForLevel *= 3;
        } else if (enchantment.is(EnchantmentTags.TREASURE)) {
            scaledPowerForLevel *= 2;
        }
        return Mth.clamp((int)scaledPowerForLevel, (int)0, (int)powerLimit);
    }

    private static Fraction getRelativePowerForLevel(Holder<Enchantment> enchantment, int enchantmentLevel, Collection<Holder<Enchantment>> itemEnchantments) {
        int minPower = EnchantmentPowerHelper.getMinPower(itemEnchantments);
        int maxPower = EnchantmentPowerHelper.getMaxPower(itemEnchantments);
        int powerForLevel = EnchantmentPowerHelper.getPowerForLevel(enchantment, enchantmentLevel);
        return Fraction.getFraction((int)(powerForLevel - minPower), (int)(maxPower - minPower));
    }

    private static int getMinPower(Collection<Holder<Enchantment>> itemEnchantments) {
        if (itemEnchantments.isEmpty()) {
            return 0;
        }
        int averageMinStrength = itemEnchantments.stream().mapToInt(holder -> EnchantmentPowerHelper.getPowerForLevel((Holder<Enchantment>)holder, ((Enchantment)holder.value()).getMinLevel())).sum() / itemEnchantments.size();
        int absoluteMinStrength = itemEnchantments.stream().mapToInt(holder -> EnchantmentPowerHelper.getPowerForLevel((Holder<Enchantment>)holder, ((Enchantment)holder.value()).getMinLevel())).min().orElse(0);
        return (averageMinStrength + absoluteMinStrength) / 2;
    }

    private static int getMaxPower(Collection<Holder<Enchantment>> itemEnchantments) {
        if (itemEnchantments.isEmpty()) {
            return 0;
        }
        int averageMaxStrength = itemEnchantments.stream().mapToInt(enchantment -> EnchantmentPowerHelper.getPowerForLevel((Holder<Enchantment>)enchantment, EnchantingBehavior.get().getMaxLevel((Holder<Enchantment>)enchantment))).sum() / itemEnchantments.size();
        int absoluteMaxStrength = itemEnchantments.stream().mapToInt(enchantment -> EnchantmentPowerHelper.getPowerForLevel((Holder<Enchantment>)enchantment, EnchantingBehavior.get().getMaxLevel((Holder<Enchantment>)enchantment))).max().orElse(0);
        return (averageMaxStrength + absoluteMaxStrength) / 2;
    }

    private static int getPowerForLevel(Holder<Enchantment> enchantment, int enchantmentLevel) {
        int minCost = EnchantingBehavior.get().getMinCost(enchantment, enchantmentLevel);
        int maxCost = EnchantingBehavior.get().getMaxCost(enchantment, enchantmentLevel);
        return minCost + (maxCost - minCost) * enchantmentLevel / (EnchantingBehavior.get().getMaxLevel(enchantment) + 1);
    }
}

