/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.client.gui.components.AbstractMenuSelectionList;
import fuzs.enchantinginfuser.client.gui.components.EnchantingOperationButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserEnchantButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserMenuButton;
import fuzs.enchantinginfuser.client.gui.components.InfuserRepairButton;
import fuzs.enchantinginfuser.client.gui.screens.inventory.EnchantmentComponent;
import fuzs.enchantinginfuser.network.client.ServerboundEnchantmentLevelMessage;
import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.components.tooltip.TooltipBuilder;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu>
implements ContainerListener {
    public static final ResourceLocation INFUSER_LOCATION = EnchantingInfuser.id("textures/gui/container/enchanting_infuser.png");
    private static final int BUTTONS_OFFSET_X = 7;
    private static final int ENCHANT_BUTTON_OFFSET_Y = 44;
    private static final int ENCHANT_ONLY_BUTTON_OFFSET_Y = 55;
    private static final int REPAIR_BUTTON_OFFSET_Y = 66;
    public final int enchantmentSeed = new Random().nextInt();
    private static boolean isPowerTooLow;
    private EditBox searchBox;
    private EnchantmentSelectionList scrollingList;
    private boolean ignoreTextInput;
    private AbstractWidget powerWidget;
    private InfuserMenuButton enchantButton;
    @Nullable
    private InfuserMenuButton repairButton;

    public InfuserScreen(InfuserMenu infuserMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)infuserMenu, inventory, title);
        this.imageWidth = 220;
        this.imageHeight = 185;
        this.inventoryLabelX = 30;
        this.inventoryLabelY = this.imageHeight - 94;
        ((InfuserMenu)this.menu).addSlotListener(this);
    }

    public static void setIsPowerTooLow(boolean isPowerTooLow) {
        InfuserScreen.isPowerTooLow = isPowerTooLow;
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 67, this.topPos + 6, 116, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(-1);
        this.addWidget((GuiEventListener)this.searchBox);
        this.scrollingList = new EnchantmentSelectionList(this.leftPos + 30, this.topPos + 18);
        this.addRenderableWidget((GuiEventListener)this.scrollingList);
        this.powerWidget = (AbstractWidget)this.addRenderableOnly((Renderable)new AbstractWidget(this.leftPos + 196, this.topPos + 161, 16, 16, CommonComponents.EMPTY){

            protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.pose().pushPose();
                guiGraphics.renderFakeItem(new ItemStack((ItemLike)Items.BOOKSHELF), this.getX(), this.getY());
                int posX = this.getX() + 19 - 2 - InfuserScreen.this.font.width((FormattedText)this.getMessage());
                int posY = this.getY() + 6 + 3;
                guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                guiGraphics.drawString(InfuserScreen.this.font, this.getMessage(), posX, posY, this.getStringColor().getColor().intValue());
                if (this.isHoveredOrFocused()) {
                    AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)this.getX(), (int)this.getY(), (int)0);
                }
                guiGraphics.pose().popPose();
            }

            private ChatFormatting getStringColor() {
                if (((InfuserMenu)InfuserScreen.this.menu).getEnchantmentPower() >= ((InfuserMenu)InfuserScreen.this.menu).getEnchantmentPowerLimit()) {
                    return ChatFormatting.YELLOW;
                }
                if (isPowerTooLow) {
                    return ChatFormatting.RED;
                }
                return ChatFormatting.WHITE;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return false;
            }

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            }
        });
        this.enchantButton = (InfuserMenuButton)this.addRenderableWidget((GuiEventListener)new InfuserEnchantButton(this.leftPos + 7, this.topPos + (((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? 44 : 55), button -> {
            if (((InfuserMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 0)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((InfuserMenu)this.menu).containerId, 0);
            }
            this.searchBox.setValue("");
        }));
        this.repairButton = ((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? (InfuserMenuButton)this.addRenderableWidget((GuiEventListener)new InfuserRepairButton(this.leftPos + 7, this.topPos + 66, button -> {
            if (((InfuserMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 1)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((InfuserMenu)this.menu).containerId, 1);
            }
        })) : null;
        this.refreshButton(0);
        this.refreshButton(1);
        this.refreshButton(2);
    }

    private void refreshButton(int dataSlot) {
        switch (dataSlot) {
            case 0: {
                this.refreshEnchantingPower(((InfuserMenu)this.menu).getEnchantmentPower());
                break;
            }
            case 1: {
                this.refreshButton(this.enchantButton, ((InfuserMenu)this.menu).getEnchantingCost(), ((InfuserMenu)this.menu).canEnchant((Player)this.minecraft.player));
                break;
            }
            case 2: {
                if (this.repairButton == null) break;
                this.refreshButton(this.repairButton, ((InfuserMenu)this.menu).getRepairCost(), ((InfuserMenu)this.menu).canRepair((Player)this.minecraft.player));
            }
        }
    }

    private void refreshButton(InfuserMenuButton button, int value, boolean mayApply) {
        button.refreshMessage(value, mayApply);
        button.refreshTooltip(((InfuserMenu)this.menu).getEnchantableStack(), ((InfuserMenu)this.menu).getItemEnchantments(), value, mayApply);
        button.active = mayApply;
    }

    private void refreshEnchantingPower(int enchantmentPower) {
        this.powerWidget.setMessage((Component)Component.literal((String)String.valueOf(enchantmentPower)));
        int enchantmentPowerLimit = ((InfuserMenu)this.menu).getEnchantmentPowerLimit();
        TooltipBuilder builder = TooltipBuilder.create().splitLines(200).addLines(new FormattedText[]{Component.translatable((String)"gui.enchantinginfuser.tooltip.current_enchanting_power", (Object[])new Object[]{enchantmentPower, enchantmentPowerLimit}).withStyle(ChatFormatting.YELLOW)});
        if (enchantmentPower < enchantmentPowerLimit) {
            builder.addLines(new FormattedText[]{Component.translatable((String)"gui.enchantinginfuser.tooltip.enchanting_power.hint").withStyle(ChatFormatting.GRAY)});
        }
        builder.build(this.powerWidget);
    }

    public void removed() {
        super.removed();
        ((InfuserMenu)this.menu).removeSlotListener(this);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.searchBox.getValue();
        super.resize(minecraft, width, height);
        this.searchBox.setValue(s);
        this.refreshSearchResults();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.charTyped(codePoint, modifiers)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        if (!this.searchBox.isFocused()) {
            if (this.minecraft.options.keyChat.matches(keyCode, scanCode)) {
                this.ignoreTextInput = true;
                this.searchBox.setFocused(true);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        boolean flag = this.hoveredSlot != null && this.hoveredSlot.hasItem();
        boolean flag1 = InputConstants.getKey((int)keyCode, (int)scanCode).getNumericKeyValue().isPresent();
        if (flag && flag1 && this.checkHotbarKeyPressed(keyCode, scanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.isFocused() && this.searchBox.isVisible() && keyCode != 256 || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void refreshSearchResults() {
        EnchantmentComponent enchantmentComponent;
        InfuserMenu.EnchantmentValues enchantmentValues;
        int size = this.scrollingList.children().size();
        this.scrollingList.clearEntries();
        ItemEnchantments itemEnchantments = ((InfuserMenu)this.menu).getItemEnchantments();
        Set<Holder<Enchantment>> enchantments = ((InfuserMenu)this.menu).getAllEnchantments();
        RegistryAccess.Frozen registries = this.minecraft.getConnection().registryAccess();
        HolderSet.Named holders = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.TOOLTIP_ORDER);
        for (Holder<Enchantment> enchantment : holders) {
            if (!enchantments.contains(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.menu).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        for (Holder<Enchantment> enchantment : enchantments) {
            if (holders.contains(enchantment) || !this.matchesSearch(enchantment)) continue;
            enchantmentValues = ((InfuserMenu)this.menu).getEnchantmentValues(enchantment);
            enchantmentComponent = EnchantmentComponent.create(enchantment, enchantmentValues, itemEnchantments);
            this.scrollingList.addEntry(enchantment, enchantmentComponent);
        }
        if (size != this.scrollingList.children().size()) {
            this.scrollingList.setScrollAmount(0.0);
        }
    }

    private boolean matchesSearch(Holder<Enchantment> enchantment) {
        String s = this.searchBox.getValue().toLowerCase(Locale.ROOT).trim();
        if (s.isEmpty()) {
            return true;
        }
        if (((InfuserMenu)this.menu).getAvailableEnchantmentLevel(enchantment) == 0) {
            return false;
        }
        return ((Enchantment)enchantment.value()).description().getString().toLowerCase(Locale.ROOT).contains(s);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        isPowerTooLow = false;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(INFUSER_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(INFUSER_LOCATION, this.leftPos + 8 - 1, this.topPos + (((InfuserMenu)this.menu).getConfig().allowRepairing.isActive() ? 23 : 34) - 1, 196, 185, 18, 18);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!ModLoaderEnvironment.INSTANCE.getModLoader().isFabricLike() && this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void slotChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, ItemStack itemStack) {
        if (dataSlotIndex == 0) {
            this.refreshButton(1);
            this.refreshButton(2);
        }
    }

    public void dataChanged(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
        this.refreshButton(dataSlotIndex);
    }

    private class EnchantmentSelectionList
    extends AbstractMenuSelectionList<Entry> {
        public EnchantmentSelectionList(int x, int y) {
            super(InfuserScreen.this.minecraft, x, y, 160, 70, 18, 8);
        }

        public void addEntry(Holder<Enchantment> enchantment, EnchantmentComponent enchantmentComponent) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(enchantment, enchantmentComponent));
        }

        public void clearEntries() {
            super.clearEntries();
        }

        class Entry
        extends ContainerObjectSelectionList.Entry<Entry> {
            private final EnchantmentComponent enchantmentComponent;
            private final Component component;
            private final List<FormattedCharSequence> tooltip;
            private final AbstractWidget removeButton;
            private final AbstractWidget addButton;

            public Entry(Holder<Enchantment> enchantment, EnchantmentComponent enchantmentComponent) {
                this.enchantmentComponent = enchantmentComponent;
                this.component = enchantmentComponent.getDisplayName(enchantment, EnchantmentSelectionList.this.getWidth() - 36, ((EnchantmentSelectionList)EnchantmentSelectionList.this).minecraft.font, InfuserScreen.this.enchantmentSeed);
                this.tooltip = ClientComponentSplitter.splitTooltipLines(enchantmentComponent.getTooltip(enchantment)).toList();
                this.removeButton = new EnchantingOperationButton.Remove(enchantmentComponent, EnchantmentSelectionList.this.getX(), EnchantmentSelectionList.this.getY(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.getMenu()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.remove())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                });
                this.addButton = new EnchantingOperationButton.Add(enchantmentComponent, EnchantmentSelectionList.this.getX() + EnchantmentSelectionList.this.getWidth() - 18, EnchantmentSelectionList.this.getY(), button -> {
                    if (((InfuserMenu)InfuserScreen.this.getMenu()).clickClientEnchantmentLevelButton(enchantment, enchantmentComponent.enchantmentLevel(), ServerboundEnchantmentLevelMessage.Operation.add())) {
                        InfuserScreen.this.refreshSearchResults();
                    }
                });
            }

            public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                guiGraphics.blit(INFUSER_LOCATION, left, top, 0, 185 + this.getYImage() * EnchantmentSelectionList.this.itemHeight, width, height);
                AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)((EnchantmentSelectionList)EnchantmentSelectionList.this).minecraft.font, (Component)this.component, (int)(left + 18 + 2), (int)top, (int)(left + width - 18 - 2), (int)(top + height), (int)this.getFontColor());
                for (AbstractWidget abstractWidget : this.children()) {
                    abstractWidget.setY(top);
                    abstractWidget.render(guiGraphics, mouseX, mouseY, partialTick);
                }
                if (hovering && (this.enchantmentComponent.isInactive() || mouseX >= left + 18 && mouseX < left + width - 18)) {
                    InfuserScreen.this.setTooltipForNextRenderPass(this.tooltip);
                    if (this.enchantmentComponent.isNotAvailable()) {
                        InfuserScreen.setIsPowerTooLow(true);
                    }
                }
            }

            private int getYImage() {
                return this.enchantmentComponent.isInactive() ? 0 : (this.enchantmentComponent.isPresent() ? 2 : 1);
            }

            private int getFontColor() {
                return this.enchantmentComponent.isInactive() ? 6839882 : (this.enchantmentComponent.isPresent() ? ChatFormatting.YELLOW.getColor() : -1);
            }

            public List<? extends AbstractWidget> children() {
                return List.of(this.removeButton, this.addButton);
            }

            public List<? extends NarratableEntry> narratables() {
                return List.of(this.removeButton, this.addButton);
            }
        }
    }
}

