/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.windupcooldown.windup;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.superricky.tpaplusplus.TPAPlusPlus;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindupWatcher {
    private static ScheduledExecutorService scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    private static final Set<WindupData> trackedWindupData = ConcurrentHashMap.newKeySet();
    private static final Logger WATCHDOG_LOGGER = LoggerFactory.getLogger((String)"tpaplusplus_WATCHDOG");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tpaplusplus");
    private static final String SWITCH_DISTANCE_FAILURE_ERROR_MESSAGE = "Switch statement could not find the respective windup distance!";
    private static final boolean USE_NON_BLOCKING_ASYNC_TICK_LOOP = (Boolean)Config.USE_NON_BLOCKING_ASYNC_TICK_LOOP.get();

    public static void clearTrackedWindupData() {
        trackedWindupData.clear();
    }

    public static Set<WindupData> getTrackedWindupData() {
        return trackedWindupData;
    }

    public static void watchWindupDataPosition() {
        WindupWatcher.runTick();
    }

    public static void startAsyncTickLoop(int rate) {
        scheduler.scheduleAtFixedRate(WindupWatcher::runTick, 1000 / rate, 1000 / rate, TimeUnit.MILLISECONDS);
    }

    private static void runTick() {
        for (WindupData windupData : trackedWindupData) {
            double windupDistance = WindupWatcher.getWindupDistance(windupData);
            if (windupDistance == -1.0 || windupData.getCancelled().get() || !(TPAPlusPlus.distance3D(windupData.getAcceptX(), windupData.getAcceptY(), windupData.getAcceptZ(), windupData.getPlayers()[0].getX(), windupData.getPlayers()[0].getY(), windupData.getPlayers()[0].getZ()) > windupDistance)) continue;
            windupData.getCancelled().set(true);
            windupData.getPlayers()[0].sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.PLAYER_MOVED_DURING_WINDUP.get(), Map.of("command_used", TPAPlusPlus.getCommandNameFromType(windupData.getType())))));
            trackedWindupData.remove(windupData);
        }
    }

    private static double getWindupDistance(WindupData windupData) {
        switch (windupData.getType()) {
            case BACK: {
                return (Double)Config.BACK_WINDUP_DISTANCE.get();
            }
            case ACCEPT: {
                return (Double)Config.ACCEPT_WINDUP_DISTANCE.get();
            }
            case DENY: {
                return (Double)Config.DENY_WINDUP_DISTANCE.get();
            }
            case CANCEL: {
                return (Double)Config.CANCEL_WINDUP_DISTANCE.get();
            }
            case TPA: {
                return (Double)Config.TPA_WINDUP_DISTANCE.get();
            }
            case TPAHERE: {
                return (Double)Config.TPAHERE_WINDUP_DISTANCE.get();
            }
            case BLOCK: {
                return (Double)Config.BLOCK_WINDUP_DISTANCE.get();
            }
            case TOGGLE: {
                return (Double)Config.TOGGLE_WINDUP_DISTANCE.get();
            }
            case UNBLOCK: {
                return (Double)Config.UNBLOCK_WINDUP_DISTANCE.get();
            }
        }
        LOGGER.error(SWITCH_DISTANCE_FAILURE_ERROR_MESSAGE);
        throw new IllegalStateException(SWITCH_DISTANCE_FAILURE_ERROR_MESSAGE);
    }

    public static boolean deInstantiateScheduledExecutorService() throws InterruptedException {
        if (USE_NON_BLOCKING_ASYNC_TICK_LOOP) {
            LOGGER.warn("A call to de-instantiate the ScheduledExecutorService for the non-blocking async tick loop, was called EVEN THOUGH the non-blocking tick loop is ENABLED!");
            LOGGER.warn("This call will be ignored, it is safe to continue playing but consider reporting this issue to TPA++");
            return true;
        }
        if (scheduler.isShutdown()) {
            throw new IllegalStateException("Attempted to shutdown the ScheduledExecutorService but it was already shutdown beforehand!");
        }
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public static boolean stopScheduledExecutorService() throws InterruptedException {
        if (USE_NON_BLOCKING_ASYNC_TICK_LOOP) {
            if (scheduler.isShutdown()) {
                throw new IllegalStateException("Attempted to shutdown the ScheduledExecutorService but it was already shutdown beforehand!");
            }
            WATCHDOG_LOGGER.warn("NON-BLOCKING TICK LOOP SHUTTING DOWN...");
            scheduler.shutdownNow();
            return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        return false;
    }

    public static void reCreateScheduledExecutorService() {
        if (USE_NON_BLOCKING_ASYNC_TICK_LOOP) {
            if (Boolean.FALSE.equals(scheduler.isShutdown())) {
                throw new IllegalStateException("Attempted to re-create ScheduledExecutorService but it was not shutdown beforehand!");
            }
            scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
            WATCHDOG_LOGGER.info("NON-BLOCKING TICK LOOP RESTARTING...");
            WindupWatcher.startAsyncTickLoop((Integer)Config.ASYNC_TICK_LOOP_UPDATE_RATE.get());
        }
    }

    public static boolean forceQuitScheduledExecutorService() throws InterruptedException {
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private WindupWatcher() {
    }
}

