/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.windupcooldown.windup;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;

public class AsyncWindupHelper {
    static boolean playersAreNull(ServerPlayer ... players) {
        if (Objects.isNull(players)) {
            return true;
        }
        for (ServerPlayer player : players) {
            if (!Objects.isNull(player)) continue;
            return true;
        }
        return false;
    }

    static void fastMSG(String message, ServerPlayer ... players) {
        for (ServerPlayer player : players) {
            player.sendSystemMessage((Component)Component.literal((String)message));
        }
    }

    static void getErrorMessage(WindupData windupData) {
        switch (windupData.getType()) {
            case BACK: {
                if (!Objects.isNull((Object)windupData.getDeathPosition())) break;
                throw new IllegalArgumentException("A TPA++ BACK task was scheduled, although there was no LevelBoundVec3 to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case ACCEPT: {
                if (!Objects.isNull(windupData.getRequest())) break;
                throw new IllegalArgumentException("A TPA++ ACCEPT task was scheduled, although there was no Request to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case CANCEL: {
                if (!Objects.isNull(windupData.getRequest())) break;
                throw new IllegalArgumentException("A TPA++ CANCEL task was scheduled, although there was no Request to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case TPA: {
                if (!Objects.isNull(windupData.getHereRequest())) break;
                throw new IllegalArgumentException("A TPA++ TPA task was scheduled, although there was no boolean \"isHereRequest\" to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case TPAHERE: {
                if (!Objects.isNull(windupData.getHereRequest())) break;
                throw new IllegalArgumentException("A TPA++ TPAHERE task was scheduled, although there was no boolean \"isHereRequest\" to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case BLOCK: {
                if (!Objects.isNull(windupData.getPlayerData())) break;
                throw new IllegalArgumentException("A TPA++ BLOCK task was scheduled, although there was no PlayerData to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
            case UNBLOCK: {
                if (!Objects.isNull(windupData.getPlayerData())) break;
                throw new IllegalArgumentException("A TPA++ UNBLOCK task was scheduled, although there was no PlayerData to accompany it?? Please report this issue to the TPA++ issue page immediately.");
            }
        }
    }

    public static long getMillisInt64FromDouble(double number) {
        return (long)(number * 1000.0);
    }

    private AsyncWindupHelper() {
    }
}

