/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.windupcooldown.windup;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.superricky.tpaplusplus.TPAPlusPlus;
import net.superricky.tpaplusplus.commands.accept.AcceptTPA;
import net.superricky.tpaplusplus.commands.back.Back;
import net.superricky.tpaplusplus.commands.block.BlockPlayer;
import net.superricky.tpaplusplus.commands.cancel.CancelTPA;
import net.superricky.tpaplusplus.commands.deny.DenyTPA;
import net.superricky.tpaplusplus.commands.send.SendTPA;
import net.superricky.tpaplusplus.commands.toggle.TPToggle;
import net.superricky.tpaplusplus.commands.unblock.UnBlockPlayer;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindupHelper;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWindup {
    private static ScheduledExecutorService scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tpaplusplus");

    public static void schedule(WindupData windupData) {
        if (Objects.isNull(scheduler)) {
            LOGGER.error("IllegalStateException: Scheduler is null!");
            throw new IllegalStateException("Scheduler is null!");
        }
        if (AsyncWindupHelper.playersAreNull(windupData.getPlayers())) {
            LOGGER.error("IllegalArgumentException: The playerlist or one of the players inside is null! Please report this issue to the TPA++ issue page immediately.");
            throw new IllegalArgumentException("The playerlist or one of the players inside is null! Please report this issue to the TPA++ issue page immediately.");
        }
        if (windupData.getPlayers().length == 0) {
            LOGGER.error("IllegalArgumentException: The playerlist or one of the players inside is null! Please report this issue to the TPA++ issue page immediately.");
            AsyncWindupHelper.fastMSG("No players were specified when attempting to schedule this task! Please report this issue to the TPA++ issue page immediately.", windupData.getPlayers());
            throw new IllegalArgumentException("No players were specified when attempting to schedule this task! Please report this issue to the TPA++ issue page immediately.");
        }
        try {
            AsyncWindupHelper.getErrorMessage(windupData);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage());
            windupData.getPlayers()[0].sendSystemMessage((Component)Component.literal((String)"\u00a74A fatal internal server error occurred, please check console for more information."));
            return;
        }
        if (windupData.getCancelled().get()) {
            throw new IllegalArgumentException("Tried to schedule a windupData that has already been cancelled.");
        }
        if (Objects.isNull(scheduler)) {
            LOGGER.error("IllegalStateException: Scheduler is null!");
            throw new IllegalStateException("Scheduler is null!");
        }
        WindupWatcher.getTrackedWindupData().add(windupData);
        if (TPAPlusPlus.getDecimalNumber(windupData.getOriginalDelay()) > (Double)Config.WINDUP_DECIMAL_MESSAGE_THRESHOLD.get()) {
            AsyncWindupHelper.fastMSG(MessageParser.enhancedFormatter((String)Messages.WINDUP_TIME_REMAINING.get(), Map.of("time", Double.toString((double)Math.round(windupData.getOriginalDelay() * 1000.0) / 1000.0))), windupData.getPlayers());
        }
        scheduler.schedule(() -> AsyncWindup.countdown(windupData), AsyncWindupHelper.getMillisInt64FromDouble(TPAPlusPlus.getDecimalNumber(windupData.getOriginalDelay())), TimeUnit.MILLISECONDS);
    }

    private static void countdown(WindupData windupData) {
        if (windupData.getDelay() > 0) {
            if (Objects.isNull(scheduler)) {
                LOGGER.error("IllegalStateException: Scheduler is null!");
                throw new IllegalStateException("Scheduler is null!");
            }
            if (windupData.getCancelled().get()) {
                WindupWatcher.getTrackedWindupData().remove(windupData);
                return;
            }
            AsyncWindupHelper.fastMSG(MessageParser.enhancedFormatter((String)Messages.WINDUP_TIME_REMAINING.get(), Map.of("time", Integer.toString(windupData.getDelay()))), windupData.getPlayers());
            windupData.setDelay(windupData.getDelay() - 1);
            scheduler.schedule(() -> AsyncWindup.countdown(windupData), 1L, TimeUnit.SECONDS);
            return;
        }
        if (windupData.getCancelled().get()) {
            WindupWatcher.getTrackedWindupData().remove(windupData);
            return;
        }
        try {
            switch (windupData.getType()) {
                case BACK: {
                    Back.absoluteTeleportToLatestDeath(windupData.getPlayers()[0], windupData.getDeathPosition());
                    break;
                }
                case ACCEPT: {
                    AcceptTPA.absoluteAcceptFunctionality(Objects.requireNonNull(windupData.getRequest()), windupData.getPlayers()[1]);
                    break;
                }
                case DENY: {
                    DenyTPA.absoluteDeny(Objects.requireNonNull(windupData.getRequest()));
                    break;
                }
                case CANCEL: {
                    CancelTPA.absoluteCancel(Objects.requireNonNull(windupData.getRequest()));
                    break;
                }
                case TPA: 
                case TPAHERE: {
                    SendTPA.absoluteSendTeleportRequest(windupData.getPlayers()[0], windupData.getPlayers()[1], Objects.requireNonNull(windupData.getHereRequest()));
                    break;
                }
                case BLOCK: {
                    BlockPlayer.absoluteBlockPlayer(Objects.requireNonNull(windupData.getPlayerData()), windupData.getPlayers()[0], windupData.getPlayers()[1]);
                    break;
                }
                case TOGGLE: {
                    TPToggle.toggleTP(windupData.getPlayers()[0]);
                    break;
                }
                case UNBLOCK: {
                    UnBlockPlayer.absoluteUnBlockPlayer(Objects.requireNonNull(windupData.getPlayerData()), windupData.getPlayers()[0], windupData.getPlayers()[1]);
                }
            }
        }
        catch (NullPointerException e) {
            LOGGER.error(e.getMessage());
            LOGGER.warn("A NullPointerException was caught by TPA++. This is an extremely rare case, and if this does not happen again you should be able to continue playing.");
            LOGGER.warn("Although, please report this issue to TPA++ at \"https://github.com/SuperRicky14/TpaPlusPlus/issues\".");
            LOGGER.warn("If you notice any unexpected behaviour shutdown your server immediately and create a backup of your world before turning it back on.");
        }
        WindupWatcher.getTrackedWindupData().remove(windupData);
    }

    public static boolean stopScheduledExecutorService() throws InterruptedException {
        if (scheduler.isShutdown()) {
            throw new IllegalStateException("Attempted to shutdown the ScheduledExecutorService but it was already shutdown beforehand!");
        }
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public static boolean forceQuitScheduledExecutorService() throws InterruptedException {
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public static void reCreateScheduledExecutorService() {
        if (Boolean.FALSE.equals(scheduler.isShutdown())) {
            throw new IllegalStateException("Attempted to re-create ScheduledExecutorService but it was not shutdown beforehand!");
        }
        scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    private AsyncWindup() {
    }
}

