/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.windupcooldown.cooldown;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.TPAPlusPlus;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.CooldownData;
import org.jetbrains.annotations.Nullable;

public class AsyncCooldownHelper {
    private static final Set<CooldownData> cooldownSet = ConcurrentHashMap.newKeySet();

    static Set<CooldownData> getCooldownSet() {
        return cooldownSet;
    }

    public static boolean checkCommandCooldownAndNotify(ServerPlayer currentPlayer, UUID playerUUID, CommandType type) {
        @Nullable CooldownData commandCooldown = AsyncCooldownHelper.getCommandCooldown(playerUUID, type);
        if (Objects.isNull(commandCooldown)) {
            return false;
        }
        int commandCooldownDelay = commandCooldown.getCooldownDelay();
        if (commandCooldownDelay > 0) {
            currentPlayer.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.COMMAND_ON_COOLDOWN_MESSAGE.get(), Map.of("command_used", TPAPlusPlus.getCommandNameFromType(type), "time_remaining", String.valueOf(commandCooldownDelay)))));
            return true;
        }
        return false;
    }

    @Nullable
    public static CooldownData getCommandCooldown(UUID playerUUID, CommandType type) {
        for (CooldownData cooldown : cooldownSet) {
            if (!cooldown.getPlayerCooldownUUID().equals(playerUUID) || !cooldown.getCommandOnCooldown().equals((Object)type)) continue;
            return cooldown;
        }
        return null;
    }
}

