/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.timeout;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.requests.Request;
import net.superricky.tpaplusplus.timeout.RequestTimeoutEvent;

public class TimeoutScheduler {
    private static ScheduledExecutorService scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));

    public static void scheduleTeleportTimeout(Request request) {
        scheduler.schedule(() -> ((RequestTimeoutEvent)RequestTimeoutEvent.EVENT.invoker()).onRequestTimeout(request), (long)((Integer)Config.TPA_TIMEOUT_IN_SECONDS.get()).intValue(), TimeUnit.SECONDS);
    }

    public static boolean stopScheduledExecutorService() throws InterruptedException {
        if (Objects.isNull(scheduler) || scheduler.isShutdown()) {
            throw new IllegalStateException("Attempted to shutdown the ScheduledExecutorService but it was already shutdown beforehand!");
        }
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public static void reCreateScheduledExecutorService() {
        if (Boolean.FALSE.equals(scheduler.isShutdown())) {
            throw new IllegalStateException("Attempted to re-create ScheduledExecutorService but it was not shutdown beforehand!");
        }
        scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    public static boolean forceQuitScheduledExecutorService() throws InterruptedException {
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private TimeoutScheduler() {
    }
}

