/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.player;

import dev.architectury.event.EventResult;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003\u001a\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"playerRegistry", "", "Ljava/util/UUID;", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayerByUUID", "playerUUID", "onPlayerJoin", "Ldev/architectury/event/EventResult;", "joinedPlayer", "onPlayerQuit", "playerQuit", "superricky"})
public final class PlayerRegistryManagerKt {
    @NotNull
    private static final Map<UUID, ServerPlayer> playerRegistry = new ConcurrentHashMap();

    @NotNull
    public static final EventResult onPlayerJoin(@NotNull ServerPlayer joinedPlayer) {
        Intrinsics.checkNotNullParameter((Object)joinedPlayer, (String)"joinedPlayer");
        Map<UUID, ServerPlayer> map = playerRegistry;
        UUID uUID = joinedPlayer.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        map.put(uUID, joinedPlayer);
        EventResult eventResult = EventResult.pass();
        Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
        return eventResult;
    }

    @NotNull
    public static final EventResult onPlayerQuit(@NotNull ServerPlayer playerQuit) {
        Intrinsics.checkNotNullParameter((Object)playerQuit, (String)"playerQuit");
        playerRegistry.remove(playerQuit.getUUID());
        EventResult eventResult = EventResult.pass();
        Intrinsics.checkNotNullExpressionValue((Object)eventResult, (String)"pass(...)");
        return eventResult;
    }

    @Nullable
    public static final ServerPlayer getPlayerByUUID(@NotNull UUID playerUUID) {
        Intrinsics.checkNotNullParameter((Object)playerUUID, (String)"playerUUID");
        return playerRegistry.get(playerUUID);
    }
}

