/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.limitations;

import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.TPAPlusPlus;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.limitations.Limitation;
import net.superricky.tpaplusplus.limitations.LimitationType;
import org.jetbrains.annotations.Nullable;

public class LimitationManager {
    private static final String DISTANCE_IDENTIFIER = "distance";
    private static final String EXPECTED_DISTANCE_IDENTIFIER = "expectedDistance";
    private static final String OTHER_PLAYER_NAME_IDENTIFIER = "otherPlayerName";
    private static final String EXECUTOR_DIMENSION_IDENTIFIER = "executorDimension";
    private static final String OTHER_PLAYER_DIMENSION_IDENTIFIER = "otherPlayerDimension";

    private LimitationManager() {
    }

    @Nullable
    public static Limitation getLimitationType(ServerPlayer sender, ServerPlayer receiver) {
        if (Boolean.FALSE.equals(sender.serverLevel().dimension().location().getPath().equals(receiver.serverLevel().dimension().location().getPath()))) {
            if (Boolean.FALSE.equals(Config.ALLOW_INTER_DIMENSIONAL_TELEPORT.get())) {
                return new Limitation(LimitationType.DIFFERENT_DIMENSIONS, sender.serverLevel(), receiver.serverLevel());
            }
            if (Boolean.TRUE.equals(Config.DISABLE_RANGE_CHECKS_INTER_DIMENSIONAL.get()) && sender.serverLevel().method_44013().equals(receiver.serverLevel().method_44013())) {
                return null;
            }
        }
        double senderX = sender.getX();
        double senderY = sender.getY();
        double senderZ = sender.getZ();
        double receiverX = receiver.getX();
        double receiverY = receiver.getY();
        double receiverZ = receiver.getZ();
        double distanceBetweenPlayers = TPAPlusPlus.distance3D(senderX, senderY, senderZ, receiverX, receiverY, receiverZ);
        if ((Double)Config.FURTHEST_ALLOWED_DISTANCE.get() != 0.0 && distanceBetweenPlayers > (Double)Config.FURTHEST_ALLOWED_DISTANCE.get()) {
            return new Limitation(LimitationType.TOO_FAR, distanceBetweenPlayers);
        }
        if ((Double)Config.CLOSEST_ALLOWED_DISTANCE.get() != 0.0 && distanceBetweenPlayers < (Double)Config.CLOSEST_ALLOWED_DISTANCE.get()) {
            return new Limitation(LimitationType.TOO_CLOSE, distanceBetweenPlayers);
        }
        return null;
    }

    public static boolean notifyAndCheckAllowedToTeleport(ServerPlayer executor, ServerPlayer otherPlayer, boolean notifyBothPlayers) {
        Limitation limitation = LimitationManager.getLimitationType(executor, otherPlayer);
        if (Objects.isNull(limitation)) {
            return true;
        }
        switch (limitation.type()) {
            case TOO_FAR: {
                executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_TOO_FAR_EXECUTOR.get(), Map.of(DISTANCE_IDENTIFIER, Math.round(limitation.distance()), EXPECTED_DISTANCE_IDENTIFIER, Math.round((Double)Config.FURTHEST_ALLOWED_DISTANCE.get())))));
                if (notifyBothPlayers) {
                    executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_TOO_FAR_OTHER_PLAYER.get(), Map.of(DISTANCE_IDENTIFIER, Math.round(limitation.distance()), EXPECTED_DISTANCE_IDENTIFIER, Math.round((Double)Config.CLOSEST_ALLOWED_DISTANCE.get()), OTHER_PLAYER_NAME_IDENTIFIER, executor.getName().getString()))));
                }
                return false;
            }
            case TOO_CLOSE: {
                executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_TOO_CLOSE_EXECUTOR.get(), Map.of(DISTANCE_IDENTIFIER, Math.round(limitation.distance()), EXPECTED_DISTANCE_IDENTIFIER, Math.round((Double)Config.CLOSEST_ALLOWED_DISTANCE.get())))));
                if (notifyBothPlayers) {
                    otherPlayer.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_TOO_CLOSE_OTHER_PLAYER.get(), Map.of(DISTANCE_IDENTIFIER, Math.round(limitation.distance()), EXPECTED_DISTANCE_IDENTIFIER, Math.round((Double)Config.CLOSEST_ALLOWED_DISTANCE.get()), OTHER_PLAYER_NAME_IDENTIFIER, executor.getName().getString()))));
                }
                return false;
            }
            case DIFFERENT_DIMENSIONS: {
                executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_DIFFERENT_DIMENSIONS_EXECUTOR.get(), Map.of(EXECUTOR_DIMENSION_IDENTIFIER, limitation.executorLevel().dimension().location().getPath(), OTHER_PLAYER_DIMENSION_IDENTIFIER, limitation.otherPlayerLevel().dimension().location().getPath()))));
                if (notifyBothPlayers) {
                    otherPlayer.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_DIFFERENT_DIMENSIONS_OTHER_PLAYER.get(), Map.of(EXECUTOR_DIMENSION_IDENTIFIER, limitation.otherPlayerLevel().dimension().location().getPath(), OTHER_PLAYER_DIMENSION_IDENTIFIER, limitation.executorLevel().dimension().location().getPath(), OTHER_PLAYER_NAME_IDENTIFIER, executor.getName().getString()))));
                }
                return false;
            }
        }
        return false;
    }
}

