/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.io.PlayerData;
import org.slf4j.Logger;

public class SaveDataManager {
    private static final String MOD_SAVEDATA_FOLDER_PATH = "mods" + File.separator + ".tpaplusplus" + File.separator;
    private static final String MOD_SAVEDATA_FILE_PATH = MOD_SAVEDATA_FOLDER_PATH + File.separator + "tpaplusplus_savedata.json";
    private static final File MOD_SAVEDATA_FOLDER = new File(MOD_SAVEDATA_FOLDER_PATH);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Map<UUID, PlayerData> playerDataMap = Collections.synchronizedMap(new HashMap());

    public static PlayerData getPlayerData(ServerPlayer player) {
        for (Map.Entry<UUID, PlayerData> entry : playerDataMap.entrySet()) {
            if (!entry.getKey().equals(player.getUUID())) continue;
            return entry.getValue();
        }
        PlayerData newPlayerData = new PlayerData();
        playerDataMap.put(player.getUUID(), newPlayerData);
        return newPlayerData;
    }

    public static void savePlayerData() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (Boolean.FALSE.equals(SaveDataManager.checkForSaveDataExistence())) {
            return;
        }
        try (FileWriter writer = new FileWriter(MOD_SAVEDATA_FILE_PATH);){
            gson.toJson(playerDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("An IOException occurred when trying to save playerData.");
            LOGGER.error(e.getMessage());
        }
    }

    public static void loadPlayerData() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (Boolean.FALSE.equals(SaveDataManager.checkForSaveDataExistenceForLoading())) {
            return;
        }
        try (FileReader reader = new FileReader(MOD_SAVEDATA_FILE_PATH);){
            playerDataMap = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<UUID, PlayerData>>(){}.getType());
            LOGGER.info("Successfully loaded player data!");
        }
        catch (IOException e) {
            LOGGER.error("An IOException occurred when trying to load playerData.");
            LOGGER.error(e.getMessage());
        }
    }

    static boolean checkForSaveDataExistenceForLoading() {
        return MOD_SAVEDATA_FOLDER.exists();
    }

    static boolean checkForSaveDataExistence() {
        if (!MOD_SAVEDATA_FOLDER.exists()) {
            boolean success = MOD_SAVEDATA_FOLDER.mkdirs();
            if (!success) {
                String errorMsg = String.format("Failed to automatically create TPAPlusPlus's savedata folder, consider creating %s manually!", MOD_SAVEDATA_FILE_PATH);
                LOGGER.error(errorMsg);
            }
            return success;
        }
        return true;
    }

    private SaveDataManager() {
    }
}

