/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.io;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.io.SaveDataManager;

public class AutosaveScheduler {
    private static ScheduledExecutorService scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));

    public static void initialiseAutoSaveService() {
        scheduler.schedule(AutosaveScheduler::autoSave, (long)((Integer)Config.AUTOSAVE_INTERVAL.get()).intValue(), TimeUnit.SECONDS);
    }

    private static void autoSave() {
        SaveDataManager.savePlayerData();
        scheduler.schedule(AutosaveScheduler::autoSave, (long)((Integer)Config.AUTOSAVE_INTERVAL.get()).intValue(), TimeUnit.SECONDS);
    }

    public static boolean stopScheduledExecutorService() throws InterruptedException {
        if (scheduler.isShutdown()) {
            throw new IllegalStateException("Attempted to shutdown the ScheduledExecutorService but it was already shutdown beforehand!");
        }
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    public static void reCreateScheduledExecutorService() {
        if (Boolean.FALSE.equals(scheduler.isShutdown())) {
            throw new IllegalStateException("Attempted to re-create ScheduledExecutorService but it was not shutdown beforehand!");
        }
        scheduler = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
        AutosaveScheduler.initialiseAutoSaveService();
    }

    public static boolean forceQuitScheduledExecutorService() throws InterruptedException {
        scheduler.shutdownNow();
        return scheduler.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private AutosaveScheduler() {
    }
}

