/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.unblock;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.io.PlayerData;
import net.superricky.tpaplusplus.io.SaveDataManager;
import net.superricky.tpaplusplus.requests.RequestHelper;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;

public class UnBlockPlayer {
    public static void unBlockPlayer(ServerPlayer executor, ServerPlayer blockedPlayer) {
        if (RequestHelper.isPlayerIdentical(executor, blockedPlayer)) {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.CANNOT_UNBLOCK_SELF.get())));
            return;
        }
        PlayerData executorData = SaveDataManager.getPlayerData(executor);
        if (Boolean.FALSE.equals(executorData.getBlockedPlayers().contains(blockedPlayer.getUUID()))) {
            executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.HAVENT_BLOCKED_PLAYER.get(), Map.of("blocked_player", blockedPlayer.getName().getString()))));
            return;
        }
        if (AsyncCooldownHelper.checkCommandCooldownAndNotify(executor, executor.getUUID(), CommandType.UNBLOCK)) {
            return;
        }
        if ((Integer)Config.UNBLOCK_COOLDOWN.get() > 0) {
            AsyncCooldownKt.scheduleCooldown(executor.getUUID(), (Integer)Config.UNBLOCK_COOLDOWN.get(), CommandType.UNBLOCK);
        }
        if ((Double)Config.UNBLOCK_WINDUP.get() == 0.0) {
            UnBlockPlayer.absoluteUnBlockPlayer(executorData, executor, blockedPlayer);
        } else {
            AsyncWindup.schedule(new WindupData(executorData, (double)((Double)Config.UNBLOCK_WINDUP.get()), executor.getX(), executor.getY(), executor.getZ(), CommandType.UNBLOCK, new ServerPlayer[]{executor, blockedPlayer}));
        }
    }

    public static void absoluteUnBlockPlayer(PlayerData executorData, ServerPlayer executor, ServerPlayer blockedPlayer) {
        executorData.getBlockedPlayers().remove(blockedPlayer.getUUID());
        executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.SENDER_UNBLOCKED_PLAYER.get(), Map.of("unblocked_player", blockedPlayer.getName().getString()))));
        if (Boolean.TRUE.equals(Config.SEND_BLOCKED_MESSAGES_TO_BOTH_PLAYERS.get())) {
            blockedPlayer.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.PLAYER_UNBLOCKED_BY_SENDER.get(), Map.of("sender_name", executor.getName().getString()))));
        }
    }

    private UnBlockPlayer() {
    }
}

