/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.tpaplusplus;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.superricky.tpaplusplus.commands.back.DeathHelper;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageReformatter;
import net.superricky.tpaplusplus.io.AutosaveScheduler;
import net.superricky.tpaplusplus.requests.RequestHelper;
import net.superricky.tpaplusplus.timeout.TimeoutScheduler;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPAPlusPlusCommand {
    private static final String FORCE_PARAMETER = "-force";
    private static final String SCHEDULED_EXECUTOR_SERVICE_EXCEPTION_MESSAGE = "\u00a74Failed to reload: An internal server error occurred, please check console for more information.";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tpaplusplus");

    public static void onRegisterCommandEvent(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaplusplus").executes(context -> TPAPlusPlusCommand.version((CommandSourceStack)context.getSource()))).then(((LiteralArgumentBuilder)Commands.literal((String)"refactor").requires(context -> context.hasPermission(4))).then(Commands.literal((String)"messages").then(Commands.literal((String)"color-set").then(Commands.argument((String)"old-primary-color", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"old-secondary-color", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"old-error-color", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"new-primary-color", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"new-secondary-color", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"new-error-color", (ArgumentType)StringArgumentType.string()).executes(context -> TPAPlusPlusCommand.refactorColorSet((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"old-primary-color"), StringArgumentType.getString((CommandContext)context, (String)"old-secondary-color"), StringArgumentType.getString((CommandContext)context, (String)"old-error-color"), StringArgumentType.getString((CommandContext)context, (String)"new-primary-color"), StringArgumentType.getString((CommandContext)context, (String)"new-secondary-color"), StringArgumentType.getString((CommandContext)context, (String)"new-error-color"))))))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"version").requires(context -> context.hasPermission(4))).executes(context -> TPAPlusPlusCommand.version((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(context -> context.hasPermission(4))).executes(context -> TPAPlusPlusCommand.reloadConfig((CommandSourceStack)context.getSource(), false))).then(Commands.literal((String)FORCE_PARAMETER).executes(context -> TPAPlusPlusCommand.reloadConfig((CommandSourceStack)context.getSource(), true)))).then(((LiteralArgumentBuilder)Commands.literal((String)"config").executes(context -> TPAPlusPlusCommand.reloadConfig((CommandSourceStack)context.getSource(), false))).then(Commands.literal((String)FORCE_PARAMETER).executes(context -> TPAPlusPlusCommand.reloadConfig((CommandSourceStack)context.getSource(), true)))))).then(Commands.literal((String)"license").executes(context -> TPAPlusPlusCommand.printLicense((CommandSourceStack)context.getSource()))));
    }

    private TPAPlusPlusCommand() {
    }

    private static int printLicense(CommandSourceStack source) {
        source.sendSystemMessage((Component)Component.literal((String)"\u00a76TPA++ License & Credits: \u00a7chttps://github.com/SuperRicky14/TpaPlusPlus/blob/master/LICENSE"));
        return 1;
    }

    private static int refactorColorSet(CommandSourceStack source, String ... colorList) {
        if (colorList.length != 6) {
            source.sendFailure((Component)Component.literal((String)String.format((String)Messages.ERR_TPAPLUSPLUS_COLORS_REQUIRE_SIX_COLORS.get(), colorList.length)));
            return 0;
        }
        for (String color : colorList) {
            if (MessageReformatter.isValidColor(color)) continue;
            source.sendFailure((Component)Component.literal((String)String.format((String)Messages.ERR_TPAPLUSPLUS_COLORS_INVALID_COLORS.get(), color)));
            source.sendFailure((Component)Component.literal((String)String.format((String)Messages.ERR_TPAPLUSPLUS_COLORS_INVALID_COLORS_EXAMPLES.get(), MessageReformatter.getRandomColorCode())));
            return 0;
        }
        String oldMainColor = colorList[0].replace("&", "\u00a7").toLowerCase();
        String oldSecondaryColor = colorList[1].replace("&", "\u00a7").toLowerCase();
        String oldErrorColor = colorList[2].replace("&", "\u00a7").toLowerCase();
        String newMainColor = colorList[3].replace("&", "\u00a7").toLowerCase();
        String newSecondaryColor = colorList[4].replace("&", "\u00a7").toLowerCase();
        String newErrorColor = colorList[5].replace("&", "\u00a7").toLowerCase();
        if (oldMainColor.equals(oldSecondaryColor) || newMainColor.equals(newSecondaryColor)) {
            source.sendFailure((Component)Component.literal((String)((String)Messages.ERR_TPAPLUSPLUS_COLORS_CANNOT_BE_THE_SAME.get())));
            return 0;
        }
        MessageReformatter.updateColorsAndSave(MessageReformatter.loadRawConfig(), oldMainColor, newMainColor, oldSecondaryColor, newSecondaryColor, oldErrorColor, newErrorColor);
        source.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPAPLUSPLUS_COLORS_SUCCESS.get())));
        return 1;
    }

    private static int version(CommandSourceStack source) {
        source.sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.TPAPLUSPLUS_VERSION.get(), "1.6.0-1.20.x-RELEASE-CANDIDATE-1")));
        return 1;
    }

    private static void logAndWarnTerminatedScheduledExecutorService(CommandSourceStack source, boolean executorServiceResult) {
        if (Boolean.FALSE.equals(executorServiceResult)) {
            source.sendSystemMessage((Component)Component.literal((String)"\u00a7eWARNING\u00a76: \u00a7fScheduledExecutorService refused shutdown request, so it was terminated!"));
            LOGGER.warn("ScheduledExecutorService timed out, so it was terminated!");
        }
    }

    private static int reloadConfig(CommandSourceStack source, boolean force) {
        try {
            TPAPlusPlusCommand.logAndWarnTerminatedScheduledExecutorService(source, AsyncWindup.stopScheduledExecutorService());
            TPAPlusPlusCommand.logAndWarnTerminatedScheduledExecutorService(source, AutosaveScheduler.stopScheduledExecutorService());
            TPAPlusPlusCommand.logAndWarnTerminatedScheduledExecutorService(source, TimeoutScheduler.stopScheduledExecutorService());
            TPAPlusPlusCommand.logAndWarnTerminatedScheduledExecutorService(source, WindupWatcher.stopScheduledExecutorService());
        }
        catch (IllegalStateException | InterruptedException e) {
            LOGGER.error(e.getMessage());
            source.sendFailure((Component)Component.literal((String)SCHEDULED_EXECUTOR_SERVICE_EXCEPTION_MESSAGE));
            return 0;
        }
        if (force) {
            source.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPAPLUSPLUS_FORCE_RELOADING_CONFIG.get())));
            Config.SPEC.afterReload();
            RequestHelper.clearRequestSet();
            DeathHelper.clearDeathCoordinates();
            WindupWatcher.clearTrackedWindupData();
            source.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPAPLUSPLUS_FORCE_RELOADED_CONFIG.get())));
            try {
                AsyncWindup.reCreateScheduledExecutorService();
                AutosaveScheduler.reCreateScheduledExecutorService();
                TimeoutScheduler.reCreateScheduledExecutorService();
                WindupWatcher.reCreateScheduledExecutorService();
            }
            catch (IllegalStateException e) {
                LOGGER.error(e.getMessage());
                source.sendFailure((Component)Component.literal((String)SCHEDULED_EXECUTOR_SERVICE_EXCEPTION_MESSAGE));
                return 0;
            }
            return 1;
        }
        source.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPAPLUSPLUS_RELOADING_CONFIG.get())));
        Config.SPEC.afterReload();
        source.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPAPLUSPLUS_RELOADED_CONFIG.get())));
        try {
            AsyncWindup.reCreateScheduledExecutorService();
            AutosaveScheduler.reCreateScheduledExecutorService();
            TimeoutScheduler.reCreateScheduledExecutorService();
            WindupWatcher.reCreateScheduledExecutorService();
        }
        catch (IllegalStateException e) {
            LOGGER.error(e.getMessage());
            source.sendFailure((Component)Component.literal((String)SCHEDULED_EXECUTOR_SERVICE_EXCEPTION_MESSAGE));
            return 0;
        }
        return 1;
    }
}

