/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.toggle;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.io.PlayerData;
import net.superricky.tpaplusplus.io.SaveDataManager;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPToggle {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"tpaplusplus");

    public static void toggleTPOrWait(ServerPlayer executor) {
        try {
            if (AsyncCooldownHelper.checkCommandCooldownAndNotify(executor, executor.getUUID(), CommandType.TOGGLE)) {
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            executor.sendSystemMessage((Component)Component.literal((String)e.getMessage()));
            return;
        }
        if ((Integer)Config.TOGGLE_COOLDOWN.get() > 0) {
            AsyncCooldownKt.scheduleCooldown(executor.getUUID(), (Integer)Config.TOGGLE_COOLDOWN.get(), CommandType.TOGGLE);
        }
        if ((Double)Config.TOGGLE_WINDUP.get() == 0.0) {
            TPToggle.toggleTP(executor);
        } else {
            AsyncWindup.schedule(new WindupData((Double)Config.TOGGLE_WINDUP.get(), executor.getX(), executor.getY(), executor.getZ(), CommandType.TOGGLE, new ServerPlayer[]{executor}));
        }
    }

    public static void toggleTP(ServerPlayer executor) {
        PlayerData executorData;
        executorData.setTPToggle(!(executorData = SaveDataManager.getPlayerData(executor)).getTPToggle());
        if (executorData.getTPToggle()) {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPTOGGLE_ENABLED.get())));
        } else {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.TPTOGGLE_DISABLED.get())));
        }
    }

    private TPToggle() {
    }
}

