/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.send;

import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.commands.block.PlayerBlockingHelper;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.io.PlayerData;
import net.superricky.tpaplusplus.io.SaveDataManager;
import net.superricky.tpaplusplus.limitations.LimitationManager;
import net.superricky.tpaplusplus.requests.Request;
import net.superricky.tpaplusplus.requests.RequestHelper;
import net.superricky.tpaplusplus.timeout.TimeoutScheduler;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;

public class SendTPA {
    public static void sendTeleportRequest(ServerPlayer sender, ServerPlayer receiver, boolean isHereRequest) {
        PlayerData senderData;
        if (RequestHelper.isPlayerIdentical(sender, receiver)) {
            sender.sendSystemMessage((Component)Component.literal((String)((String)Messages.ERR_NO_SELF_TELEPORT.get())));
            return;
        }
        if (RequestHelper.alreadySentTeleportRequest(sender, receiver)) {
            sender.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_ALREADY_SENT_TELEPORT_REQUEST.get(), Map.of("receiver_name", receiver.getName().getString()))));
            return;
        }
        if (PlayerBlockingHelper.isPlayerBlocked(sender, receiver)) {
            return;
        }
        PlayerData receiverData = SaveDataManager.getPlayerData(receiver);
        if (Boolean.FALSE.equals(Objects.isNull(receiverData)) && receiverData.getTPToggle()) {
            sender.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ERR_RECEIVER_TP_DISABLED.get(), Map.of("receiverName", receiver.getName().getString()))));
            return;
        }
        if (Boolean.FALSE.equals(Config.ALLOW_TPTOGGLED_PLAYERS_TO_SEND_REQUESTS.get()) && Boolean.FALSE.equals(Objects.isNull(senderData = SaveDataManager.getPlayerData(sender))) && senderData.getTPToggle()) {
            sender.sendSystemMessage((Component)Component.literal((String)((String)Messages.ERR_SENDER_TP_DISABLED.get())));
            return;
        }
        if (!LimitationManager.notifyAndCheckAllowedToTeleport(sender, receiver, false)) {
            return;
        }
        if (isHereRequest) {
            if (AsyncCooldownHelper.checkCommandCooldownAndNotify(sender, sender.getUUID(), CommandType.TPAHERE)) {
                return;
            }
            if ((Integer)Config.TPAHERE_COOLDOWN.get() > 0) {
                AsyncCooldownKt.scheduleCooldown(sender.getUUID(), (Integer)Config.TPAHERE_COOLDOWN.get(), CommandType.TPAHERE);
            }
            if ((Double)Config.TPAHERE_WINDUP.get() == 0.0) {
                SendTPA.absoluteSendTeleportRequest(sender, receiver, isHereRequest);
            } else {
                AsyncWindup.schedule(new WindupData(true, (double)((Double)Config.TPAHERE_WINDUP.get()), sender.getX(), sender.getY(), sender.getZ(), CommandType.TPAHERE, new ServerPlayer[]{sender, receiver}));
            }
        } else {
            if (AsyncCooldownHelper.checkCommandCooldownAndNotify(sender, sender.getUUID(), CommandType.TPA)) {
                return;
            }
            if ((Integer)Config.TPA_COOLDOWN.get() > 0) {
                AsyncCooldownKt.scheduleCooldown(sender.getUUID(), (Integer)Config.TPA_COOLDOWN.get(), CommandType.TPA);
            }
            if ((Double)Config.TPA_WINDUP.get() == 0.0) {
                SendTPA.absoluteSendTeleportRequest(sender, receiver, isHereRequest);
            } else {
                AsyncWindup.schedule(new WindupData(false, (double)((Double)Config.TPA_WINDUP.get()), sender.getX(), sender.getY(), sender.getZ(), CommandType.TPA, new ServerPlayer[]{sender, receiver}));
            }
        }
    }

    public static void absoluteSendTeleportRequest(ServerPlayer sender, ServerPlayer receiver, boolean isHereRequest) {
        Request request = new Request(sender, receiver, isHereRequest);
        RequestHelper.getRequestSet().add(request);
        TimeoutScheduler.scheduleTeleportTimeout(request);
        if (isHereRequest) {
            sender.sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.SENDER_SENT_TPAHERE.get(), receiver.getName().getString())));
            receiver.sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.RECEIVER_GOT_TPAHERE.get(), sender.getName().getString())));
        } else {
            sender.sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.SENDER_SENT_TPA.get(), receiver.getName().getString())));
            receiver.sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.RECEIVER_GOT_TPA.get(), sender.getName().getString())));
        }
    }

    private SendTPA() {
    }
}

