/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.deny;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.requests.Request;
import net.superricky.tpaplusplus.requests.RequestGrabUtil;
import net.superricky.tpaplusplus.requests.RequestHelper;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;

public class DenyTPA {
    private static void denyFunctionality(Request request, ServerPlayer receiver) {
        if (Objects.isNull(request)) {
            receiver.sendSystemMessage((Component)Component.literal((String)((String)Messages.ERR_REQUEST_NOT_FOUND.get())));
            return;
        }
        if (AsyncCooldownHelper.checkCommandCooldownAndNotify(receiver, receiver.getUUID(), CommandType.DENY)) {
            return;
        }
        if ((Integer)Config.DENY_COOLDOWN.get() > 0) {
            AsyncCooldownKt.scheduleCooldown(receiver.getUUID(), (Integer)Config.DENY_COOLDOWN.get(), CommandType.DENY);
        }
        if ((Double)Config.DENY_WINDUP.get() == 0.0) {
            DenyTPA.absoluteDeny(request);
        } else {
            AsyncWindup.schedule(new WindupData(request, (double)((Double)Config.DENY_WINDUP.get()), receiver.getX(), receiver.getY(), receiver.getZ(), CommandType.DENY, new ServerPlayer[]{receiver}));
        }
    }

    public static void absoluteDeny(Request request) {
        request.getReceiver().sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.RECEIVER_DENIES_TPA.get(), request.getSender().getName().getString())));
        request.getSender().sendSystemMessage((Component)Component.literal((String)String.format((String)Messages.SENDER_GOT_DENIED_TPA.get(), request.getReceiver().getName().getString())));
        RequestHelper.getRequestSet().remove(request);
    }

    public static void denyTeleportRequest(ServerPlayer receiver) {
        Request request = RequestGrabUtil.getReceiverRequest(receiver);
        DenyTPA.denyFunctionality(request, receiver);
    }

    public static void denyTeleportRequest(ServerPlayer receiver, ServerPlayer sender) {
        Request request = RequestGrabUtil.getReceiverRequest(receiver, sender);
        DenyTPA.denyFunctionality(request, receiver);
    }

    private DenyTPA() {
    }
}

