/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.block;

import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.io.SaveDataManager;

public class PlayerBlockingHelper {
    public static final String BLOCKED_PLAYER_CONSTANT = "blocked_player";

    public static boolean isPlayerBlocked(ServerPlayer sender, ServerPlayer receiver) {
        for (UUID senderBlockedUUID : SaveDataManager.getPlayerData(sender).getBlockedPlayers()) {
            if (!receiver.getUUID().equals(senderBlockedUUID)) continue;
            sender.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.SENDER_BLOCKED_RECEIVER.get(), Map.of(BLOCKED_PLAYER_CONSTANT, receiver.getName().getString()))));
            return true;
        }
        for (UUID receiverBlockedUUID : SaveDataManager.getPlayerData(receiver).getBlockedPlayers()) {
            if (!sender.getUUID().equals(receiverBlockedUUID)) continue;
            sender.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.RECEIVER_BLOCKED_SENDER.get(), Map.of("blocking_player", receiver.getName().getString()))));
            return true;
        }
        return false;
    }

    private PlayerBlockingHelper() {
    }
}

