/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.block;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.config.formatters.MessageParser;
import net.superricky.tpaplusplus.io.PlayerData;
import net.superricky.tpaplusplus.io.SaveDataManager;
import net.superricky.tpaplusplus.requests.RequestHelper;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;

public class BlockPlayer {
    public static void blockPlayer(ServerPlayer executor, ServerPlayer blockedPlayer) {
        if (RequestHelper.isPlayerIdentical(executor, blockedPlayer)) {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.CANNOT_BLOCK_SELF.get())));
            return;
        }
        PlayerData executorData = SaveDataManager.getPlayerData(executor);
        if (executorData.getBlockedPlayers().contains(blockedPlayer.getUUID())) {
            executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.ALREADY_BLOCKED_PLAYER.get(), Map.of("blocked_player", blockedPlayer.getName().getString()))));
            return;
        }
        if (AsyncCooldownHelper.checkCommandCooldownAndNotify(executor, executor.getUUID(), CommandType.BLOCK)) {
            return;
        }
        if ((Integer)Config.BLOCK_COOLDOWN.get() > 0) {
            AsyncCooldownKt.scheduleCooldown(executor.getUUID(), (Integer)Config.BLOCK_COOLDOWN.get(), CommandType.BLOCK);
        }
        if ((Double)Config.BLOCK_WINDUP.get() == 0.0) {
            BlockPlayer.absoluteBlockPlayer(executorData, executor, blockedPlayer);
        } else {
            AsyncWindup.schedule(new WindupData(executorData, (double)((Double)Config.BLOCK_WINDUP.get()), executor.getX(), executor.getY(), executor.getZ(), CommandType.BLOCK, new ServerPlayer[]{executor, blockedPlayer}));
        }
    }

    public static void absoluteBlockPlayer(PlayerData executorData, ServerPlayer executor, ServerPlayer blockedPlayer) {
        executorData.getBlockedPlayers().add(blockedPlayer.getUUID());
        executor.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.SENDER_BLOCKED_PLAYER.get(), Map.of("blocked_player", blockedPlayer.getName().getString()))));
        if (Boolean.TRUE.equals(Config.SEND_BLOCKED_MESSAGES_TO_BOTH_PLAYERS.get())) {
            blockedPlayer.sendSystemMessage((Component)Component.literal((String)MessageParser.enhancedFormatter((String)Messages.PLAYER_BLOCKED_BY_SENDER.get(), Map.of("sender_name", executor.getName().getString()))));
        }
    }

    private BlockPlayer() {
    }
}

