/*
 * Decompiled with CFR 0.152.
 */
package net.superricky.tpaplusplus.commands.back;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.superricky.tpaplusplus.commands.back.DeathHelper;
import net.superricky.tpaplusplus.commands.back.LevelBoundVec3;
import net.superricky.tpaplusplus.config.Config;
import net.superricky.tpaplusplus.config.Messages;
import net.superricky.tpaplusplus.windupcooldown.CommandType;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownHelper;
import net.superricky.tpaplusplus.windupcooldown.cooldown.AsyncCooldownKt;
import net.superricky.tpaplusplus.windupcooldown.windup.AsyncWindup;
import net.superricky.tpaplusplus.windupcooldown.windup.WindupData;
import org.jetbrains.annotations.Nullable;

public class Back {
    private Back() {
    }

    public static void teleportToLatestDeath(ServerPlayer executor) {
        if (Boolean.FALSE.equals(Config.BACK_COMMAND_ENABLED.get())) {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.ERR_BACK_COMMAND_DISABLED.get())));
            return;
        }
        @Nullable LevelBoundVec3 deathPosition = DeathHelper.getPlayerDeathCoordinates().get(executor.getUUID());
        if (Objects.isNull((Object)deathPosition)) {
            executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.ERR_DEATH_LOC_NOT_FOUND.get())));
            return;
        }
        if (AsyncCooldownHelper.checkCommandCooldownAndNotify(executor, executor.getUUID(), CommandType.BACK)) {
            return;
        }
        if ((Integer)Config.BACK_COOLDOWN.get() > 0) {
            AsyncCooldownKt.scheduleCooldown(executor.getUUID(), (Integer)Config.BACK_COOLDOWN.get(), CommandType.BACK);
        }
        if ((Double)Config.BACK_WINDUP.get() == 0.0) {
            Back.absoluteTeleportToLatestDeath(executor, deathPosition);
        } else {
            AsyncWindup.schedule(new WindupData(deathPosition, (double)((Double)Config.BACK_WINDUP.get()), executor.getX(), executor.getY(), executor.getZ(), CommandType.BACK, new ServerPlayer[]{executor}));
        }
    }

    public static void absoluteTeleportToLatestDeath(ServerPlayer executor, LevelBoundVec3 deathPosition) {
        executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.DEATH_BEING_TELEPORTED.get())));
        Back.teleportToLastPosition(executor, deathPosition);
        DeathHelper.getPlayerDeathCoordinates().remove(executor.getUUID());
        executor.sendSystemMessage((Component)Component.literal((String)((String)Messages.DEATH_TELEPORTED.get())));
    }

    public static void teleportToLastPosition(ServerPlayer executor, LevelBoundVec3 deathPosition) {
        executor.teleportTo(deathPosition.serverLevel(), deathPosition.x, deathPosition.y, deathPosition.z, executor.getYRot(), executor.getXRot());
    }
}

