/*
 * Decompiled with CFR 0.152.
 */
package org.arcticquests.dev.tpautilities.TpaUtilities;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class TPACommands {
    public static final TPACommands INSTANCE = new TPACommands();
    private final ConcurrentHashMap<UUID, Queue<UUID>> playerTPAMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Queue<UUID>> playerTPAHEREMap = new ConcurrentHashMap();
    public final List<ScheduledExecutorService> schedulers = new ArrayList<ScheduledExecutorService>();
    private final List<UUID> lockedTPAPlayers = new ArrayList<UUID>();

    public int requestExecute(CommandContext<CommandSourceStack> context, Type type) throws CommandSyntaxException {
        String expiredKey;
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.command_player_only").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerUuid = player.getUUID();
        String playerName = player.getName().getString();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
        UUID targetUuid = target.getUUID();
        boolean self = playerUuid.equals(targetUuid);
        boolean locked = this.lockedTPAPlayers.contains(targetUuid);
        ConcurrentHashMap<UUID, Queue<UUID>> reqMap = type == Type.TPA ? this.playerTPAMap : this.playerTPAHEREMap;
        String wantsKey = type == Type.TPA ? "tpautilities.wants_tpa_teleport" : "tpautilities.wants_tpahere_teleport";
        String alreadyKey = type == Type.TPA ? "tpautilities.error_tpa_already_asked" : "tpautilities.error_tpahere_already_asked";
        String disabledKey = type == Type.TPA ? "tpautilities.error_tpa_disabled" : "tpautilities.error_tpahere_disabled";
        String yourselfKey = type == Type.TPA ? "tpautilities.error_tpa_yourself" : "tpautilities.error_tpahere_yourself";
        SoundEvent requestSound = type == Type.TPA ? SoundEvents.AMETHYST_BLOCK_BREAK : SoundEvents.AMETHYST_BLOCK_RESONATE;
        String string = expiredKey = type == Type.TPA ? "tpautilities.tpa_expired" : "tpautilities.tpahere_expired";
        if (self) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)yourselfKey).withStyle(ChatFormatting.RED));
            return 1;
        }
        if (locked) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)disabledKey).withStyle(ChatFormatting.RED));
            return 1;
        }
        if (reqMap.containsKey(targetUuid) && reqMap.get(targetUuid).contains(playerUuid)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)alreadyKey).withStyle(ChatFormatting.RED));
            return 1;
        }
        reqMap.computeIfAbsent(targetUuid, k -> new LinkedList()).add(playerUuid);
        MutableComponent wantsMsg = Component.translatable((String)wantsKey, (Object[])new Object[]{playerName}).withStyle(ChatFormatting.YELLOW);
        target.sendSystemMessage((Component)wantsMsg);
        target.level().playSound(null, target.blockPosition(), requestSound, SoundSource.MASTER, 1.0f, 1.0f);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Teleport request sent to " + target.getName().getString() + "!")).withStyle(ChatFormatting.YELLOW), false);
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        this.schedulers.add(scheduler);
        scheduler.schedule(() -> {
            if (reqMap.containsKey(targetUuid) && ((Queue)reqMap.get(targetUuid)).remove(playerUuid)) {
                if (((Queue)reqMap.get(targetUuid)).isEmpty()) {
                    reqMap.remove(targetUuid);
                }
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)expiredKey).withStyle(ChatFormatting.RED));
                if (type == Type.TPAHERE) {
                    player.level().playSound(null, player.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
            this.schedulers.remove(scheduler);
            scheduler.shutdown();
        }, 60L, TimeUnit.SECONDS);
        return 1;
    }

    public int tpacceptExecute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.command_player_only").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (this.handleAcceptOrDeny(player, true)) {
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.error_tpaccept").withStyle(ChatFormatting.RED));
        return 1;
    }

    public int tpadenyExecute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.command_player_only").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (this.handleAcceptOrDeny(player, false)) {
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.error_tpadeny").withStyle(ChatFormatting.RED));
        return 1;
    }

    private boolean handleAcceptOrDeny(ServerPlayer player, boolean accept) {
        Queue<UUID> queue = this.playerTPAMap.get(player.getUUID());
        boolean isTPA = true;
        if (queue == null || queue.isEmpty()) {
            queue = this.playerTPAHEREMap.get(player.getUUID());
            isTPA = false;
        }
        if (queue == null || queue.isEmpty()) {
            return false;
        }
        UUID targetUuid = queue.poll();
        if (queue.isEmpty()) {
            if (isTPA) {
                this.playerTPAMap.remove(player.getUUID());
            } else {
                this.playerTPAHEREMap.remove(player.getUUID());
            }
        }
        if (targetUuid == null) {
            return false;
        }
        ServerPlayer target = player.getServer().getPlayerList().getPlayer(targetUuid);
        if (target == null) {
            return true;
        }
        String targetName = target.getName().getString();
        String playerName = player.getName().getString();
        if (accept) {
            if (isTPA) {
                target.teleportTo(player.serverLevel(), player.getX(), player.getY(), player.getZ(), target.getYRot(), target.getXRot());
            } else {
                player.teleportTo(target.serverLevel(), target.getX(), target.getY(), target.getZ(), player.getYRot(), player.getXRot());
            }
            target.sendSystemMessage((Component)Component.literal((String)(playerName + " has accepted your teleport request!")).withStyle(ChatFormatting.GREEN));
            player.sendSystemMessage((Component)Component.literal((String)("You have accepted the teleport request from " + targetName + ".")).withStyle(ChatFormatting.GREEN));
            (isTPA ? target : player).level().playSound(null, (isTPA ? target : player).blockPosition(), SoundEvents.ENDER_EYE_DEATH, SoundSource.MASTER, 1.0f, 1.0f);
        } else {
            target.sendSystemMessage((Component)Component.literal((String)(playerName + " has denied your teleport request.")).withStyle(ChatFormatting.RED));
            player.sendSystemMessage((Component)Component.literal((String)("You have denied the teleport request from " + targetName + ".")).withStyle(ChatFormatting.RED));
            target.level().playSound(null, target.blockPosition(), SoundEvents.VILLAGER_NO, SoundSource.MASTER, 1.0f, 1.0f);
        }
        return true;
    }

    public int tpacancelExecute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.command_player_only").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerUuid = player.getUUID();
        ArrayList<UUID> keysTPA = Collections.list(this.playerTPAMap.keys());
        ArrayList<UUID> keysTPAHERE = Collections.list(this.playerTPAHEREMap.keys());
        for (UUID targetUuid : keysTPA) {
            this.playerTPAMap.get(targetUuid).remove(playerUuid);
            if (!this.playerTPAMap.get(targetUuid).isEmpty()) continue;
            this.playerTPAMap.remove(targetUuid);
        }
        for (UUID targetUuid : keysTPAHERE) {
            this.playerTPAHEREMap.get(targetUuid).remove(playerUuid);
            if (!this.playerTPAHEREMap.get(targetUuid).isEmpty()) continue;
            this.playerTPAHEREMap.remove(targetUuid);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"tpautilities.tpacancel_success").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    public int tpalockExecute(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"tpautilities.command_player_only").withStyle(ChatFormatting.RED));
            return 1;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerUuid = player.getUUID();
        if (this.lockedTPAPlayers.contains(playerUuid)) {
            this.lockedTPAPlayers.remove(playerUuid);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"tpautilities.tpalock_activated").withStyle(ChatFormatting.GREEN), false);
        } else {
            this.lockedTPAPlayers.add(playerUuid);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"tpautilities.tpalock_deactivated").withStyle(ChatFormatting.GREEN), false);
        }
        return 1;
    }

    public static enum Type {
        TPA,
        TPAHERE;

    }
}

