/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class LootTableIdCondition
implements LootItemCondition {
    public static final MapCodec<LootTableIdCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("loot_table_id").forGetter(idCondition -> idCondition.targetLootTableId)).apply((Applicative)builder, LootTableIdCondition::new));
    public static final LootItemConditionType LOOT_TABLE_ID = new LootItemConditionType(CODEC);
    public static final ResourceLocation UNKNOWN_LOOT_TABLE = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"unknown_loot_table");
    private final ResourceLocation targetLootTableId;

    private LootTableIdCondition(ResourceLocation targetLootTableId) {
        this.targetLootTableId = targetLootTableId;
    }

    public LootItemConditionType getType() {
        return LOOT_TABLE_ID;
    }

    public boolean test(LootContext lootContext) {
        return lootContext.getQueriedLootTableId().equals((Object)this.targetLootTableId);
    }

    public static Builder builder(ResourceLocation targetLootTableId) {
        return new Builder(targetLootTableId);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final ResourceLocation targetLootTableId;

        public Builder(ResourceLocation targetLootTableId) {
            if (targetLootTableId == null) {
                throw new IllegalArgumentException("Target loot table must not be null");
            }
            this.targetLootTableId = targetLootTableId;
        }

        public LootItemCondition build() {
            return new LootTableIdCondition(this.targetLootTableId);
        }
    }
}

