/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.client.render;

import com.cerbon.bosses_of_mass_destruction.client.render.IBoneLight;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class BMDBlockEntityRenderer<T extends BlockEntity>
extends GeoBlockRenderer<T> {
    private final IBoneLight iBoneLight;

    public BMDBlockEntityRenderer(GeoModel<T> model, IBoneLight iBoneLight) {
        super(model);
        this.iBoneLight = iBoneLight;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)this.model.getTextureResource(animatable));
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        int packedLight1 = this.iBoneLight != null ? this.iBoneLight.getLightForBone(bone, packedLight) : packedLight;
        int red = FastColor.ARGB32.red((int)colour);
        int blue = FastColor.ARGB32.blue((int)colour);
        int green = FastColor.ARGB32.green((int)colour);
        int alpha = FastColor.ARGB32.alpha((int)colour);
        Vector4f color = new Vector4f((float)red, (float)green, (float)blue, (float)alpha);
        Vector4f newColor = this.iBoneLight != null ? this.iBoneLight.getColorForBone(bone, color) : color;
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight1, packedOverlay, FastColor.ARGB32.color((int)((int)newColor.w), (int)((int)newColor.x), (int)((int)newColor.y), (int)((int)newColor.z)));
    }
}

