/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_neoforge.cmd;

import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.beautifiedchatserver_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandBCS {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (String commandPrefix : Arrays.asList("beautifiedchatserver", "bcs")) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandPrefix).requires(iCommandSender -> iCommandSender.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rank").then(Commands.literal((String)"create").then(Commands.argument((String)"rank-name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"color", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestsColors).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String colorStr = StringArgumentType.getString((CommandContext)command, (String)"color");
                ChatFormatting color = Util.parseColor(colorStr);
                if (color == null) {
                    ((CommandSourceStack)command.getSource()).sendFailure((Component)Util.prefix().append((Component)Util.text("Unknown color: ", ChatFormatting.RED)).append((Component)Util.text(colorStr, ChatFormatting.WHITE)));
                    return 0;
                }
                boolean changed = Util.addOrUpdateRank(rankName, color);
                if (changed) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).append((Component)Util.text(" set to color ", ChatFormatting.GRAY)).append((Component)Util.text(color.getName(), color)), (boolean)true);
                } else {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).append((Component)Util.text(" already had color ", ChatFormatting.GRAY)).append((Component)Util.text(color.getName(), color)), (boolean)true);
                }
                return 1;
            }))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                boolean removed = Util.removeRank(rankName);
                if (removed) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Removed rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                    return 1;
                }
                ((CommandSourceStack)command.getSource()).sendFailure((Component)Util.prefix().append((Component)Util.text("Rank ", ChatFormatting.RED)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).append((Component)Util.text(" does not exist.", ChatFormatting.RED)));
                return 0;
            })))).then(Commands.literal((String)"list").executes(command -> {
                JsonObject ranks = Util.readJsonObjectSafe(Util.ranksPathString());
                if (ranks.isEmpty()) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("No ranks defined.", ChatFormatting.GRAY)), (boolean)true);
                    return 1;
                }
                MutableComponent out = Util.prefix().append((Component)Util.text("Ranks:", ChatFormatting.GOLD));
                for (String key : Util.sortedKeys(ranks)) {
                    String colorName = Util.asString(ranks.get(key));
                    ChatFormatting cf = colorName != null ? Util.parseColor(colorName) : null;
                    out.append((Component)Component.literal((String)"\n")).append((Component)Util.text("- ", ChatFormatting.DARK_GRAY)).append((Component)Util.text(key, ChatFormatting.AQUA)).append((Component)Util.text(" = ", ChatFormatting.GRAY)).append((Component)Util.text(colorName == null ? "UNKNOWN" : colorName, cf != null ? cf : ChatFormatting.WHITE));
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)out, (boolean)true);
                return 1;
            })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player").then(Commands.literal((String)"add").then(Commands.argument((String)"player-name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (Util.rankEquals(current, rankName)) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Player ", ChatFormatting.GRAY)).append((Component)Util.text(playerName, ChatFormatting.GREEN)).append((Component)Util.text(" is already in rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(current), ChatFormatting.AQUA)), (boolean)true);
                    return 1;
                }
                String outcome = Util.togglePlayerRank(playerName, rankName);
                if ("removed".equals(outcome)) {
                    Util.togglePlayerRank(playerName, rankName);
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Player ", ChatFormatting.GRAY)).append((Component)Util.text(playerName, ChatFormatting.GREEN)).append((Component)Util.text(" added to rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                return 1;
            }))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player-name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"rank-name", (ArgumentType)StringArgumentType.string()).suggests(Util::suggestRanks).executes(command -> {
                String playerName = StringArgumentType.getString((CommandContext)command, (String)"player-name");
                String rankName = StringArgumentType.getString((CommandContext)command, (String)"rank-name");
                String current = Util.getRankOfPlayer(playerName).orElse(null);
                if (!Util.rankEquals(current, rankName)) {
                    ((CommandSourceStack)command.getSource()).sendFailure((Component)Util.prefix().append((Component)Util.text("Player ", ChatFormatting.RED)).append((Component)Util.text(playerName, ChatFormatting.GREEN)).append((Component)Util.text(" is not in rank ", ChatFormatting.RED)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)).append((Component)Util.text(".", ChatFormatting.RED)));
                    return 0;
                }
                Util.togglePlayerRank(playerName, rankName);
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("Removed player ", ChatFormatting.GRAY)).append((Component)Util.text(playerName, ChatFormatting.GREEN)).append((Component)Util.text(" from rank ", ChatFormatting.GRAY)).append((Component)Util.text(Util.norm(rankName), ChatFormatting.AQUA)), (boolean)true);
                return 1;
            }))))).then(Commands.literal((String)"list").executes(command -> {
                JsonObject players = Util.readJsonObjectSafe(Util.playersPathString());
                if (players.isEmpty()) {
                    MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)Util.prefix().append((Component)Util.text("No players assigned to ranks.", ChatFormatting.GRAY)), (boolean)true);
                    return 1;
                }
                MutableComponent out = Util.prefix().append((Component)Util.text("Players with ranks:", ChatFormatting.GOLD));
                for (String player : Util.sortedKeys(players)) {
                    String rank = Util.asString(players.get(player));
                    ChatFormatting cf = rank != null ? Util.parseColor(Util.getRankColor(rank).map(ChatFormatting::getName).orElse(rank)) : null;
                    out.append((Component)Component.literal((String)"\n")).append((Component)Util.text("- ", ChatFormatting.DARK_GRAY)).append((Component)Util.text(player, ChatFormatting.GREEN)).append((Component)Util.text(" -> ", ChatFormatting.GRAY)).append((Component)Util.text(rank == null ? "UNKNOWN" : Util.norm(rank), ChatFormatting.AQUA));
                }
                MessageFunctions.sendMessage((CommandSourceStack)((CommandSourceStack)command.getSource()), (MutableComponent)out, (boolean)true);
                return 1;
            }))));
        }
    }
}

