/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.beautifiedchatserver_common_fabric.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.natamus.beautifiedchatserver_common_fabric.config.ConfigHandler;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class Util {
    private static final Path BASE_DIR = Paths.get(DataFunctions.getConfigDirectory(), "beautifiedchatserver");
    private static final Path RANKS_FILE = BASE_DIR.resolve("ranks.json");
    private static final Path PLAYERS_FILE = BASE_DIR.resolve("players.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static class_124 getColour(String word, String playerName) {
        class_124 colour = class_124.method_534((int)ConfigHandler.chatOtherSymbolsColour);
        if (word.equalsIgnoreCase("timestamp")) {
            colour = class_124.method_534((int)ConfigHandler.chatTimestampColour);
        } else if (word.equalsIgnoreCase("username")) {
            String playerRank;
            Optional<class_124> optionalRankColour;
            Optional<String> optionalPlayerRank;
            if (ConfigHandler.useRankColours && (optionalPlayerRank = Util.getRankOfPlayer(playerName)).isPresent() && (optionalRankColour = Util.getRankColor(playerRank = optionalPlayerRank.get())).isPresent()) {
                return optionalRankColour.get();
            }
            colour = class_124.method_534((int)ConfigHandler.chatUsernameColour);
        } else if (word.equalsIgnoreCase("chatmessage")) {
            colour = class_124.method_534((int)ConfigHandler.chatMessageColour);
        }
        return colour;
    }

    public static class_124 parseColor(String s) {
        if (s == null) {
            return null;
        }
        try {
            return class_124.valueOf((String)s.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (class_124 cf : class_124.values()) {
                if (!cf.method_543() || !cf.method_537().equalsIgnoreCase(s)) continue;
                return cf;
            }
            return null;
        }
    }

    public static CompletableFuture<Suggestions> suggestsColors(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        for (class_124 cf : class_124.values()) {
            if (!cf.method_543()) continue;
            builder.suggest(cf.method_537());
        }
        return builder.buildFuture();
    }

    public static boolean addOrUpdateRank(String rankName, class_124 color) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        String newColor = color.method_537().toUpperCase(Locale.ROOT);
        if (ranks.has(r) && newColor.equals(Util.asString(ranks.get(r)))) {
            return false;
        }
        ranks.addProperty(r, newColor);
        Util.writeJsonObject(RANKS_FILE, ranks);
        return true;
    }

    public static boolean removeRank(String rankName) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        if (!ranks.has(r)) {
            return false;
        }
        ranks.remove(r);
        Util.writeJsonObject(RANKS_FILE, ranks);
        return true;
    }

    public static Optional<class_124> getRankColor(String rankName) {
        Util.ensureDirs();
        String r = Util.norm(rankName);
        JsonObject ranks = Util.readJsonObject(RANKS_FILE);
        if (!ranks.has(r)) {
            return Optional.empty();
        }
        String colorName = Util.asString(ranks.get(r));
        if (colorName == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(class_124.valueOf((String)colorName.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException ex) {
            for (class_124 cf : class_124.values()) {
                if (!cf.method_537().equalsIgnoreCase(colorName)) continue;
                return Optional.of(cf);
            }
            return Optional.empty();
        }
    }

    public static String togglePlayerRank(String playerName, String rankName) {
        String current;
        Util.ensureDirs();
        String p = Util.norm(playerName);
        String r = Util.norm(rankName);
        JsonObject players = Util.readJsonObject(PLAYERS_FILE);
        String string = current = players.has(p) ? Util.asString(players.get(p)) : null;
        if (r.equals(current)) {
            players.remove(p);
            Util.writeJsonObject(PLAYERS_FILE, players);
            return "removed";
        }
        players.addProperty(p, r);
        Util.writeJsonObject(PLAYERS_FILE, players);
        return "added";
    }

    public static Optional<String> getRankOfPlayer(String playerName) {
        Util.ensureDirs();
        String p = Util.norm(playerName);
        JsonObject players = Util.readJsonObject(PLAYERS_FILE);
        if (!players.has(p)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Util.asString(players.get(p)));
    }

    private static void ensureDirs() {
        try {
            Files.createDirectories(BASE_DIR, new FileAttribute[0]);
            Util.ensureFile(RANKS_FILE);
            Util.ensureFile(PLAYERS_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config directories/files", e);
        }
    }

    private static void ensureFile(Path file) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            Util.writeJsonObject(file, new JsonObject());
        }
    }

    private static JsonObject readJsonObject(Path file) {
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                return new JsonObject();
            }
            String text = Files.readString(file, StandardCharsets.UTF_8).trim();
            if (text.isEmpty()) {
                return new JsonObject();
            }
            JsonElement el = JsonParser.parseString((String)text);
            if (el.isJsonObject()) {
                return el.getAsJsonObject();
            }
            return new JsonObject();
        }
        catch (Exception e) {
            return new JsonObject();
        }
    }

    private static void writeJsonObject(Path file, JsonObject obj) {
        JsonObject sorted = Util.sortByKey(obj);
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            GSON.toJson((JsonElement)sorted, (Appendable)bw);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write " + String.valueOf(file), e);
        }
    }

    private static JsonObject sortByKey(JsonObject obj) {
        ArrayList keys = new ArrayList(obj.keySet());
        Collections.sort(keys);
        JsonObject out = new JsonObject();
        for (String k : keys) {
            out.add(k, obj.get(k));
        }
        return out;
    }

    public static String asString(JsonElement el) {
        return el != null && el.isJsonPrimitive() && el.getAsJsonPrimitive().isString() ? el.getAsString() : null;
    }

    public static String norm(String s) {
        return s.toLowerCase(Locale.ROOT).trim();
    }

    public static boolean rankEquals(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        return Util.norm(a).equals(Util.norm(b));
    }

    public static JsonObject readJsonObjectSafe(String stringPath) {
        try {
            Path path = Paths.get(stringPath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return new JsonObject();
            }
            String text = Files.readString(path, StandardCharsets.UTF_8).trim();
            if (text.isEmpty()) {
                return new JsonObject();
            }
            JsonElement el = JsonParser.parseString((String)text);
            return el.isJsonObject() ? el.getAsJsonObject() : new JsonObject();
        }
        catch (Exception ignored) {
            return new JsonObject();
        }
    }

    public static class_5250 prefix() {
        return class_2561.method_43470((String)"[").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)"BCS").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1063));
    }

    public static class_5250 text(String s, class_124 fmt) {
        return class_2561.method_43470((String)s).method_27692(fmt);
    }

    public static CompletableFuture<Suggestions> suggestRanks(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        JsonObject ranks = Util.readJsonObjectSafe(Util.ranksPathString());
        for (String key : Util.sortedKeys(ranks)) {
            builder.suggest(key);
        }
        return builder.buildFuture();
    }

    public static String ranksPathString() {
        return RANKS_FILE.toString();
    }

    public static String playersPathString() {
        return PLAYERS_FILE.toString();
    }

    public static Iterable<String> sortedKeys(JsonObject obj) {
        ArrayList<String> keys = new ArrayList<String>(obj.keySet());
        Collections.sort(keys);
        return keys;
    }
}

