/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.serialization;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.transformer.SoftMethodParamsPatch;
import org.sinytra.adapter.patch.transformer.operation.CompoundMethodTransform;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;
import org.sinytra.adapter.patch.transformer.operation.unit.DisableMixin;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyInjectionTarget;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyMethodAccess;
import org.sinytra.adapter.patch.transformer.operation.unit.ModifyMethodParams;

public class MethodTransformSerialization {
    public static final Codec<MethodTransform> METHOD_TRANSFORM_CODEC = Codec.STRING.partialDispatch("type", transform -> DataResult.success((Object)MethodTransformSerialization.getTransformName(transform)), name -> {
        Codec entryCodec = (Codec)TRANSFORMER_CODECS.get(name);
        if (entryCodec != null) {
            return DataResult.success((Object)entryCodec.fieldOf("transform"));
        }
        return DataResult.error(() -> "Missing codec for transformer " + name);
    });
    private static final BiMap<String, Codec<? extends MethodTransform>> TRANSFORMER_CODECS = ImmutableBiMap.builder().put((Object)"disable_mixin", DisableMixin.CODEC).put((Object)"modify_injection_point", ModifyInjectionPoint.CODEC).put((Object)"modify_injection_target", ModifyInjectionTarget.CODEC).put((Object)"modfiy_access", ModifyMethodAccess.CODEC).put((Object)"modify_method", ModifyMethodParams.CODEC).put((Object)"transform_parameters", TransformParameters.CODEC).put((Object)"soft_modify_method", SoftMethodParamsPatch.CODEC).put((Object)"pipeline_transform", CompoundMethodTransform.CODEC).build();

    private static String getTransformName(MethodTransform transform) {
        return Objects.requireNonNull((String)TRANSFORMER_CODECS.inverse().get(transform.codec()), "Missing name for transformer " + String.valueOf(transform));
    }
}

