/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.type;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.ClassTarget;
import org.sinytra.adapter.next.env.ann.WrapOperationMixinData;
import org.sinytra.adapter.next.env.ctx.MethodHelper;
import org.sinytra.adapter.next.env.param.MethodParameters;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.type.MixinType;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class WrapOperationMixin
implements MixinType<WrapOperationMixinData> {
    @Override
    public WrapOperationMixinData parse(MixinContext context, ClassTarget targetClass, MethodQualifier targetMethod, AtData atData, AnnotationHandle handle) {
        return new WrapOperationMixinData(targetClass, targetMethod, atData);
    }

    @Override
    public void preProcess(WrapOperationMixinData mixin, MixinContext context, MutableConfiguration clean, Recipe recipe) {
        clean.setParameters(MethodParameters.create(context.methodNode().desc, List.of(MethodParameters.ParamGroup.METHOD_PARAMS, MethodParameters.ParamGroup.OPERATION, MethodParameters.ParamGroup.CAPTURED_PARAMS)));
    }

    @Override
    public void postProcess(WrapOperationMixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        MethodNode targetMethodCall;
        if (dirty.getTargetMethod() == null) {
            return;
        }
        MethodQualifier dirtyAtTarget = dirty.getAtData().getTarget().flatMap(MethodQualifier::create).orElse(null);
        if (dirtyAtTarget == null) {
            return;
        }
        List<Type> dirtyCaptured = context.methods().resolveCapturedMethodParams(recipe.clean(), recipe.dirty());
        ArrayList<Type> callTypes = new ArrayList<Type>(MethodParameters.getParameterTypes(dirtyAtTarget.desc()));
        if (dirtyAtTarget.isFull() && (targetMethodCall = context.methods().findMethod(context.dirtyLookup(), dirtyAtTarget)) != null && !MethodHelper.isStatic(targetMethodCall)) {
            callTypes.addFirst(Type.getObjectType((String)dirtyAtTarget.internalOwnerName()));
        }
        MethodParameters params = MethodParameters.builder().put(MethodParameters.ParamGroup.METHOD_PARAMS, callTypes).put(MethodParameters.ParamGroup.OPERATION, AdapterUtil.OPERATION_TYPE).put(MethodParameters.ParamGroup.CAPTURED_PARAMS, dirtyCaptured).build();
        dirty.setParameters(params);
        dirty.setReturnType(Type.getReturnType((String)dirtyAtTarget.desc()));
    }
}

