/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.env.ann.ModifyVariableMixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResult;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.pipeline.resolver.Resolver;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.locals.LocalVarAnalyzer;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;

public class ModifyVarInjectionTargetSubResolver
implements Resolver {
    @Override
    public TxResult resolve(MixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        ModifyVariableMixinData mvdata;
        block5: {
            block4: {
                if (!(mixin instanceof ModifyVariableMixinData)) break block4;
                mvdata = (ModifyVariableMixinData)mixin;
                if (clean.getAtData().getValue().equals("STORE")) break block5;
            }
            return TxResult.PASS;
        }
        MethodContext.TargetPair pair = context.methods().findOwnMethodPair(context.dirtyLookup(), dirty.getTargetMethod());
        if (ModifyVarInjectionTargetSubResolver.findComparableReplacement(mvdata, context, clean, pair, dirty)) {
            return TxResult.SUCCESS;
        }
        return TxResult.PASS;
    }

    private static boolean findComparableReplacement(ModifyVariableMixinData mixin, MixinContext context, Configuration clean, MethodContext.TargetPair dirtyPair, MutableConfiguration dirty) {
        if (mixin.ordinal().isEmpty()) {
            return false;
        }
        int ordinal = mixin.ordinal().getAsInt();
        Type varType = Type.getReturnType((String)context.methodNode().desc);
        MethodContext.TargetPair cleanPair = context.methods().findOwnMethodPair(context.cleanLookup(), clean.getTargetMethod());
        LocalVariableLookup lookup = new LocalVariableLookup(cleanPair.methodNode());
        LocalVariableNode desired = lookup.getByTypedOrdinal(varType, ordinal).orElseThrow();
        InsnList desiredInitializerInsns = LocalVarAnalyzer.findInitializerInsns(cleanPair.methodNode(), desired.index);
        for (MethodNode method : dirtyPair.classNode().methods) {
            LocalVariableLookup dirtyLookup = new LocalVariableLookup(method);
            List<LocalVariableNode> lvs = method.localVariables.stream().filter(lvn -> desired.desc.equals(lvn.desc)).filter(lvn -> {
                InsnList insns = LocalVarAnalyzer.findInitializerInsns(method, lvn.index);
                return InstructionMatcher.test(desiredInitializerInsns, insns);
            }).toList();
            if (lvs.size() != 1) continue;
            int dirtyOrdinal = dirtyLookup.getOrdinal(lvs.getFirst());
            dirty.setProperty("ordinal", dirtyOrdinal);
            dirty.setTargetMethod(method);
            dirty.inheritAtData();
            return true;
        }
        return false;
    }
}

