/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.processor;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.TxResult;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.processor.Processor;
import org.sinytra.adapter.patch.fixes.TypeAdapter;

public class ReturnTypeProcessor
implements Processor {
    @Override
    public TxResult process(MixinData mixin, MixinContext context, Configuration dirty, Recipe recipe) {
        Type dirtyType;
        Type cleanType = recipe.clean().getReturnType();
        if (cleanType.equals((Object)(dirtyType = dirty.getReturnType()))) {
            return TxResult.PASS;
        }
        TypeAdapter adapter = context.getTypeAdapter(cleanType, dirtyType);
        if (adapter == null) {
            return TxResult.PASS;
        }
        ReturnInterpreter inter = new ReturnInterpreter();
        Analyzer analyzer = new Analyzer((Interpreter)inter);
        try {
            analyzer.analyze(context.methodNode().name, context.methodNode());
        }
        catch (AnalyzerException e) {
            throw new RuntimeException(e);
        }
        for (AbstractInsnNode insn : inter.insns) {
            if (insn.getOpcode() == 1) continue;
            adapter.apply(context.methodNode().instructions, insn);
        }
        MethodNode methodNode = context.methodNode();
        methodNode.desc = Type.getMethodDescriptor((Type)dirtyType, (Type[])Type.getArgumentTypes((String)methodNode.desc));
        return TxResult.SUCCESS;
    }

    private static class ReturnInterpreter
    extends SourceInterpreter {
        public final List<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();

        public ReturnInterpreter() {
            super(589824);
        }

        public void returnOperation(AbstractInsnNode insn, SourceValue value, SourceValue expected) {
            if (value.getSize() != 1) {
                throw new IllegalStateException();
            }
            this.insns.add((AbstractInsnNode)value.insns.iterator().next());
        }
    }
}

