/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.item;

import com.bobmowzie.mowziesmobs.server.item.ItemDart;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ItemBlowgun
extends BowItem {
    public static final Predicate<ItemStack> DARTS = stack -> stack.getItem() == ItemHandler.DART.get();

    public ItemBlowgun(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entityLiving, int timeLeft) {
        Player player;
        ItemStack itemstack;
        if (entityLiving instanceof Player && !(itemstack = (player = (Player)entityLiving).getProjectile(stack)).isEmpty()) {
            int duration = this.getUseDuration(stack, entityLiving) - timeLeft;
            if ((duration = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)duration, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float power = ItemBlowgun.getPowerForTime(duration);
            if (!((double)power < 0.1)) {
                List ammo = ItemBlowgun.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!ammo.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, ammo, power * 3.0f, 1.0f, power == 1.0f, null);
                    }
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)MMSounds.ENTITY_UMVUTHANA_BLOWDART.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public static float getPowerForTime(int charge) {
        float power = (float)charge / 5.0f;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.0")).setStyle(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.1")).setStyle(ItemHandler.TOOLTIP_STYLE));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".text.2")).setStyle(ItemHandler.TOOLTIP_STYLE));
    }

    @NotNull
    protected Projectile createProjectile(@NotNull Level level, @NotNull LivingEntity shooter, @NotNull ItemStack weapon, ItemStack ammo, boolean isCrit) {
        ArrowItem arrowItem;
        Item item = ammo.getItem();
        if (item instanceof ItemDart) {
            ItemDart dart = (ItemDart)item;
            arrowItem = dart;
        } else {
            arrowItem = (ArrowItem)ItemHandler.DART.get();
        }
        ArrowItem arrowitem = arrowItem;
        AbstractArrow arrow = arrowitem.createArrow(level, ammo, shooter, weapon);
        if (isCrit) {
            arrow.setCritArrow(true);
        }
        return this.customArrow(arrow, ammo, weapon);
    }

    @NotNull
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return DARTS;
    }

    @NotNull
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, @NotNull ItemStack projectileWeaponItem) {
        return ((ItemDart)((Object)ItemHandler.DART.get())).getDefaultInstance();
    }
}

