/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade;

import com.bobmowzie.mowziesmobs.server.entity.umvuthana.trade.Trade;
import com.google.common.collect.ImmutableSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class TradeStore {
    public static final TradeStore EMPTY = new TradeStore((ImmutableSet<Trade>)ImmutableSet.of(), 0);
    private final ImmutableSet<Trade> trades;
    private final int totalWeight;

    private TradeStore(ImmutableSet<Trade> trades, int totalWeight) {
        this.trades = trades;
        this.totalWeight = totalWeight;
    }

    public boolean hasStock() {
        return !this.trades.isEmpty();
    }

    public Trade get(RandomSource rng) {
        if (this.totalWeight <= 0) {
            return null;
        }
        int w = rng.nextInt(this.totalWeight);
        for (Trade t : this.trades) {
            if ((w -= t.weight()) >= 0) continue;
            return t;
        }
        return null;
    }

    public CompoundTag serialize(RegistryAccess access) {
        CompoundTag compound = new CompoundTag();
        ListTag tradesList = new ListTag();
        for (Trade trade : this.trades) {
            tradesList.add((Object)trade.serialize(access));
        }
        compound.put("trades", (Tag)tradesList);
        return compound;
    }

    public static TradeStore deserialize(RegistryAccess access, CompoundTag compound) {
        ListTag tradesList = compound.getList("trades", 10);
        int totalWeight = 0;
        ImmutableSet.Builder trades = new ImmutableSet.Builder();
        for (int i = 0; i < tradesList.size(); ++i) {
            Trade trade = Trade.deserialize(access, tradesList.getCompound(i));
            if (trade == null) continue;
            trades.add((Object)trade);
            totalWeight += trade.weight();
        }
        return new TradeStore((ImmutableSet<Trade>)trades.build(), totalWeight);
    }

    public static final class Builder {
        private final ImmutableSet.Builder<Trade> trades = new ImmutableSet.Builder();
        private int totalWeight;

        public Builder addTrade(Item input, int inputCount, Item output, int outputCount, int weight) {
            return this.addTrade(new ItemStack((ItemLike)input, inputCount), new ItemStack((ItemLike)output, outputCount), weight);
        }

        public Builder addTrade(ItemStack input, ItemStack output, int weight) {
            this.trades.add((Object)new Trade(input, output, weight));
            this.totalWeight += weight;
            return this;
        }

        public TradeStore build() {
            return new TradeStore((ImmutableSet<Trade>)this.trades.build(), this.totalWeight);
        }
    }
}

