/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.capability.DataHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class FrozenRenderHandler {
    private static final ResourceLocation FROZEN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/entity/frozen.png");

    public static void onRenderHand(RenderHandEvent event) {
        event.getPoseStack().pushPose();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && DataHandler.getData((Entity)player, DataHandler.FROZEN_DATA).getFrozen()) {
            boolean isMainHand;
            boolean bl = isMainHand = event.getHand() == InteractionHand.MAIN_HAND;
            if (isMainHand && !player.isInvisible() && event.getItemStack().isEmpty()) {
                HumanoidArm enumhandside = isMainHand ? player.getMainArm() : player.getMainArm().getOpposite();
                FrozenRenderHandler.renderArmFirstPersonFrozen(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getEquipProgress(), event.getSwingProgress(), enumhandside);
                event.setCanceled(true);
            }
        }
        event.getPoseStack().popPose();
    }

    private static void renderArmFirstPersonFrozen(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, float equippedProgress, float swingProgress, HumanoidArm side) {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
        Minecraft.getInstance().getTextureManager().bindForSetup(FROZEN_TEXTURE);
        boolean flag = side != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.sqrt((float)swingProgress);
        float f2 = -0.3f * Mth.sin((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.sin((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.sin((float)(swingProgress * (float)Math.PI));
        matrixStackIn.translate(f * (f2 + 0.64000005f), f3 + -0.6f + equippedProgress * -0.6f, f4 + -0.71999997f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f * 45.0f));
        float f5 = Mth.sin((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = Mth.sin((float)(f1 * (float)Math.PI));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f * f6 * 70.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * f5 * -20.0f));
        LocalPlayer abstractclientplayerentity = mc.player;
        mc.getTextureManager().bindForSetup(abstractclientplayerentity.getSkin().texture());
        matrixStackIn.translate((double)(f * -1.0f), (double)3.6f, 3.5);
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(f * 120.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(200.0f));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f * -135.0f));
        matrixStackIn.translate((double)(f * 5.6f), 0.0, 0.0);
        PlayerRenderer playerrenderer = (PlayerRenderer)renderManager.getRenderer((Entity)abstractclientplayerentity);
        if (flag) {
            playerrenderer.renderRightHand(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)abstractclientplayerentity);
            matrixStackIn.scale(1.02f, 1.02f, 1.02f);
            FrozenRenderHandler.renderRightArm(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)abstractclientplayerentity, (PlayerModel<AbstractClientPlayer>)((PlayerModel)playerrenderer.getModel()));
        } else {
            playerrenderer.renderLeftHand(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)abstractclientplayerentity);
            matrixStackIn.scale(1.02f, 1.02f, 1.02f);
            FrozenRenderHandler.renderLeftArm(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)abstractclientplayerentity, (PlayerModel<AbstractClientPlayer>)((PlayerModel)playerrenderer.getModel()));
        }
    }

    public static void renderRightArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, PlayerModel<AbstractClientPlayer> model) {
        FrozenRenderHandler.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, model.rightArm, model.rightSleeve, model);
    }

    public static void renderLeftArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, PlayerModel<AbstractClientPlayer> model) {
        FrozenRenderHandler.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, model.leftArm, model.leftSleeve, model);
    }

    private static void renderItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, ModelPart rendererArmIn, ModelPart rendererArmwearIn, PlayerModel<AbstractClientPlayer> model) {
        FrozenRenderHandler.setModelVisibilities(playerIn, model);
        model.attackTime = 0.0f;
        model.crouching = false;
        model.swimAmount = 0.0f;
        model.setupAnim((LivingEntity)playerIn, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArmwearIn.xRot = 0.0f;
        rendererArmwearIn.render(matrixStackIn, bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)FROZEN_TEXTURE)), combinedLightIn, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)0.8f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    private static void setModelVisibilities(AbstractClientPlayer clientPlayer, PlayerModel<AbstractClientPlayer> playermodel) {
        if (clientPlayer.isSpectator()) {
            playermodel.setAllVisible(false);
            playermodel.head.visible = true;
            playermodel.hat.visible = true;
        } else {
            playermodel.setAllVisible(true);
            playermodel.hat.visible = clientPlayer.isModelPartShown(PlayerModelPart.HAT);
            playermodel.jacket.visible = clientPlayer.isModelPartShown(PlayerModelPart.JACKET);
            playermodel.leftPants.visible = clientPlayer.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
            playermodel.rightPants.visible = clientPlayer.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
            playermodel.leftSleeve.visible = clientPlayer.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
            playermodel.rightSleeve.visible = clientPlayer.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
            playermodel.crouching = clientPlayer.isCrouching();
        }
    }

    public static class GeckoLayerFrozen<T extends LivingEntity>
    extends GeoRenderLayer<T> {
        public GeckoLayerFrozen(GeoRenderer<T> entityRendererIn, EntityRendererProvider.Context context) {
            super(entityRendererIn);
        }

        public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            if (DataHandler.getData(animatable, DataHandler.FROZEN_DATA).getFrozen()) {
                RenderType frozenRenderType = RenderType.entityTranslucent((ResourceLocation)FROZEN_TEXTURE);
                this.getRenderer().reRender(this.getDefaultBakedModel((GeoAnimatable)animatable), poseStack, bufferSource, animatable, renderType, bufferSource.getBuffer(frozenRenderType), partialTick, packedLight, OverlayTexture.NO_OVERLAY, -1);
            }
        }
    }

    public static class LayerFrozen<T extends LivingEntity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        private final LivingEntityRenderer<T, M> renderer;

        public LayerFrozen(LivingEntityRenderer<T, M> renderer) {
            super(renderer);
            this.renderer = renderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (DataHandler.getData((Entity)living, DataHandler.FROZEN_DATA).getFrozen()) {
                EntityModel model = this.renderer.getModel();
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)FROZEN_TEXTURE));
                model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
        }
    }
}

