/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.neoforge.event;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlockEntities;
import com.cerbon.bosses_of_mass_destruction.config.BMDConfig;
import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.item.BMDItems;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.cerbons_api.api.general.particle.SimpleParticle;
import com.cerbon.cerbons_api.api.general.particle.SimpleParticleProvider;
import com.cerbon.cerbons_api.api.static_utilities.Geometries;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@EventBusSubscriber(modid="bosses_of_mass_destruction", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BMDClientEventsNeo {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BMDItems.initClient();
        BMDEntities.initClient();
        BMDBlockEntities.initClient();
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (modContainer, screen) -> (Screen)AutoConfig.getConfigScreen(BMDConfig.class, (Screen)screen).get());
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)BMDParticles.DISAPPEARING_SWIRL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.SOUL_FLAME.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.COMET_BLUE);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.MAGIC_CIRCLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.scale(4.0f);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_BURST.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.scale(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.ORANGE, (Vec3)Vec3Colors.RUNIC_BROWN));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.ENCHANT.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)30, (int)50), Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_BURST_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ORANGE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_WAVE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.scale(4.0f);
            particle.setColorVariation(0.25);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.RED, (Vec3)Vec3Colors.DARK_RED));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.RED);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.DOWNSPARKLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.COMET_BLUE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_SPIKE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.COMET_BLUE));
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setColorVariation(0.25);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.PILLAR_RUNE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 10, Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.PILLAR_SPAWN_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.scale(2.0f);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.PILLAR_SPAWN_INDICATOR_2.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.OBSIDILITH_ANVIL_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)25, (int)27), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.GAUNTLET_REVIVE_SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.LASER_RED);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.EYE_OPEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)60, (int)70), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.LINE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)20, (int)30), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)8, (int)10), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.GROUND_ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)8, (int)10), Geometries::buildFlatGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.VOID_BLOSSOM_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.VOID_BLOSSOM_SPIKE_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.PETAL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, false, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.POLLEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, false, true);
            particle.setColorOverride(f -> new Vec3(1.0, 0.9, 0.4));
            particle.setColorVariation(0.15);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf(0.05f * (1.0f - f.floatValue() * 0.25f)));
            int randomRot = RandomUtils.range((int)0, (int)360);
            float angularMomentum = (float)RandomUtils.randSign() * 4.0f;
            particle.setRotationOverride(particle1 -> Float.valueOf((float)randomRot + (float)particle1.getAge() * angularMomentum));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.SPORE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.scale(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.GREEN, (Vec3)Vec3Colors.DARK_GREEN));
            particle.setColorVariation(0.25);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.SPORE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.GREEN);
            particle.setColorVariation(0.35);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)BMDParticles.FLUFF.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)BMDParticles.EARTHDIVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, false);
            particle.setColorOverride(f -> Vec3Colors.RUNIC_BROWN);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f - f.floatValue() * 0.25f) * 0.35f));
            return particle;
        }));
    }
}

